/*
 * Decompiled with CFR 0.152.
 */
package com.disketaa.harmonium.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TinSoldierBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final int MAX_SOLDIERS = 4;
    public static final IntegerProperty SOLDIERS = IntegerProperty.create((String)"soldiers", (int)1, (int)4);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE_1_NS = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)7.0, (double)10.0);
    protected static final VoxelShape SHAPE_2_NS = Block.box((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)7.0, (double)12.0);
    protected static final VoxelShape SHAPE_3_NS = Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)7.0, (double)12.0);
    protected static final VoxelShape SHAPE_4_NS = Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)7.0, (double)12.0);
    protected static final VoxelShape SHAPE_1_WE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)7.0, (double)10.0);
    protected static final VoxelShape SHAPE_2_WE = Block.box((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)7.0, (double)10.0);
    protected static final VoxelShape SHAPE_3_WE = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)13.0);
    protected static final VoxelShape SHAPE_4_WE = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)13.0);

    public TinSoldierBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SOLDIERS, (Comparable)Integer.valueOf(1))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canPlaceBlock(BlockState state, LevelReader level, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SOLDIERS, FACING, WATERLOGGED});
    }

    public boolean placeLiquid(@NotNull LevelAccessor level, @NotNull BlockPos pos, BlockState state, @NotNull FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            level.setBlock(pos, (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
            return true;
        }
        return false;
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean isNorthSouth = facing == Direction.NORTH || facing == Direction.SOUTH;
        return switch ((Integer)state.getValue((Property)SOLDIERS)) {
            case 1 -> {
                if (isNorthSouth) {
                    yield SHAPE_1_NS;
                }
                yield SHAPE_1_WE;
            }
            case 2 -> {
                if (isNorthSouth) {
                    yield SHAPE_2_NS;
                }
                yield SHAPE_2_WE;
            }
            case 3 -> {
                if (isNorthSouth) {
                    yield SHAPE_3_NS;
                }
                yield SHAPE_3_WE;
            }
            case 4 -> {
                if (isNorthSouth) {
                    yield SHAPE_4_NS;
                }
                yield SHAPE_4_WE;
            }
            default -> SHAPE_1_NS;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        FluidState fluidstate = level.getFluidState(pos);
        if (!this.canPlaceBlock(this.defaultBlockState(), (LevelReader)level, pos)) {
            return null;
        }
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.is((Block)this)) {
            return (BlockState)((BlockState)blockstate.setValue((Property)SOLDIERS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.getValue((Property)SOLDIERS) + 1)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean canBeReplaced(@NotNull BlockState state, BlockPlaceContext context) {
        return !context.isSecondaryUseActive() && context.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)SOLDIERS) < 4;
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return true;
    }
}

