/*
 * Decompiled with CFR 0.152.
 */
package com.disketaa.harmonium.block.custom;

import com.disketaa.harmonium.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnreliableButtonBlock
extends ButtonBlock {
    private boolean isCurrentPressShort = false;

    public UnreliableButtonBlock(BlockSetType blockSetType, BlockBehaviour.Properties properties) {
        super(blockSetType, Config.tinButtonLongPressDuration, properties);
    }

    public void press(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @Nullable Player player) {
        if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            this.isCurrentPressShort = level.getRandom().nextInt(100) < Config.tinButtonFailureChance;
            int pressDuration = this.isCurrentPressShort ? Config.tinButtonShortPressDuration : Config.tinButtonLongPressDuration;
            boolean shouldOutputSignal = !this.isCurrentPressShort;
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(shouldOutputSignal)), 3);
            if (shouldOutputSignal) {
                this.updateNeighbors(state, level, pos);
            }
            level.scheduleTick(pos, (Block)this, pressDuration);
            this.playSound(player, (LevelAccessor)level, pos, true);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
        }
    }

    protected void tick(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() || this.isCurrentPressShort) {
            boolean wasPowered = (Boolean)state.getValue((Property)POWERED);
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            if (wasPowered) {
                this.updateNeighbors(state, (Level)level, pos);
            }
            this.playSound(null, (LevelAccessor)level, pos, false);
            level.gameEvent(null, (Holder)GameEvent.BLOCK_DEACTIVATE, pos);
        }
    }

    public int getSignal(BlockState blockState, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    private void updateNeighbors(BlockState state, Level level, BlockPos pos) {
        level.updateNeighborsAt(pos, (Block)this);
        level.updateNeighborsAt(pos.relative(UnreliableButtonBlock.getConnectedDirection((BlockState)state).getOpposite()), (Block)this);
    }
}

