/*
 * Decompiled with CFR 0.152.
 */
package com.disketaa.harmonium.entity;

import com.disketaa.harmonium.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;

public class ModEntityArmorEvents {
    private static final List<ArmorSpawnEntry> ARMOR_ENTRIES = new ArrayList<ArmorSpawnEntry>();
    private static final List<ToolSpawnEntry> TOOL_ENTRIES = new ArrayList<ToolSpawnEntry>();

    public static void register() {
        NeoForge.EVENT_BUS.addListener(ModEntityArmorEvents::onMobSpawn);
    }

    public static void registerArmorSet(ArmorSpawnEntry entry) {
        ARMOR_ENTRIES.add(entry);
    }

    public static void registerToolSet(ToolSpawnEntry entry) {
        TOOL_ENTRIES.add(entry);
    }

    private static void onMobSpawn(MobSpawnEvent.PositionCheck event) {
        Mob mob = event.getEntity();
        if (!(mob instanceof Zombie || mob instanceof Skeleton || mob instanceof WitherSkeleton || mob instanceof Stray)) {
            return;
        }
        BlockPos pos = mob.blockPosition();
        RandomSource random = event.getEntity().getRandom();
        DifficultyInstance difficulty = event.getLevel().getCurrentDifficultyAt(pos);
        ModEntityArmorEvents.tryAddArmor((LivingEntity)mob, random, difficulty);
        if (mob instanceof Zombie) {
            ModEntityArmorEvents.tryAddTools((LivingEntity)mob, random, difficulty);
        }
    }

    private static void tryAddArmor(LivingEntity mob, RandomSource random, DifficultyInstance difficulty) {
        float localDifficulty = difficulty.getSpecialMultiplier();
        float chanceMultiplier = mob.level().getDifficulty() == Difficulty.HARD ? 1.5f : 1.0f;
        for (ArmorSpawnEntry entry : ARMOR_ENTRIES) {
            ModEntityArmorEvents.tryAddArmorPiece(mob, random, localDifficulty, chanceMultiplier, entry.helmet(), entry.helmetChance(), EquipmentSlot.HEAD);
            ModEntityArmorEvents.tryAddArmorPiece(mob, random, localDifficulty, chanceMultiplier, entry.chestplate(), entry.chestplateChance(), EquipmentSlot.CHEST);
            ModEntityArmorEvents.tryAddArmorPiece(mob, random, localDifficulty, chanceMultiplier, entry.leggings(), entry.leggingsChance(), EquipmentSlot.LEGS);
            ModEntityArmorEvents.tryAddArmorPiece(mob, random, localDifficulty, chanceMultiplier, entry.boots(), entry.bootsChance(), EquipmentSlot.FEET);
        }
    }

    private static void tryAddTools(LivingEntity mob, RandomSource random, DifficultyInstance difficulty) {
        float localDifficulty = difficulty.getSpecialMultiplier();
        float chanceMultiplier = mob.level().getDifficulty() == Difficulty.HARD ? 1.5f : 1.0f;
        for (ToolSpawnEntry entry : TOOL_ENTRIES) {
            ModEntityArmorEvents.tryAddTool(mob, random, localDifficulty, chanceMultiplier, entry.sword(), entry.swordChance());
            ModEntityArmorEvents.tryAddTool(mob, random, localDifficulty, chanceMultiplier, entry.shovel(), entry.shovelChance());
        }
    }

    private static void tryAddArmorPiece(LivingEntity mob, RandomSource random, float localDifficulty, float chanceMultiplier, Supplier<Item> armorItem, float baseChance, EquipmentSlot slot) {
        float chance = baseChance * chanceMultiplier * (1.0f + localDifficulty);
        if (mob.getItemBySlot(slot).isEmpty() && random.nextFloat() < chance) {
            mob.setItemSlot(slot, new ItemStack((ItemLike)armorItem.get()));
        }
    }

    private static void tryAddTool(LivingEntity mob, RandomSource random, float localDifficulty, float chanceMultiplier, Supplier<Item> toolItem, float baseChance) {
        if (mob.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
            float chance = baseChance * chanceMultiplier * (1.0f + localDifficulty);
            if (random.nextFloat() < chance) {
                mob.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)toolItem.get()));
            }
        }
    }

    static {
        ModEntityArmorEvents.registerArmorSet(new ArmorSpawnEntry(() -> ModItems.BRONZE_HELMET.get(), () -> ModItems.BRONZE_CHESTPLATE.get(), () -> ModItems.BRONZE_LEGGINGS.get(), () -> ModItems.BRONZE_BOOTS.get(), 0.07f, 0.05f, 0.06f, 0.08f));
        ModEntityArmorEvents.registerToolSet(new ToolSpawnEntry(() -> ModItems.BRONZE_SWORD.get(), () -> ModItems.BRONZE_SHOVEL.get(), 0.03f, 0.02f));
    }

    public record ArmorSpawnEntry(Supplier<Item> helmet, Supplier<Item> chestplate, Supplier<Item> leggings, Supplier<Item> boots, float helmetChance, float chestplateChance, float leggingsChance, float bootsChance) {
    }

    public record ToolSpawnEntry(Supplier<Item> sword, Supplier<Item> shovel, float swordChance, float shovelChance) {
    }
}

