/*
 * Decompiled with CFR 0.152.
 */
package com.disketaa.harmonium.gui;

import com.disketaa.harmonium.Config;
import com.disketaa.harmonium.block.ModBlocks;
import com.disketaa.harmonium.item.FarmersDelightModItems;
import com.disketaa.harmonium.item.FriendsAndFoesModItems;
import com.disketaa.harmonium.item.ModItems;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class ModCreativeTabOrganizer {
    @SubscribeEvent
    public static void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (!Config.addHarmoniumItemsToOtherCreativeTabs) {
            return;
        }
        ResourceLocation tabId = event.getTabKey().location();
        if (tabId.equals((Object)CreativeModeTabs.BUILDING_BLOCKS.location())) {
            ModCreativeTabOrganizer.addAfter(event, Items.WAXED_OXIDIZED_COPPER_BULB, List.of(ModBlocks.TIN_BLOCK, ModBlocks.CHISELED_TIN, ModBlocks.TIN_GRATE, ModBlocks.CUT_TIN, ModBlocks.CUT_TIN_STAIRS, ModBlocks.CUT_TIN_SLAB, ModBlocks.TIN_DOOR, ModBlocks.TIN_TRAPDOOR, ModBlocks.TIN_BULB, ModBlocks.BRONZE_BLOCK, ModBlocks.CHISELED_BRONZE, ModBlocks.BRONZE_GRATE, ModBlocks.CUT_BRONZE, ModBlocks.CUT_BRONZE_STAIRS, ModBlocks.CUT_BRONZE_SLAB, ModBlocks.BRONZE_DOOR, ModBlocks.BRONZE_TRAPDOOR, ModBlocks.BRONZE_BULB));
        }
        if (tabId.equals((Object)CreativeModeTabs.COLORED_BLOCKS.location())) {
            ModCreativeTabOrganizer.addAfter(event, Items.PINK_CANDLE, List.of(ModBlocks.TIN_SOLDIER, ModBlocks.WHITE_TIN_SOLDIER, ModBlocks.LIGHT_GRAY_TIN_SOLDIER, ModBlocks.GRAY_TIN_SOLDIER, ModBlocks.BLACK_TIN_SOLDIER, ModBlocks.BROWN_TIN_SOLDIER, ModBlocks.RED_TIN_SOLDIER, ModBlocks.ORANGE_TIN_SOLDIER, ModBlocks.YELLOW_TIN_SOLDIER, ModBlocks.LIME_TIN_SOLDIER, ModBlocks.GREEN_TIN_SOLDIER, ModBlocks.CYAN_TIN_SOLDIER, ModBlocks.LIGHT_BLUE_TIN_SOLDIER, ModBlocks.BLUE_TIN_SOLDIER, ModBlocks.PURPLE_TIN_SOLDIER, ModBlocks.MAGENTA_TIN_SOLDIER, ModBlocks.PINK_TIN_SOLDIER));
        }
        if (tabId.equals((Object)CreativeModeTabs.NATURAL_BLOCKS.location())) {
            ModCreativeTabOrganizer.removeEntry(event, Items.IRON_ORE);
            ModCreativeTabOrganizer.removeEntry(event, Items.DEEPSLATE_IRON_ORE);
            ModCreativeTabOrganizer.addAfter(event, Items.DEEPSLATE_COPPER_ORE, List.of(ModBlocks.TIN_ORE, ModBlocks.DEEPSLATE_TIN_ORE, Items.IRON_ORE, Items.DEEPSLATE_IRON_ORE));
            ModCreativeTabOrganizer.removeEntry(event, Items.RAW_COPPER_BLOCK);
            ModCreativeTabOrganizer.addBefore(event, Items.RAW_IRON_BLOCK, List.of(Items.RAW_COPPER_BLOCK, ModBlocks.RAW_TIN_BLOCK, ModBlocks.BRONZE_BLEND_BLOCK));
        }
        if (tabId.equals((Object)CreativeModeTabs.FUNCTIONAL_BLOCKS.location())) {
            ModCreativeTabOrganizer.addAfter(event, Items.WAXED_OXIDIZED_COPPER_BULB, List.of(ModBlocks.TIN_BULB, ModBlocks.BRONZE_BULB));
            ModCreativeTabOrganizer.addAfter(event, Items.PINK_CANDLE, List.of(ModBlocks.TIN_SOLDIER, ModBlocks.WHITE_TIN_SOLDIER, ModBlocks.LIGHT_GRAY_TIN_SOLDIER, ModBlocks.GRAY_TIN_SOLDIER, ModBlocks.BLACK_TIN_SOLDIER, ModBlocks.BROWN_TIN_SOLDIER, ModBlocks.RED_TIN_SOLDIER, ModBlocks.ORANGE_TIN_SOLDIER, ModBlocks.YELLOW_TIN_SOLDIER, ModBlocks.LIME_TIN_SOLDIER, ModBlocks.GREEN_TIN_SOLDIER, ModBlocks.CYAN_TIN_SOLDIER, ModBlocks.LIGHT_BLUE_TIN_SOLDIER, ModBlocks.BLUE_TIN_SOLDIER, ModBlocks.PURPLE_TIN_SOLDIER, ModBlocks.MAGENTA_TIN_SOLDIER, ModBlocks.PINK_TIN_SOLDIER));
        }
        if (tabId.equals((Object)CreativeModeTabs.REDSTONE_BLOCKS.location())) {
            ModCreativeTabOrganizer.addAfter(event, Items.WAXED_OXIDIZED_COPPER_BULB, List.of(ModBlocks.TIN_BULB, ModBlocks.BRONZE_BULB));
            if (ModList.get().isLoaded("friendsandfoes") && FriendsAndFoesModItems.WAXED_OXIDIZED_COPPER_BUTTON != Items.AIR) {
                ModCreativeTabOrganizer.addAfter(event, FriendsAndFoesModItems.WAXED_OXIDIZED_COPPER_BUTTON, List.of(ModBlocks.TIN_BUTTON, ModBlocks.BRONZE_BUTTON));
            }
        }
        if (tabId.equals((Object)CreativeModeTabs.TOOLS_AND_UTILITIES.location())) {
            ModCreativeTabOrganizer.addAfter(event, Items.STONE_HOE, List.of(ModItems.BRONZE_SHOVEL, ModItems.BRONZE_PICKAXE, ModItems.BRONZE_AXE, ModItems.BRONZE_HOE));
        }
        if (tabId.equals((Object)CreativeModeTabs.COMBAT.location())) {
            ModCreativeTabOrganizer.addAfter(event, Items.STONE_SWORD, List.of(ModItems.BRONZE_SWORD));
            ModCreativeTabOrganizer.addAfter(event, Items.STONE_AXE, List.of(ModItems.BRONZE_AXE));
            ModCreativeTabOrganizer.addAfter(event, Items.LEATHER_BOOTS, List.of(ModItems.BRONZE_HELMET, ModItems.BRONZE_CHESTPLATE, ModItems.BRONZE_LEGGINGS, ModItems.BRONZE_BOOTS));
            ModCreativeTabOrganizer.addAfter(event, Items.LEATHER_HORSE_ARMOR, List.of(ModItems.BRONZE_HORSE_ARMOR));
        }
        if (tabId.equals((Object)CreativeModeTabs.INGREDIENTS.location())) {
            ModCreativeTabOrganizer.removeEntry(event, Items.RAW_IRON);
            ModCreativeTabOrganizer.addAfter(event, Items.RAW_COPPER, List.of(ModItems.BRONZE_BLEND, ModItems.RAW_TIN, Items.RAW_IRON));
            ModCreativeTabOrganizer.removeEntry(event, Items.NETHERITE_SCRAP);
            ModCreativeTabOrganizer.addBefore(event, Items.ANCIENT_DEBRIS, List.of(Items.NETHERITE_SCRAP));
            ModCreativeTabOrganizer.addBefore(event, Items.IRON_NUGGET, List.of(ModItems.COPPER_NUGGET, ModItems.TIN_NUGGET, ModItems.BRONZE_NUGGET));
            ModCreativeTabOrganizer.removeEntry(event, Items.IRON_INGOT);
            ModCreativeTabOrganizer.addAfter(event, Items.COPPER_INGOT, List.of(ModItems.TIN_INGOT, ModItems.BRONZE_INGOT, Items.IRON_INGOT));
        }
        if (tabId.equals((Object)ResourceLocation.parse((String)"farmersdelight:farmersdelight")) && FarmersDelightModItems.IRON_KNIFE != Items.AIR) {
            assert (ModItems.BRONZE_KNIFE != null);
            assert (ModItems.WOODEN_KNIFE != null);
            ModCreativeTabOrganizer.addBefore(event, FarmersDelightModItems.IRON_KNIFE, List.of(ModItems.WOODEN_KNIFE, ModItems.BRONZE_KNIFE));
        }
    }

    private static void addRelative(BuildCreativeModeTabContentsEvent event, Item referenceItem, List<ItemLike> itemsToAdd, boolean insertBefore) {
        boolean foundReference = false;
        ItemStack referenceStack = null;
        for (ItemStack stack : event.getParentEntries()) {
            if (!stack.is(referenceItem)) continue;
            foundReference = true;
            referenceStack = stack;
            break;
        }
        if (foundReference) {
            if (insertBefore) {
                for (ItemLike itemLike : itemsToAdd) {
                    ItemStack stack = itemLike.asItem().getDefaultInstance();
                    event.insertBefore(referenceStack, stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            } else {
                for (int i = itemsToAdd.size() - 1; i >= 0; --i) {
                    ItemLike itemLike;
                    itemLike = itemsToAdd.get(i);
                    ItemStack stack = itemLike.asItem().getDefaultInstance();
                    event.insertAfter(referenceStack, stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
        } else {
            for (ItemLike itemLike : itemsToAdd) {
                event.accept(itemLike);
            }
        }
    }

    private static void addBefore(BuildCreativeModeTabContentsEvent event, Item referenceItem, List<ItemLike> itemsToAdd) {
        ModCreativeTabOrganizer.addRelative(event, referenceItem, itemsToAdd, true);
    }

    private static void addAfter(BuildCreativeModeTabContentsEvent event, Item referenceItem, List<ItemLike> itemsToAdd) {
        ModCreativeTabOrganizer.addRelative(event, referenceItem, itemsToAdd, false);
    }

    private static void removeEntry(BuildCreativeModeTabContentsEvent event, Item itemToRemove) {
        event.remove(itemToRemove.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }
}

