/*
 * Decompiled with CFR 0.152.
 */
package com.disketaa.harmonium.item;

import com.disketaa.harmonium.item.ModItems;
import com.disketaa.harmonium.sound.ModSoundType;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModArmorMaterials {
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"harmonium");
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> BRONZE_ARMOR_MATERIAL = ModArmorMaterials.register("bronze", ModArmorMaterials.makeBronzeArmorMaterial());

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> register(String name, ArmorMaterial material) {
        return ARMOR_MATERIALS.register(name, () -> material);
    }

    private static ArmorMaterial makeBronzeArmorMaterial() {
        EnumMap<ArmorItem.Type, Integer> protection = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        protection.put(ArmorItem.Type.BOOTS, 2);
        protection.put(ArmorItem.Type.LEGGINGS, 3);
        protection.put(ArmorItem.Type.CHESTPLATE, 4);
        protection.put(ArmorItem.Type.HELMET, 2);
        protection.put(ArmorItem.Type.BODY, 4);
        return new ArmorMaterial(protection, 15, ModSoundType.ARMOR_EQUIP_BRONZE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BRONZE_INGOT.get()}), List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"harmonium", (String)"bronze"))), 0.0f, 0.0f);
    }

    public static void register(IEventBus eventBus) {
        ARMOR_MATERIALS.register(eventBus);
    }
}

