/*
 * Decompiled with CFR 0.152.
 */
package com.disketaa.harmonium.item;

import com.disketaa.harmonium.item.ModArmorMaterials;
import com.disketaa.harmonium.item.ModToolTiers;
import com.disketaa.harmonium.item.custom.KnifeItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"harmonium");
    private static final List<DeferredItem<? extends Item>> REGISTERED_ITEMS = new ArrayList<DeferredItem<? extends Item>>();
    public static final DeferredItem<Item> RAW_TIN = ModItems.registerSimpleItem("raw_tin");
    public static final DeferredItem<Item> BRONZE_BLEND = ModItems.registerSimpleItem("bronze_blend");
    public static final DeferredItem<Item> COPPER_NUGGET = ModItems.registerSimpleItem("copper_nugget");
    public static final DeferredItem<Item> TIN_NUGGET = ModItems.registerSimpleItem("tin_nugget");
    public static final DeferredItem<Item> BRONZE_NUGGET = ModItems.registerSimpleItem("bronze_nugget");
    public static final DeferredItem<Item> TIN_INGOT = ModItems.registerSimpleItem("tin_ingot");
    public static final DeferredItem<Item> BRONZE_INGOT = ModItems.registerSimpleItem("bronze_ingot");
    public static final DeferredItem<KnifeItem> WOODEN_KNIFE = ModItems.registerConditionalTool("wooden_knife", () -> ModItems.registerKnifeItem("wooden_knife", (Tier)Tiers.WOOD, 0.5f, -2.0f), "farmersdelight");
    public static final DeferredItem<KnifeItem> BRONZE_KNIFE = ModItems.registerConditionalTool("bronze_knife", () -> ModItems.registerKnifeItem("bronze_knife", ModToolTiers.BRONZE, 0.5f, -2.0f), "farmersdelight");
    public static final DeferredItem<ShovelItem> BRONZE_SHOVEL = ModItems.registerShovelItem("bronze_shovel", ModToolTiers.BRONZE, 1.5f, -3.0f);
    public static final DeferredItem<PickaxeItem> BRONZE_PICKAXE = ModItems.registerPickaxeItem("bronze_pickaxe", ModToolTiers.BRONZE, 1.0f, -2.8f);
    public static final DeferredItem<AxeItem> BRONZE_AXE = ModItems.registerAxeItem("bronze_axe", ModToolTiers.BRONZE, 7.0f, -3.2f);
    public static final DeferredItem<HoeItem> BRONZE_HOE = ModItems.registerHoeItem("bronze_hoe", ModToolTiers.BRONZE, -1.0f, -2.0f);
    public static final DeferredItem<SwordItem> BRONZE_SWORD = ModItems.registerSwordItem("bronze_sword", ModToolTiers.BRONZE, 3, -2.4f);
    public static final DeferredItem<ArmorItem> BRONZE_HELMET = ModItems.registerArmorItem("bronze_helmet", ModArmorMaterials.BRONZE_ARMOR_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<ArmorItem> BRONZE_CHESTPLATE = ModItems.registerArmorItem("bronze_chestplate", ModArmorMaterials.BRONZE_ARMOR_MATERIAL, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<ArmorItem> BRONZE_LEGGINGS = ModItems.registerArmorItem("bronze_leggings", ModArmorMaterials.BRONZE_ARMOR_MATERIAL, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<ArmorItem> BRONZE_BOOTS = ModItems.registerArmorItem("bronze_boots", ModArmorMaterials.BRONZE_ARMOR_MATERIAL, ArmorItem.Type.BOOTS);
    public static final DeferredItem<Item> BRONZE_HORSE_ARMOR = ModItems.registerHorseArmorItem("bronze_horse_armor", ModArmorMaterials.BRONZE_ARMOR_MATERIAL, AnimalArmorItem.BodyType.EQUESTRIAN, false);

    private static DeferredItem<Item> registerSimpleItem(String name) {
        DeferredItem item = ITEMS.register(name, () -> new Item(new Item.Properties()));
        REGISTERED_ITEMS.add((DeferredItem<? extends Item>)item);
        return item;
    }

    public static DeferredItem<KnifeItem> registerKnifeItem(String name, Tier tier, float attackDamage, float attackSpeed) {
        DeferredItem item = ITEMS.register(name, () -> new KnifeItem(tier, attackDamage, attackSpeed, new Item.Properties()));
        REGISTERED_ITEMS.add((DeferredItem<? extends Item>)item);
        return item;
    }

    public static DeferredItem<SwordItem> registerSwordItem(String name, Tier tier, int attackDamage, float attackSpeed) {
        DeferredItem item = ITEMS.register(name, () -> new SwordItem(tier, new Item.Properties().component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)SwordItem.createAttributes((Tier)tier, (int)attackDamage, (float)attackSpeed)).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f)), 1.0f, 2))));
        REGISTERED_ITEMS.add((DeferredItem<? extends Item>)item);
        return item;
    }

    public static DeferredItem<ShovelItem> registerShovelItem(String name, Tier tier, float attackDamage, float attackSpeed) {
        DeferredItem item = ITEMS.register(name, () -> new ShovelItem(tier, new Item.Properties().component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ShovelItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed)).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.minesAndDrops((TagKey)BlockTags.MINEABLE_WITH_SHOVEL, (float)tier.getSpeed())), 1.0f, tier.getUses()))));
        REGISTERED_ITEMS.add((DeferredItem<? extends Item>)item);
        return item;
    }

    public static DeferredItem<PickaxeItem> registerPickaxeItem(String name, Tier tier, float attackDamage, float attackSpeed) {
        DeferredItem item = ITEMS.register(name, () -> new PickaxeItem(tier, new Item.Properties().component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)PickaxeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed)).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.minesAndDrops((TagKey)BlockTags.MINEABLE_WITH_PICKAXE, (float)tier.getSpeed())), 1.0f, tier.getUses()))));
        REGISTERED_ITEMS.add((DeferredItem<? extends Item>)item);
        return item;
    }

    public static DeferredItem<AxeItem> registerAxeItem(String name, Tier tier, float attackDamage, float attackSpeed) {
        DeferredItem item = ITEMS.register(name, () -> new AxeItem(tier, new Item.Properties().component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)AxeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed)).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.minesAndDrops((TagKey)BlockTags.MINEABLE_WITH_AXE, (float)tier.getSpeed())), 1.0f, tier.getUses()))));
        REGISTERED_ITEMS.add((DeferredItem<? extends Item>)item);
        return item;
    }

    public static DeferredItem<HoeItem> registerHoeItem(String name, Tier tier, float attackDamage, float attackSpeed) {
        DeferredItem item = ITEMS.register(name, () -> new HoeItem(tier, new Item.Properties().component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)HoeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed)).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.minesAndDrops((TagKey)BlockTags.MINEABLE_WITH_HOE, (float)tier.getSpeed())), 1.0f, tier.getUses()))));
        REGISTERED_ITEMS.add((DeferredItem<? extends Item>)item);
        return item;
    }

    private static DeferredItem<ArmorItem> registerArmorItem(String name, Holder<ArmorMaterial> material, ArmorItem.Type type) {
        DeferredItem item = ITEMS.register(name, () -> new ArmorItem(material, type, new Item.Properties().durability(type.getDurability(10))));
        REGISTERED_ITEMS.add((DeferredItem<? extends Item>)item);
        return item;
    }

    private static DeferredItem<Item> registerHorseArmorItem(String name, Holder<ArmorMaterial> material, AnimalArmorItem.BodyType bodyType, boolean isFireResistant) {
        DeferredItem item = ITEMS.register(name, () -> new AnimalArmorItem(material, bodyType, isFireResistant, new Item.Properties().stacksTo(1)));
        REGISTERED_ITEMS.add((DeferredItem<? extends Item>)item);
        return item;
    }

    private static <T extends Item> DeferredItem<T> registerConditionalTool(String name, Supplier<DeferredItem<T>> supplier, String requiredMod) {
        if (ModList.get().isLoaded(requiredMod)) {
            DeferredItem<T> item = supplier.get();
            REGISTERED_ITEMS.add(item);
            return item;
        }
        return null;
    }

    public static List<DeferredItem<? extends Item>> getRegisteredItems() {
        return new ArrayList<DeferredItem<? extends Item>>(REGISTERED_ITEMS);
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

