/*
 * Decompiled with CFR 0.152.
 */
package com.disketaa.harmonium.util;

import com.disketaa.harmonium.Config;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class ModConditions {
    public static final Map<String, MapCodec<? extends ICondition>> SERIALIZERS = new HashMap<String, MapCodec<? extends ICondition>>();
    public static final MapCodec<ConfigValueCondition> CONFIG_CODEC = ModConditions.register("config", ConfigValueCondition.CODEC);

    public static <T extends ICondition> MapCodec<T> register(String name, MapCodec<T> codec) {
        SERIALIZERS.put(name, codec);
        return codec;
    }

    public static ConfigValueCondition config(ModConfigSpec.ConfigValue<?> value, String key, boolean inverted) {
        return new ConfigValueCondition(value, key, Maps.newHashMap(), inverted);
    }

    public static ConfigValueCondition config(ModConfigSpec.ConfigValue<?> value, String key) {
        return ModConditions.config(value, key, false);
    }

    public record ConfigValueCondition(ModConfigSpec.ConfigValue<?> value, String key, Map<String, String> data, boolean inverted) implements ICondition
    {
        public static final MapCodec<ConfigValueCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("value").forGetter(ConfigValueCondition::key), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("data", (Object)Maps.newHashMap()).forGetter(ConfigValueCondition::data), (App)Codec.BOOL.optionalFieldOf("inverted", (Object)false).forGetter(ConfigValueCondition::inverted)).apply((Applicative)builder, (key, data, inverted) -> new ConfigValueCondition(null, (String)key, (Map<String, String>)data, (boolean)inverted)));

        public boolean test(@NotNull ICondition.IContext context) {
            if ("tin_generation".equals(this.key)) {
                return Config.tinGeneration;
            }
            if ("remove_stone_tools".equals(this.key)) {
                return this.inverted != Config.removeStoneTools;
            }
            if ("remove_flint_knife".equals(this.key)) {
                return this.inverted != Config.removeFlintKnife;
            }
            if (this.value != null && this.value.get() instanceof Boolean) {
                return this.inverted != (Boolean)this.value.get();
            }
            return this.inverted;
        }

        @NotNull
        public MapCodec<? extends ICondition> codec() {
            return CODEC;
        }
    }
}

