/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc;

import com.jab125.mpuc.Mpuc;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.config.MpucConfig;
import com.jab125.mpuc.util.OnlineInfo;
import com.jab125.mpuc.util.Platform;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class Hotfixes {
    public static HashMap<String, String> currentHashes = new HashMap();
    public static HashMap<String, String> hotfixHashes = new HashMap();
    public static volatile boolean hotfixAvailable = false;
    public static List<String> availableHotfixes = new ArrayList<String>();
    public static volatile boolean hotfixesEnabled = true;

    public static void init() throws IOException, InterruptedException {
        if (Platform.getEnvironment() == Platform.Environment.SERVER) {
            return;
        }
        OnlineInfo info = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo();
        if (info.isDisabled() || info.isErrored() || MpucConfig.getId((Object)ConfigInstances.getModpackUpdateCheckerConfig().type) == 3) {
            System.out.println("Aborting hotfixes check");
            hotfixesEnabled = false;
            return;
        }
        System.out.println("Fetching available hotfixes...");
        long currentTimeMillis = System.currentTimeMillis();
        currentHashes = new HashMap();
        hotfixAvailable = false;
        hotfixHashes = new HashMap();
        availableHotfixes = new ArrayList<String>();
        String hashes = null;
        try {
            MpucConfig config = ConfigInstances.getModpackUpdateCheckerConfig();
            hashes = Mpuc.fetchUrlAsString(config.updateCheckerId + "hashes/" + config.currentVersion + "/hashes.txt");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (hashes.endsWith("\n")) {
            hashes = hashes.substring(0, hashes.length() - 1);
        }
        for (String s : hashes.split("\n")) {
            Object[] f = s.split("\\|");
            try {
                if (Hotfixes.isWhitelisted(f[0])) {
                    hotfixHashes.put((String)f[0], (String)f[1]);
                    continue;
                }
                System.err.println((String)f[0] + " can't be hotfixed!");
            }
            catch (Exception e) {
                System.out.println("Failed with " + Arrays.toString(f));
                e.printStackTrace();
            }
        }
        Hotfixes.searchForHotfixes(Platform.getGameDir().toFile());
        for (Map.Entry entry : hotfixHashes.entrySet()) {
            if (currentHashes.containsKey(entry.getKey())) {
                if (currentHashes.get(entry.getKey()).equals(entry.getValue())) continue;
                availableHotfixes.add((String)entry.getKey());
                hotfixAvailable = true;
                continue;
            }
            availableHotfixes.add((String)entry.getKey());
            hotfixAvailable = true;
        }
        System.out.println(String.format("Found %s hotfixes in %s ms", availableHotfixes.size(), System.currentTimeMillis() - currentTimeMillis));
    }

    private static boolean isWhitelisted(String path) {
        return !path.contains(".DS_Store") && (Hotfixes.is(path, "options.txt") && Hotfixes.isClientSide() || Hotfixes.startsWithEither(path, "config/", "defaultconfigs/", "resourcepacks/", "local/"));
    }

    private static boolean isClientSide() {
        return true;
    }

    private static boolean is(String path, String ... with) {
        for (String s : with) {
            if (!s.equals(path)) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWithEither(String a, String ... with) {
        for (String s : with) {
            if (!a.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static void searchForHotfixes(File c) throws IOException {
        for (Map.Entry<String, String> hotfixHash : hotfixHashes.entrySet()) {
            File file = c.toPath().resolve(hotfixHash.getKey()).toFile();
            if (!file.isFile()) continue;
            byte[] hash = Hotfixes.getDigest(file);
            String checksum = new BigInteger(1, hash).toString(16);
            Path path = Platform.getGameDir().relativize(file.toPath());
            currentHashes.put(path.toString(), checksum);
        }
    }

    private static byte[] getDigest(File file) throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getSha256Digest(), (File)file);
    }

    public static byte[] fetchUrlAsBytes(String s) throws IOException, InterruptedException {
        HttpResponse<byte[]> d = HttpClient.newHttpClient().send(HttpRequest.newBuilder().GET().uri(URI.create(s.replaceAll(" ", "%20"))).build(), HttpResponse.BodyHandlers.ofByteArray());
        return d.body();
    }
}

