/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc;

import com.jab125.mpuc.Hotfixes;
import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.config.MpucConfig;
import com.jab125.mpuc.config.PlatformMods;
import com.jab125.mpuc.recipe.ChangelogBookRecipe;
import com.jab125.mpuc.util.Events;
import com.jab125.mpuc.util.OnlineInfo;
import com.jab125.mpuc.util.Platform;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;

public class Mpuc
implements ModInitializer {
    public static final String OBJECT_SHARE_CONFIG = "modpack-update-checker:mpuc-config";
    public static final int MPUC_PROTOCOL_VERSION = 15;
    public static final String RANDOM_UUID = UUID.randomUUID().toString();

    public void onInitialize() {
        ConfigInstances.setModpackUpdateCheckerConfig(MpucConfig.load());
        ConfigInstances.setPlatformMods(PlatformMods.deserialize());
        System.out.println("[Modpack Update Checker] Loaded configuration file.");
        this.fetchOnlineInfo();
        Events.CONFIG_RELOADED.subscribe(a -> {
            this.fetchOnlineInfo();
            this.putInObjectShare();
            try {
                Hotfixes.init();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            Hotfixes.init();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.putInObjectShare();
        ChangelogBookRecipe.register();
    }

    private void putInObjectShare() {
        FabricLoader.getInstance().getObjectShare().put(OBJECT_SHARE_CONFIG, (Object)ConfigInstances.getModpackUpdateCheckerConfig());
    }

    private OnlineInfo fetchOnlineInfo() {
        return OnlineInfo.create(ConfigInstances.getModpackUpdateCheckerConfig());
    }

    public static String fetchUrlAsString(String s) throws IOException, InterruptedException {
        if (Platform.isDevelopmentEnvironment() && s.startsWith("local/")) {
            s = s.replaceAll("%20", " ");
            return Files.readString(Platform.getGameDir().resolve(".local").resolve(s.substring("local/".length())));
        }
        String userAgent = "%s/%s".formatted("Modpack-Update-Checker/modpackUpdateChecker", MpucApi.getInstance().getModVersion());
        HttpResponse<String> d = HttpClient.newHttpClient().send(HttpRequest.newBuilder().GET().header("User-Agent", userAgent).uri(URI.create(s)).build(), HttpResponse.BodyHandlers.ofString());
        return d.body();
    }
}

