/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.screen.changelog;

import com.jab125.mpuc.Hotfixes;
import com.jab125.mpuc.api.MarkdownRenderer;
import com.jab125.mpuc.client.gui.screen.HotfixScreen;
import com.jab125.mpuc.client.gui.screen.TemplateScreen;
import com.jab125.mpuc.client.gui.widget.ScrollableFlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.FlowMarkdownUtils;
import com.jab125.mpuc.client.gui.widget.flow.widgets.ChangelogVersionButtonWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.FlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.InfoButtonWidget;
import com.jab125.mpuc.client.util.ButtonUtils;
import com.jab125.mpuc.client.util.Context;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.util.OnlineInfo;
import com.jab125.mpuc.util.Platform;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class NewChangelogScreen
extends TemplateScreen {
    private final class_437 parent;
    private ScrollableFlowWidget changelogFlowWidget;
    private ScrollableFlowWidget versionsFlowWidget;
    private class_4185 markdownSwitchButton;
    private MarkdownRenderer renderer;
    private final Map<String, OnlineInfo.Version> versions;
    private OnlineInfo.Version currentVersion;
    private class_4185 modrinthButton;
    private class_4185 downloadButton;
    private class_4185 curseforgeButton;

    public NewChangelogScreen(class_437 parent) {
        super((class_2561)class_2561.method_43473());
        String markdownRenderer;
        this.versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
        this.currentVersion = null;
        this.parent = parent;
        if (Platform.mpucAuthor()) {
            ConfigInstances.getModpackUpdateCheckerConfig().clearCachedText();
        }
        this.renderer = FlowMarkdownUtils.isAvailable(markdownRenderer = ConfigInstances.getModpackUpdateCheckerConfig().markdownRenderer) ? FlowMarkdownUtils.COMPILERS.get(markdownRenderer) : (FlowMarkdownUtils.isAvailable("builtin:mpuc_lavendermd") ? FlowMarkdownUtils.COMPILERS.get("builtin:mpuc_lavendermd") : MarkdownRenderer.BASIC);
    }

    protected void method_25426() {
        double changelogScrollAmount = this.getChangelogScrollAmount();
        double versionsScrollAmount = this.getVersionsScrollAmount();
        super.method_25426();
        int changelogPaneWidth = this.field_22789 / 3 * 2;
        int left = this.field_22789 - changelogPaneWidth;
        int right = this.field_22789 - 4;
        int width = (right - left) / 3 - 2;
        this.modrinthButton = this.createButton(left, 78, width, 20, (class_2561)class_2561.method_43470((String)"Modrinth"), b -> ButtonUtils.confirmLink(this, false, this.currentVersion.promotions.getDownloadLink("modrinth")));
        this.modrinthButton.field_22763 = this.currentVersion != null && this.currentVersion.promotions != null && this.currentVersion.promotions.hasDownloadLinks() && this.currentVersion.promotions.getDownloadLinkOptional("modrinth").isPresent();
        this.downloadButton = this.createButton(left + width + 2, 78, width, 20, (class_2561)class_2561.method_43470((String)"Generic"), b -> ButtonUtils.confirmLink(this, false, this.currentVersion.promotions.getDownloadLink("generic")));
        this.downloadButton.field_22763 = this.currentVersion != null && this.currentVersion.promotions != null && this.currentVersion.promotions.hasDownloadLinks() && this.currentVersion.promotions.getDownloadLinkOptional("generic").isPresent();
        this.curseforgeButton = this.createButton(left + width * 2 + 4, 78, width, 20, (class_2561)class_2561.method_43470((String)"CurseForge"), b -> ButtonUtils.confirmLink(this, false, this.currentVersion.promotions.getDownloadLink("curseforge")));
        this.curseforgeButton.field_22763 = this.currentVersion != null && this.currentVersion.promotions != null && this.currentVersion.promotions.hasDownloadLinks() && this.currentVersion.promotions.getDownloadLinkOptional("curseforge").isPresent();
        this.changelogFlowWidget = new ScrollableFlowWidget(this.field_22787, changelogPaneWidth, this.field_22790 - 70, 102, this.field_22790 - 32);
        this.method_37063((class_364)this.changelogFlowWidget);
        this.changelogFlowWidget.method_25333(this.field_22789 - changelogPaneWidth);
        this.addButtonWidget(this.modrinthButton);
        this.addButtonWidget(this.downloadButton);
        this.addButtonWidget(this.curseforgeButton);
        int versionsPaneWidth = this.field_22789 - changelogPaneWidth - 6;
        this.markdownSwitchButton = this.createButton(versionsPaneWidth - 34 - 6 - 20, this.field_22790 - 20 - 32, 54, 20, (class_2561)class_2561.method_43473(), b -> this.markdownToggled(), this::markdownButtonTooltip);
        this.setRenderer(this.renderer);
        int o = 0;
        this.versionsFlowWidget = new ScrollableFlowWidget(this.field_22787, versionsPaneWidth, this.field_22790 - 20, 32, this.field_22790 - 20 - 32 - o);
        this.method_37063((class_364)this.versionsFlowWidget);
        for (Map.Entry<String, OnlineInfo.Version> version : this.versions.entrySet()) {
            if (!ConfigInstances.getModpackUpdateCheckerConfig().tags.passes(version.getValue().tags)) continue;
            this.versionsFlowWidget.addChild(0, new ChangelogVersionButtonWidget(this.field_22787, this, version.getValue(), versionsPaneWidth));
        }
        this.versionsFlowWidget.addChild(0, new InfoButtonWidget(this.field_22787, this, versionsPaneWidth));
        this.versionsFlowWidget.addChild(FlowMarkdownUtils.process(versionsPaneWidth - 20, versionsPaneWidth - 20, 0, ""));
        this.versionsFlowWidget.addChild(new FlowWidget(this.field_22787, 0, 20, FlowWidget.Direction.VERTICAL));
        if (!Hotfixes.hotfixAvailable) {
            this.addButtonWidget(this.createButton(this.field_22789 / 2 - 100, this.field_22790 - 25, 200, 20, class_5244.field_24334, button -> this.field_22787.method_1507(this.parent)));
        } else {
            this.addButtonWidget(this.createButton(this.field_22789 / 2 - 100, this.field_22790 - 25, 98, 20, class_5244.field_24334, button -> this.field_22787.method_1507(this.parent)));
            this.addButtonWidget(this.createButton(this.field_22789 / 2 + 2, this.field_22790 - 25, 98, 20, (class_2561)class_2561.method_43471((String)"screen.modpack-update-checker.hotfix.title"), button -> this.field_22787.method_1507((class_437)new HotfixScreen(this))));
        }
        this.addCredits();
        this.addButtonWidget(this.markdownSwitchButton);
        this.changelogFlowWidget.method_25307(changelogScrollAmount);
        this.versionsFlowWidget.method_25307(versionsScrollAmount);
    }

    private void setRenderer(MarkdownRenderer renderer) {
        this.renderer = renderer;
        this.markdownSwitchButton.method_25355((class_2561)class_2561.method_43471((String)this.renderer.getDisplayNameTranslationKey()));
        this.changelogFlowWidget.clearBacking();
        this.renderChangelog();
        this.changelogFlowWidget.method_25307(0.0);
    }

    private class_2561 markdownButtonTooltip(class_4185 widget) {
        return class_2561.method_43471((String)this.renderer.getDescriptionTranslationKey());
    }

    private void markdownToggled() {
        List collect = FlowMarkdownUtils.COMPILERS.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        List collect1 = collect.stream().map(Map.Entry::getValue).collect(Collectors.toList());
        int rendererIndex = collect1.indexOf(this.renderer);
        int nextRendererIndex = rendererIndex + 1;
        if (nextRendererIndex >= collect1.size()) {
            nextRendererIndex = 0;
        }
        this.setRenderer((MarkdownRenderer)collect1.get(nextRendererIndex));
    }

    private void renderChangelog() {
        int changelogPaneWidth = this.field_22789 / 3 * 2;
        String text = this.currentVersion != null ? this.currentVersion.changelog() : ConfigInstances.getModpackUpdateCheckerConfig().getInfoText();
        this.changelogFlowWidget.addChild(this.renderer.render(changelogPaneWidth - 20, changelogPaneWidth - 20, 0, text, class_124.field_1080));
        this.changelogFlowWidget.addChild(new FlowWidget(this.field_22787, 0, 20, FlowWidget.Direction.VERTICAL));
    }

    public OnlineInfo.Version getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(OnlineInfo.Version version) {
        if (version == this.currentVersion) {
            return;
        }
        int changelogPaneWidth = this.field_22789 / 3 * 2;
        int versionsPaneWidth = this.field_22789 - changelogPaneWidth - 5;
        this.currentVersion = version;
        this.changelogFlowWidget.clearBacking();
        this.renderChangelog();
        this.changelogFlowWidget.method_25307(0.0);
        if (version != null && version.promotions != null && version.promotions.hasDownloadLinks()) {
            this.modrinthButton.field_22763 = version.promotions.getDownloadLinkOptional("modrinth").isPresent();
            this.curseforgeButton.field_22763 = version.promotions.getDownloadLinkOptional("curseforge").isPresent();
            this.downloadButton.field_22763 = version.promotions.getDownloadLinkOptional("generic").isPresent();
        } else {
            this.modrinthButton.field_22763 = false;
            this.curseforgeButton.field_22763 = false;
            this.downloadButton.field_22763 = false;
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public double getChangelogScrollAmount() {
        return this.changelogFlowWidget == null ? 0.0 : this.changelogFlowWidget.method_25341();
    }

    public double getVersionsScrollAmount() {
        return this.versionsFlowWidget == null ? 0.0 : this.versionsFlowWidget.method_25341();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        NewChangelogScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"screen.modpack-update-checker.modpack-update.title"), (int)(this.field_22789 / 2), (int)5, (int)-1);
        Context context = new Context(matrices);
        class_5481 class_54812 = class_2477.method_10517().method_30934((class_5348)class_2561.method_43470((String)"Markdown").method_27692(class_124.field_1080));
        Objects.requireNonNull(this.field_22793);
        context.drawTextWithShadow(this.field_22793, class_54812, 9, this.field_22790 - 20 - 32 + (10 - 9 / 2), -1);
        class_5481 class_54813 = class_2477.method_10517().method_30934((class_5348)class_2561.method_43470((String)ConfigInstances.getModpackUpdateCheckerConfig().modpackName));
        int n = this.field_22789 - this.field_22789 / 3 * 2;
        Objects.requireNonNull(this.field_22793);
        Objects.requireNonNull(this.field_22793);
        context.drawTextWithShadow(this.field_22793, class_54813, n, 54 - 9 - 2 - 9 - 2, -1);
        class_5481 class_54814 = class_2477.method_10517().method_30934((class_5348)(this.currentVersion == null ? class_2561.method_43471((String)"screen.modpack-update-checker.changelog.modpackInfo") : class_2561.method_43470((String)(this.currentVersion.id.startsWith("v") ? this.currentVersion.id : "v" + this.currentVersion.id))).method_27692(class_124.field_1080));
        int n2 = this.field_22789 - this.field_22789 / 3 * 2;
        Objects.requireNonNull(this.field_22793);
        context.drawTextWithShadow(this.field_22793, class_54814, n2, 54 - 9 - 2, -1);
        context.drawTextWithShadow(this.field_22793, class_2477.method_10517().method_30934((class_5348)class_2561.method_43469((String)"screen.modpack-update-checker.changelog.modpackAuthors", (Object[])new Object[]{ConfigInstances.getModpackUpdateCheckerConfig().modpackAuthor}).method_27692(class_124.field_1080)), this.field_22789 - this.field_22789 / 3 * 2, 54, -1);
    }
}

