/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.util;

import com.jab125.mpuc.client.util.Matrices;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class Context {
    private final Matrices stack;
    private final ScissorStack scissorStack = new ScissorStack();

    public Context(class_4587 stack) {
        this.stack = new Matrices(stack);
    }

    public Matrices getMatrices() {
        return this.stack;
    }

    public Matrices getPlatform() {
        return this.stack;
    }

    public void fill(int x, int y, int width, int height, int argb) {
        class_332.method_25294((class_4587)this.stack.getNativeForm(), (int)x, (int)y, (int)(x + width), (int)(y + height), (int)argb);
    }

    public int drawTextWithShadow(class_327 textRenderer, class_5481 text, int x, int y, int color) {
        class_332.method_35720((class_4587)this.stack.getNativeForm(), (class_327)textRenderer, (class_5481)text, (int)x, (int)y, (int)color);
        return 0;
    }

    private void setShaderTexture(class_2960 texture) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public void drawTexture(class_2960 texture, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        this.setShaderTexture(texture);
        class_332.method_25293((class_4587)this.getMatrices().getNativeForm(), (int)x, (int)y, (int)width, (int)height, (float)u, (float)v, (int)regionWidth, (int)regionHeight, (int)textureWidth, (int)textureHeight);
    }

    public void enableScissor(int x1, int y1, int x2, int y2) {
        this.setScissor(this.scissorStack.push(new ScreenRect(x1, y1, x2 - x1, y2 - y1)));
    }

    public void disableScissor() {
        this.setScissor(this.scissorStack.pop());
    }

    private void setScissor(@Nullable ScreenRect rect) {
        if (rect != null) {
            class_1041 window = class_310.method_1551().method_22683();
            int i = window.method_4506();
            double d = window.method_4495();
            double e = (double)rect.getLeft() * d;
            double f = (double)i - (double)rect.getBottom() * d;
            double g = (double)rect.width() * d;
            double h = (double)rect.height() * d;
            RenderSystem.enableScissor((int)((int)e), (int)((int)f), (int)Math.max(0, (int)g), (int)Math.max(0, (int)h));
        } else {
            RenderSystem.disableScissor();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ScissorStack {
        private final Deque<ScreenRect> stack = new ArrayDeque<ScreenRect>();

        ScissorStack() {
        }

        public ScreenRect push(ScreenRect rect) {
            ScreenRect screenRect = this.stack.peekLast();
            if (screenRect != null) {
                ScreenRect screenRect2 = Objects.requireNonNullElse(rect.intersection(screenRect), new ScreenRect(0, 0, 0, 0));
                this.stack.addLast(screenRect2);
                return screenRect2;
            }
            this.stack.addLast(rect);
            return rect;
        }

        @Nullable
        public ScreenRect pop() {
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("Scissor stack underflow");
            }
            this.stack.removeLast();
            return this.stack.peekLast();
        }
    }

    private static final class ScreenRect {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        private ScreenRect(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        int getLeft() {
            return this.x;
        }

        int getBottom() {
            return this.height + this.y;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ScreenRect that = (ScreenRect)obj;
            return this.x == that.x && this.y == that.y && this.width == that.width && this.height == that.height;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return "ScreenRect[x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
        }

        @Nullable
        public ScreenRect intersection(ScreenRect other) {
            int i = Math.max(this.getLeft(), other.getLeft());
            int j = Math.max(this.y, other.y);
            int k = Math.min(this.x + this.width, other.x + other.width);
            int l = Math.min(this.getBottom(), other.getBottom());
            return i < k && j < l ? new ScreenRect(i, j, k - i, l - j) : null;
        }
    }
}

