/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class Tags {
    private ArrayList<ArrayList<String>> tagStore = new ArrayList();

    public static Tags deserialize(JsonArray arr) {
        ArrayList g = new ArrayList();
        for (JsonElement jsonElement : arr) {
            ArrayList<String> s;
            if (jsonElement.isJsonPrimitive()) {
                if (!jsonElement.getAsJsonPrimitive().isString()) continue;
                s = new ArrayList<String>();
                s.add(jsonElement.getAsString());
                g.add(s);
                continue;
            }
            if (!jsonElement.isJsonArray() || jsonElement.getAsJsonArray().size() < 1) continue;
            s = new ArrayList();
            for (JsonElement element : jsonElement.getAsJsonArray()) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) continue;
                s.add(element.getAsString());
            }
            g.add(s);
        }
        Tags tags = new Tags();
        tags.tagStore = g;
        return tags;
    }

    public JsonArray serialize() {
        JsonArray array = new JsonArray();
        for (ArrayList<String> strings : this.tagStore) {
            if (strings.isEmpty()) continue;
            if (strings.size() == 1) {
                array.add(strings.get(0));
                continue;
            }
            JsonArray array1 = new JsonArray();
            strings.forEach(arg_0 -> ((JsonArray)array1).add(arg_0));
            array.add((JsonElement)array1);
        }
        return array;
    }

    public boolean isEmpty() {
        return this.tagStore.isEmpty();
    }

    public boolean passes(List<String> tags) {
        return this.passes((String[])tags.toArray(String[]::new));
    }

    public boolean passes(String ... tags) {
        block0: for (ArrayList strings : this.tagStore.isEmpty() ? ((Supplier<ArrayList>)() -> {
            ArrayList arrayLists = new ArrayList();
            arrayLists.add(new ArrayList());
            return arrayLists;
        }).get() : this.tagStore) {
            int matchCount = 0;
            for (String string : strings) {
                for (String tag : tags) {
                    boolean matches;
                    boolean bl = matches = string.startsWith("-") ? tag.equals(string.substring(1)) : tag.equals(string);
                    if (!matches) continue;
                    if (string.startsWith("-")) continue block0;
                    ++matchCount;
                }
            }
            if ((long)matchCount < strings.stream().filter(a -> !a.startsWith("-")).count()) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Tags tags = Tags.deserialize((JsonArray)new Gson().fromJson("[['beta', '1.21'], '1.20.6', ['alpha', '-1.20.4']]".replace("'", "\""), JsonArray.class));
        tags.assertPass("beta", "1.21");
        tags.assertPass("beta", "1.21", "1.20.5");
        tags.assertPass("1.20.6", "beta");
        tags.assertFail("beta");
        tags.assertFail("alpha", "1.20.4");
        tags.assertPass("alpha", "1.20");
        tags.assertFail("1.20");
        tags.assertPass("beta", "1.21", "alpha", "1.20.4");
        tags.assertFail(new String[0]);
        Tags tags1 = new Tags();
        tags1.assertPass(new String[0]);
        tags1.assertPass("1.20");
        tags1.assertPass("beta", "1.20");
        Tags tags2 = Tags.deserialize((JsonArray)new Gson().fromJson("[['beta', '1.21', '-1.20.4']]".replace("'", "\""), JsonArray.class));
        tags2.assertPass("beta", "1.21");
        tags2.assertFail("beta", "1.21", "1.20.4");
        tags2.assertPass("beta", "1.21", "1.20");
        tags2.assertFail(new String[0]);
        System.out.println("All tests passed!");
    }

    private void assertPass(String ... tags) {
        System.out.println("Beginning test on " + String.join((CharSequence)", ", tags));
        if (!this.passes(tags)) {
            throw new AssertionError((Object)(String.join((CharSequence)", ", tags) + " failed to pass!"));
        }
    }

    private void assertFail(String ... tags) {
        System.out.println("Beginning test on " + String.join((CharSequence)", ", tags));
        if (this.passes(tags)) {
            throw new AssertionError((Object)(String.join((CharSequence)", ", tags) + " failed to fail!"));
        }
    }
}

