/*
 * Decompiled with CFR 0.152.
 */
package wrs;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import wrs.block.entity.AbstractNetworkBlockEntity;

public class Networks {
    private static HashMap<String, Network> networks = new LinkedHashMap<String, Network>();

    public static Set<String> getNetworkNames() {
        return networks.keySet();
    }

    public static void addTransmitter(class_2338 pos, String networkName) {
        Network network = networks.get(networkName);
        if (network == null) {
            network = new Network(networkName);
            networks.put(networkName, network);
        }
        network.addTransmitter(pos);
    }

    public static void addReceiver(class_2338 pos, String networkName) {
        Network network = networks.get(networkName);
        if (network == null) {
            network = new Network(networkName);
            networks.put(networkName, network);
        }
        network.addReceiver(pos);
    }

    public static List<class_2338> getTransmitters(String networkName) {
        Network network = networks.get(networkName);
        if (network != null) {
            return new LinkedList<class_2338>(network.transmitters);
        }
        return new LinkedList<class_2338>();
    }

    public static List<class_2338> getReceivers(String networkName) {
        Network network = networks.get(networkName);
        if (network != null) {
            return new LinkedList<class_2338>(network.receivers);
        }
        return new LinkedList<class_2338>();
    }

    public static void removeTransmitter(class_2338 pos, String networkName) {
        Network network = networks.get(networkName);
        if (network != null) {
            network.transmitters.remove(pos);
        }
    }

    public static void removeReceiver(class_2338 pos, String networkName) {
        Network network = networks.get(networkName);
        if (network != null) {
            network.removeReceiver(pos);
        }
    }

    public static void propagateUpdate(String networkName, class_1937 world) {
        List<class_2338> transmitters = Networks.getTransmitters(networkName);
        if (!transmitters.isEmpty()) {
            class_2338 transmitter = Networks.getTransmitters(networkName).getLast();
            int power = world.method_49804(transmitter);
            for (class_2338 receiver : Networks.getReceivers(networkName)) {
                if (!(world.method_8321(receiver) instanceof AbstractNetworkBlockEntity)) continue;
                class_2680 receiverState = world.method_8320(receiver);
                receiverState = (class_2680)((class_2680)receiverState.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(power > 0))).method_11657((class_2769)class_2741.field_12511, (Comparable)Integer.valueOf(power));
                world.method_8652(receiver, receiverState, 3);
            }
        }
    }

    static class Network {
        String networkName;
        List<class_2338> transmitters;
        List<class_2338> receivers;

        public Network(String networkName) {
            this.networkName = networkName;
            this.transmitters = new LinkedList<class_2338>();
            this.receivers = new LinkedList<class_2338>();
        }

        public void addTransmitter(class_2338 pos) {
            if (!this.transmitters.contains(pos)) {
                this.transmitters.add(pos);
            }
        }

        public void removeTransmitter(class_2338 pos) {
            if (this.transmitters.contains(pos)) {
                this.transmitters.remove(pos);
            }
        }

        public void addReceiver(class_2338 pos) {
            if (!this.receivers.contains(pos)) {
                this.receivers.add(pos);
            }
        }

        public void removeReceiver(class_2338 pos) {
            if (this.receivers.contains(pos)) {
                this.receivers.remove(pos);
            }
        }
    }
}

