/*
 * Decompiled with CFR 0.152.
 */
package wrs;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wrs.WRSCommands;
import wrs.WRSSounds;
import wrs.block.WRSBlocks;
import wrs.block.entity.AbstractNetworkBlockEntity;
import wrs.block.entity.ReceiverBlockEntity;
import wrs.block.entity.WRSBlockEntities;
import wrs.item.WRSComponents;
import wrs.item.WRSItemGroups;
import wrs.item.WRSItems;
import wrs.networking.LinkerApplyC2SPayload;
import wrs.networking.OpenConfigPanelS2CPayload;
import wrs.networking.SaveNetworkNameC2SPayload;

public class WRS
implements ModInitializer {
    public static final String MODID = "wrs";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"wrs");

    public static class_2960 id(String id) {
        return class_2960.method_60655((String)MODID, (String)id);
    }

    public void onInitialize() {
        WRSBlocks.registerBlocks();
        WRSBlockEntities.registerBlockEntities();
        WRSComponents.registerComponents();
        WRSItems.registerItems();
        WRSItemGroups.registerItemGroups();
        WRSCommands.registerCommands();
        WRSSounds.registerSounds();
        this.registerNetworkPayloads();
        this.registerNetworkReceivers();
    }

    private void registerNetworkPayloads() {
        PayloadTypeRegistry.playS2C().register(OpenConfigPanelS2CPayload.ID, OpenConfigPanelS2CPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SaveNetworkNameC2SPayload.ID, SaveNetworkNameC2SPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(LinkerApplyC2SPayload.ID, LinkerApplyC2SPayload.CODEC);
    }

    private void registerNetworkReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(SaveNetworkNameC2SPayload.ID, WRS::receiveSaveNetworkName);
        ServerPlayNetworking.registerGlobalReceiver(LinkerApplyC2SPayload.ID, WRS::receiveLinkerApply);
    }

    private static void receiveSaveNetworkName(SaveNetworkNameC2SPayload payload, ServerPlayNetworking.Context context) {
        class_2586 class_25862 = context.player().method_51469().method_8321(payload.blockPos());
        if (class_25862 instanceof AbstractNetworkBlockEntity) {
            AbstractNetworkBlockEntity networkBlockEntity = (AbstractNetworkBlockEntity)class_25862;
            networkBlockEntity.updateFromPayload(payload);
        }
    }

    private static void receiveLinkerApply(LinkerApplyC2SPayload payload, ServerPlayNetworking.Context context) {
        class_2586 class_25862 = context.player().method_51469().method_8321(payload.blockPos());
        if (class_25862 instanceof ReceiverBlockEntity) {
            ReceiverBlockEntity receiverBlockEntity = (ReceiverBlockEntity)class_25862;
            receiverBlockEntity.setNetworkName(payload.networkName());
        }
    }
}

