/*
 * Decompiled with CFR 0.152.
 */
package dev.lirox.scatter;

import dev.lirox.scatter.Affected;
import dev.lirox.scatter.commands.ReviverCommand;
import dev.lirox.scatter.commands.ScatterCommand;
import dev.lirox.scatter.commands.StateCommand;
import dev.lirox.scatter.configs.LocaleConfig;
import dev.lirox.scatter.configs.PlayerConfig;
import dev.lirox.scatter.events.GhostEvents;
import dev.lirox.scatter.events.MainEvents;
import dev.lirox.scatter.events.SilenceEvents;
import dev.lirox.scatter.registries.Registry;
import dev.lirox.scatter.states.Ghost;
import dev.lirox.scatter.states.Meowthpiece;
import dev.lirox.scatter.states.Scatterred;
import dev.lirox.scatter.states.Tagged;
import dev.lirox.scatter.states.Trapped;
import dev.lirox.scatter.utils.ParticleUtils;
import dev.lirox.scatter.utils.PlayerUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Team;

public final class Scatter
extends JavaPlugin
implements Listener {
    public static Scatter plugin;
    private final Random rand = new Random();

    public void onEnable() {
        this.saveDefaultConfig();
        PlayerConfig.init(this.getDataFolder());
        PlayerConfig.loadAll();
        this.saveResource("locale.yml", false);
        LocaleConfig.init(this.getDataFolder());
        this.spawnParticlesLoop();
        this.getServer().getPluginManager().registerEvents((Listener)new GhostEvents(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SilenceEvents(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MainEvents(), (Plugin)this);
        this.getCommand("scatter").setExecutor((CommandExecutor)new ScatterCommand());
        this.getCommand("reviver").setExecutor((CommandExecutor)new ReviverCommand());
        this.getCommand("state").setExecutor((CommandExecutor)new StateCommand());
        if (Registry.noMobPushTeam == null) {
            Registry.noMobPushTeam = Bukkit.getScoreboardManager().getMainScoreboard().registerNewTeam("noMobPush");
            Registry.noMobPushTeam.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
        }
    }

    public void onDisable() {
        PlayerConfig.saveAll();
    }

    private void spawnParticlesLoop() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            for (Map.Entry<UUID, Scatterred> entry : Affected.map.entrySet()) {
                Scatterred selector0$temp;
                Player p;
                Player player;
                Scatterred state = entry.getValue();
                Object obj = PlayerUtils.getPlayerData(state.victim);
                Player player2 = player = obj instanceof Player ? (p = (Player)obj) : null;
                if (player != null) {
                    state.update(player);
                }
                Objects.requireNonNull(state);
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Trapped.class, Tagged.class, Ghost.class, Meowthpiece.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        Trapped trapped = (Trapped)selector0$temp;
                        if (player == null) break;
                        ParticleUtils.trappedParticles(player, trapped.animationTime);
                        break;
                    }
                    case 1: {
                        Tagged tagged = (Tagged)selector0$temp;
                        if (player == null) break;
                        ParticleUtils.taggedParticles(player, tagged.timeout);
                        break;
                    }
                    case 2: {
                        Ghost ghost = (Ghost)selector0$temp;
                        if (player != null) {
                            if (ghost.mount != null) {
                                ghost.mount.teleport((Entity)player);
                            }
                            player.setExp(this.rand.nextFloat());
                            ParticleUtils.soulParticles(ghost.death_pos, true);
                            break;
                        }
                        ParticleUtils.soulParticles(ghost.death_pos, false);
                        break;
                    }
                    case 3: {
                        Meowthpiece meowthpiece = (Meowthpiece)selector0$temp;
                        if (player == null) break;
                        PlayerUtils.setVisibilityToAllPlayersCornerVision(player, true, 45);
                        break;
                    }
                }
            }
        }, 0L, 1L);
    }
}

