/*
 * Decompiled with CFR 0.152.
 */
package dev.lirox.scatter.commands;

import dev.lirox.scatter.utils.PlayerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateCommand
implements CommandExecutor,
TabCompleter {
    public static final List<String> options = List.of("regular", "tagged", "trapped", "ghost", "meowthpiece");

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length < 2) {
            return false;
        }
        ArrayList<Player> targets = new ArrayList<Player>();
        switch (args[0].toLowerCase()) {
            case "@p": {
                if (!(sender instanceof Player)) break;
                Player p = (Player)sender;
                targets.add(p);
                break;
            }
            case "@a": {
                targets.addAll(sender.getServer().getOnlinePlayers());
                break;
            }
            case "@r": {
                ArrayList online = new ArrayList(sender.getServer().getOnlinePlayers());
                if (online.isEmpty()) break;
                targets.add((Player)online.get((int)(Math.random() * (double)online.size())));
                break;
            }
            case "@s": {
                if (!(sender instanceof Player)) break;
                Player p = (Player)sender;
                targets.add(p);
                break;
            }
            default: {
                Player p = sender.getServer().getPlayerExact(args[0]);
                if (p == null) break;
                targets.add(p);
            }
        }
        block26: for (Player target : targets) {
            switch (args[1].toLowerCase()) {
                case "regular": {
                    PlayerUtils.release(target, true);
                    PlayerUtils.revive(target);
                    PlayerUtils.demeowthpiecefy(target);
                    continue block26;
                }
                case "trapped": {
                    PlayerUtils.trap(target);
                    continue block26;
                }
                case "tagged": {
                    PlayerUtils.tag(target);
                    continue block26;
                }
                case "ghost": {
                    PlayerUtils.scatter(target, false);
                    continue block26;
                }
                case "meowthpiece": {
                    PlayerUtils.meowthpiecefy(target);
                    continue block26;
                }
            }
            return false;
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            List<String> selectors = Arrays.asList("@p", "@a", "@r", "@s", sender.getName());
            ArrayList<String> result = new ArrayList<String>();
            String input = args[0].toLowerCase();
            for (String sel : selectors) {
                if (!sel.startsWith(input)) continue;
                result.add(sel);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                result.add(player.getName());
            }
            return result;
        }
        if (args.length == 2) {
            ArrayList<String> result = new ArrayList<String>();
            String input = args[1].toLowerCase();
            for (String opt : options) {
                if (!opt.toLowerCase().startsWith(input)) continue;
                result.add(opt);
            }
            return result;
        }
        return new ArrayList<String>();
    }
}

