/*
 * Decompiled with CFR 0.152.
 */
package dev.lirox.scatter.configs;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LocaleConfig {
    private static File file;
    private static FileConfiguration config;
    public static final Map<String, String> messages;

    private LocaleConfig() {
    }

    public static void init(File dataFolder) {
        file = new File(dataFolder, "locale.yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LocaleConfig.reload();
    }

    public static String get(String key) {
        if (!messages.containsKey(key)) {
            return key;
        }
        return messages.get(key);
    }

    public static void reload() {
        config = YamlConfiguration.loadConfiguration((File)file);
        messages.clear();
        for (String key : config.getKeys(true)) {
            messages.put(key, config.getString(key));
        }
    }

    static {
        messages = new HashMap<String, String>();
    }
}

