/*
 * Decompiled with CFR 0.152.
 */
package dev.lirox.scatter.configs;

import dev.lirox.scatter.Affected;
import dev.lirox.scatter.states.Ghost;
import dev.lirox.scatter.states.Meowthpiece;
import dev.lirox.scatter.states.Scatterred;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LivingEntity;

public class PlayerConfig {
    private static File folder;

    private PlayerConfig() {
    }

    public static void init(File dataFolder) {
        folder = new File(dataFolder, "players");
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public static void save(UUID uuid) {
        Scatterred s = Affected.get(uuid);
        if (s == null) {
            return;
        }
        File file = new File(folder, String.valueOf(uuid) + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        cfg.set("type", (Object)s.getClass().getSimpleName());
        cfg.set("victim", (Object)s.victim.toString());
        cfg.set("killer", (Object)s.killer.toString());
        if (s instanceof Ghost) {
            Ghost ghost = (Ghost)s;
            Location loc = ghost.death_pos;
            cfg.set("death_pos.world", (Object)loc.getWorld().getName());
            cfg.set("death_pos.x", (Object)loc.getX());
            cfg.set("death_pos.y", (Object)loc.getY());
            cfg.set("death_pos.z", (Object)loc.getZ());
            if (ghost.mount != null) {
                cfg.set("mount", (Object)ghost.mount.getUniqueId().toString());
            } else {
                cfg.set("mount", null);
            }
        }
        try {
            cfg.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load(UUID uuid) {
        File file = new File(folder, String.valueOf(uuid) + ".yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        String type = cfg.getString("type");
        UUID victim = UUID.fromString(cfg.getString("victim"));
        UUID killer = UUID.fromString(cfg.getString("killer"));
        Scatterred s = null;
        if ("Ghost".equals(type)) {
            String mountId;
            String world = cfg.getString("death_pos.world");
            double x = cfg.getDouble("death_pos.x");
            double y = cfg.getDouble("death_pos.y");
            double z = cfg.getDouble("death_pos.z");
            Location loc = new Location(Bukkit.getWorld((String)world), x, y, z);
            Ghost ghost = new Ghost(victim, killer, loc);
            if (cfg.contains("mount") && (mountId = cfg.getString("mount")) != null) {
                LivingEntity entity = (LivingEntity)Bukkit.getEntity((UUID)UUID.fromString(mountId));
                ghost.mount(entity);
            }
            s = ghost;
        } else if ("Meowthpiece".equals(type)) {
            s = new Meowthpiece(victim, killer);
        }
        if (s != null) {
            Affected.put(uuid, s);
        }
    }

    public static void saveAll() {
        if (!folder.exists()) {
            return;
        }
        for (File file : folder.listFiles()) {
            String name = file.getName().replace(".yml", "");
            try {
                UUID uuid = UUID.fromString(name);
                if (Affected.get().containsKey(uuid)) continue;
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (UUID uuid : Affected.get().keySet()) {
            PlayerConfig.save(uuid);
        }
    }

    public static void loadAll() {
        if (!folder.exists()) {
            return;
        }
        for (File file : folder.listFiles()) {
            String name = file.getName().replace(".yml", "");
            try {
                UUID uuid = UUID.fromString(name);
                PlayerConfig.load(uuid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

