/*
 * Decompiled with CFR 0.152.
 */
package dev.lirox.scatter.events;

import dev.lirox.scatter.Affected;
import dev.lirox.scatter.registries.Registry;
import dev.lirox.scatter.states.Ghost;
import dev.lirox.scatter.states.Meowthpiece;
import dev.lirox.scatter.states.Scatterred;
import dev.lirox.scatter.states.Trapped;
import dev.lirox.scatter.utils.ItemUtils;
import dev.lirox.scatter.utils.PlayerUtils;
import dev.lirox.scatter.utils.TextUtils;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.RayTraceResult;

public class MainEvents
implements Listener {
    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (PlayerUtils.isState(player, Ghost.class)) {
            event.quitMessage(null);
            PlayerUtils.getState(player, Ghost.class).dismount();
        } else if (PlayerUtils.isState(player, Trapped.class)) {
            PlayerUtils.scatter(event.getPlayer(), true);
        } else if (PlayerUtils.isState(player, Meowthpiece.class)) {
            event.quitMessage(null);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (PlayerUtils.isState(player, Ghost.class)) {
            event.joinMessage(null);
            PlayerUtils.prepareGhost(player, true);
        } else if (PlayerUtils.isState(player, Meowthpiece.class)) {
            event.joinMessage(null);
            PlayerUtils.prepareMeowthpiece(player, false);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (PlayerUtils.isState(player, Ghost.class)) {
            return;
        }
        Item droppedItem = event.getItemDrop();
        if (!ItemUtils.hasProperty(droppedItem.getItemStack(), Registry.PROP_REVIVER)) {
            return;
        }
        for (Map.Entry<UUID, Scatterred> entry : Affected.map.entrySet()) {
            Scatterred scatterred = entry.getValue();
            if (!(scatterred instanceof Ghost)) continue;
            Ghost ghost = (Ghost)scatterred;
            Location deathPos = ghost.death_pos;
            Location deathLocation = new Location(player.getWorld(), deathPos.getX(), deathPos.getY(), deathPos.getZ());
            if (deathLocation.distance(player.getLocation()) > 5.0) continue;
            Object obj = PlayerUtils.getPlayerData(entry.getKey());
            if (!(obj instanceof Player)) {
                player.sendMessage(TextUtils.locale("revive.offline"));
                return;
            }
            Player victim = (Player)obj;
            PlayerUtils.revive(victim, true);
            victim.getWorld().playSound(victim.getLocation(), Sound.BLOCK_RESPAWN_ANCHOR_DEPLETE, 1.0f, 1.0f);
            victim.getWorld().playSound(victim.getLocation(), Sound.BLOCK_BELL_RESONATE, 1.0f, 1.0f);
            victim.sendMessage(TextUtils.locale("revive.revived", Map.of("player", player.getName())));
            droppedItem.remove();
            return;
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player victim = event.getEntity();
        Player killer = victim.getKiller();
        if (killer == null) {
            return;
        }
        if (ItemUtils.getFirstScatterItem(killer) == null) {
            return;
        }
        event.setCancelled(true);
        PlayerUtils.trap(victim, killer);
        victim.setHealth(victim.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
    }

    @EventHandler
    public void onEntityDamagedByEntity(EntityDamageByEntityEvent event) {
        Player damager;
        Entity entity = event.getDamager();
        if (entity instanceof Player && (PlayerUtils.isState(damager = (Player)entity, Ghost.class) || PlayerUtils.isState(damager, Trapped.class))) {
            event.setCancelled(true);
            return;
        }
        entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        if (PlayerUtils.isState(victim, Ghost.class)) {
            event.setCancelled(true);
            return;
        }
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player damager2 = (Player)entity2;
        if (PlayerUtils.isRegular(victim) && ItemUtils.getFirstScatterItem(damager2) != null) {
            PlayerUtils.tag(victim);
        }
        if (!PlayerUtils.isState(victim, Trapped.class)) {
            return;
        }
        Trapped trapped = PlayerUtils.getState(victim, Trapped.class);
        if (damager2.getUniqueId().equals(trapped.killer) && ItemUtils.mainHand(damager2).getType().isAir()) {
            PlayerUtils.release(victim);
            return;
        }
        ItemStack itemStack = ItemUtils.getFirstScatterItem(damager2);
        if (itemStack instanceof ItemStack) {
            ItemStack item = itemStack;
            --trapped.remainingHits;
            victim.damage(1.0);
            victim.setHealth(1.0 + (victim.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() - 1.0) * ((double)trapped.remainingHits / 3.0));
            damager2.sendMessage(TextUtils.locale("scatter.hit", Map.of("hits", String.valueOf(3 - trapped.remainingHits), "total", String.valueOf(3))));
            damager2.getWorld().playSound(damager2.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_BREAK, 1.0f, 1.0f);
            if (trapped.remainingHits <= 0) {
                PlayerUtils.scatter(victim, true);
                ItemUtils.decrementItem(item);
            }
        }
    }

    @EventHandler
    public void onSwing(PlayerAnimationEvent e) {
        Player p = e.getPlayer();
        RayTraceResult result = p.rayTraceEntities(3);
        if (result == null) {
            return;
        }
        Entity hit = result.getHitEntity();
        if (!(hit instanceof Player)) {
            return;
        }
        Player other = (Player)hit;
        if (!PlayerUtils.isState(other, Meowthpiece.class)) {
            return;
        }
        p.attack((Entity)other);
    }
}

