/*
 * Decompiled with CFR 0.152.
 */
package dev.lirox.scatter.utils;

import com.google.gson.Gson;
import dev.lirox.scatter.registries.Registry;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ItemUtils {
    public static Consumer<ItemStack> decrementOrRemove = item -> {
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            item.setAmount(0);
        }
    };
    private static final Gson gson = new Gson();

    public static String getType(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        return (String)meta.getPersistentDataContainer().get(Registry.TYPE_KEY, PersistentDataType.STRING);
    }

    public static boolean isScatter(ItemStack item) {
        return ItemUtils.getType(item) != null;
    }

    public static void setType(ItemStack item, String type) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.getPersistentDataContainer().set(Registry.TYPE_KEY, PersistentDataType.STRING, (Object)type);
        item.setItemMeta(meta);
    }

    public static List<String> getProperties(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return List.of();
        }
        String json = (String)meta.getPersistentDataContainer().get(Registry.PROP_KEY, PersistentDataType.STRING);
        if (json == null || json.isEmpty()) {
            return List.of();
        }
        return Arrays.asList((String[])gson.fromJson(json, String[].class));
    }

    public static void setProperties(ItemStack item, List<String> properties) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String json = gson.toJson(properties);
        meta.getPersistentDataContainer().set(Registry.PROP_KEY, PersistentDataType.STRING, (Object)json);
        item.setItemMeta(meta);
    }

    public static boolean isType(ItemStack item, String type) {
        return Objects.equals(ItemUtils.getType(item), type);
    }

    public static boolean hasProperty(ItemStack item, String property) {
        return ItemUtils.getProperties(item).contains(property);
    }

    public static ItemStack offHand(Player player) {
        return player.getInventory().getItemInOffHand();
    }

    public static ItemStack mainHand(Player player) {
        return player.getInventory().getItemInMainHand();
    }

    public static ItemStack getFirstScatterItem(Player player) {
        EquipmentSlot[] slots;
        ItemStack[] hands;
        for (ItemStack item : hands = new ItemStack[]{ItemUtils.offHand(player), ItemUtils.mainHand(player)}) {
            if (!ItemUtils.isScatter(item)) continue;
            return item;
        }
        for (EquipmentSlot slot : slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            ItemStack item = player.getInventory().getItem(slot);
            if (!ItemUtils.isScatter(item)) continue;
            return item;
        }
        return null;
    }

    public static void decrementItem(ItemStack item) {
        if (item != null) {
            decrementOrRemove.accept(item);
        }
    }
}

