/*
 * Decompiled with CFR 0.152.
 */
package dev.lirox.scatter.utils;

import dev.lirox.scatter.Affected;
import dev.lirox.scatter.registries.Registry;
import dev.lirox.scatter.states.Ghost;
import dev.lirox.scatter.states.Meowthpiece;
import dev.lirox.scatter.states.Scatterred;
import dev.lirox.scatter.states.Tagged;
import dev.lirox.scatter.states.Trapped;
import dev.lirox.scatter.utils.TextUtils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class PlayerUtils {
    public static Object getPlayerData(UUID uuid) {
        Player p = Bukkit.getPlayer((UUID)uuid);
        return p != null ? p : Bukkit.getOfflinePlayer((UUID)uuid);
    }

    public static Object getPlayerData(String name) {
        Player p = Bukkit.getPlayer((String)name);
        return p != null ? p : Bukkit.getOfflinePlayer((String)name);
    }

    public static void setVisibilityToPlayer(Player player, Player seeker, boolean visibility) {
        if (visibility) {
            seeker.showPlayer(Registry.plugin, player);
        } else {
            seeker.hidePlayer(Registry.plugin, player);
        }
    }

    public static void setVisibilityToAllPlayers(Player player, boolean visibility) {
        for (Player seeker : Bukkit.getOnlinePlayers()) {
            PlayerUtils.setVisibilityToPlayer(player, seeker, visibility);
        }
    }

    public static void setVisibilityToAllPlayersCornerVision(Player meowthpiece, boolean visibility, int angle) {
        double cosAngle = Math.cos(Math.toRadians(angle));
        for (Player other : meowthpiece.getWorld().getPlayers()) {
            if (other == meowthpiece || meowthpiece.getLocation().distanceSquared(other.getLocation()) > 62500.0) continue;
            Vector dir = other.getLocation().getDirection().normalize();
            boolean inVision = dir.dot(meowthpiece.getLocation().toVector().subtract(other.getLocation().toVector()).normalize()) >= cosAngle;
            PlayerUtils.setVisibilityToPlayer(meowthpiece, other, visibility && !inVision);
        }
    }

    public static boolean isState(UUID uuid, Class<? extends Scatterred> type) {
        Scatterred s = Affected.get(uuid);
        if (type == null) {
            return s == null;
        }
        return type.isInstance(s);
    }

    public static boolean isState(Player player, Class<? extends Scatterred> type) {
        return PlayerUtils.isState(player.getUniqueId(), type);
    }

    public static <T extends Scatterred> T getState(UUID uuid, Class<T> type) {
        Scatterred s = Affected.get(uuid);
        if (type.isInstance(s)) {
            return (T)((Scatterred)type.cast(s));
        }
        return null;
    }

    public static <T extends Scatterred> T getState(Player player, Class<T> type) {
        return PlayerUtils.getState(player.getUniqueId(), type);
    }

    public static boolean isRegular(UUID uuid) {
        return PlayerUtils.isState(uuid, null) || PlayerUtils.isState(uuid, Tagged.class);
    }

    public static boolean isRegular(Player player) {
        return PlayerUtils.isRegular(player.getUniqueId());
    }

    public static void dropItems(ItemStack[] items, Location location) {
        for (ItemStack item : items) {
            if (item == null) continue;
            location.getWorld().dropItemNaturally(location, item);
        }
    }

    public static void dropInventory(Player player) {
        PlayerUtils.dropItems(player.getInventory().getContents(), player.getLocation());
        player.getInventory().clear();
    }

    public static void dropEnderChest(Player player) {
        PlayerUtils.dropItems(player.getEnderChest().getContents(), player.getLocation());
        player.getEnderChest().clear();
    }

    public static void prepareRegular(Player player, boolean setHpSaturation) {
        player.setAllowFlight(false);
        player.setFlying(false);
        PlayerUtils.setVisibilityToAllPlayers(player, true);
        player.setGameMode(GameMode.SURVIVAL);
        player.setCanPickupItems(true);
        Registry.noMobPushTeam.removePlayer((OfflinePlayer)player);
        player.removePotionEffect(PotionEffectType.INVISIBILITY);
        if (setHpSaturation) {
            player.setHealth(10.0);
            player.setSaturation(10.0f);
            player.setFoodLevel(10);
        }
    }

    public static void prepareGhost(Player player, boolean setHpSaturation) {
        PlayerUtils.setVisibilityToAllPlayers(player, false);
        player.setGameMode(GameMode.ADVENTURE);
        player.setCanPickupItems(false);
        Registry.noMobPushTeam.addPlayer((OfflinePlayer)player);
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false));
        if (setHpSaturation) {
            player.setHealth(1.0);
            player.setSaturation(0.0f);
            player.setFoodLevel(0);
        }
    }

    public static void prepareMeowthpiece(Player player, boolean setHpSaturation) {
        PlayerUtils.prepareRegular(player, false);
        PlayerUtils.setVisibilityToAllPlayers(player, false);
        if (setHpSaturation) {
            player.setHealth(20.0);
            player.setSaturation(20.0f);
            player.setFoodLevel(20);
        }
    }

    public static void scatter(UUID victim, UUID killer, boolean kick) {
        Object obj = PlayerUtils.getPlayerData(victim);
        if (obj instanceof Player) {
            Player player = (Player)obj;
            Affected.put(victim, new Ghost(victim, killer, player.getLocation()));
            PlayerUtils.prepareGhost(player, true);
            if (kick) {
                player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
                player.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, player.getLocation(), 50);
                PlayerUtils.dropInventory(player);
                PlayerUtils.dropEnderChest(player);
                player.kick(TextUtils.locale("scatter.kick"));
            }
        } else if (obj instanceof OfflinePlayer) {
            OfflinePlayer player = (OfflinePlayer)obj;
            Affected.put(victim, new Ghost(victim, killer, player.getLocation()));
        }
    }

    public static void scatter(UUID uuid, boolean kick) {
        PlayerUtils.scatter(uuid, uuid, kick);
    }

    public static void scatter(Player victim, boolean kick) {
        PlayerUtils.scatter(victim.getUniqueId(), victim.getUniqueId(), kick);
    }

    public static void revive(UUID uuid) {
        PlayerUtils.revive(uuid, false);
    }

    public static void revive(UUID uuid, boolean teleport) {
        Scatterred scatterred;
        Player player;
        block5: {
            block4: {
                Object obj = PlayerUtils.getPlayerData(uuid);
                if (!(obj instanceof Player)) break block4;
                player = (Player)obj;
                scatterred = Affected.get(uuid);
                if (scatterred instanceof Ghost) break block5;
            }
            return;
        }
        Ghost ghost = (Ghost)scatterred;
        PlayerUtils.prepareRegular(player, true);
        if (teleport) {
            player.teleport(ghost.death_pos);
        }
        Affected.remove(uuid);
    }

    public static void revive(Player victim) {
        PlayerUtils.revive(victim.getUniqueId(), false);
    }

    public static void revive(Player victim, boolean teleport) {
        PlayerUtils.revive(victim.getUniqueId(), teleport);
    }

    public static void trap(UUID victim, UUID killer) {
        if (!(PlayerUtils.getPlayerData(victim) instanceof Player)) {
            return;
        }
        if (!PlayerUtils.isRegular(victim)) {
            return;
        }
        Affected.put(victim, new Trapped(victim, killer, 3, 0, 2400));
    }

    public static void trap(Player victim, Player killer) {
        PlayerUtils.trap(victim.getUniqueId(), killer.getUniqueId());
    }

    public static void trap(Player victim, UUID killer) {
        PlayerUtils.trap(victim.getUniqueId(), killer);
    }

    public static void trap(UUID victim, Player killer) {
        PlayerUtils.trap(victim, killer.getUniqueId());
    }

    public static void trap(Player victim) {
        PlayerUtils.trap(victim.getUniqueId(), victim.getUniqueId());
    }

    public static void trap(UUID uuid) {
        PlayerUtils.trap(uuid, uuid);
    }

    public static boolean release(UUID uuid) {
        if (!PlayerUtils.isState(uuid, Trapped.class)) {
            return false;
        }
        Affected.remove(uuid);
        return true;
    }

    public static void release(Player victim, boolean prepare) {
        if (PlayerUtils.release(victim.getUniqueId()) && prepare) {
            PlayerUtils.prepareRegular(victim, true);
        }
    }

    public static void release(Player victim) {
        PlayerUtils.release(victim.getUniqueId());
    }

    public static void meowthpiecefy(UUID uuid) {
        Affected.put(uuid, new Meowthpiece(uuid, uuid));
    }

    public static void meowthpiecefy(Player victim) {
        PlayerUtils.prepareMeowthpiece(victim, true);
        PlayerUtils.meowthpiecefy(victim.getUniqueId());
    }

    public static boolean demeowthpiecefy(UUID uuid) {
        if (PlayerUtils.isState(uuid, Meowthpiece.class)) {
            Affected.remove(uuid);
            return true;
        }
        return false;
    }

    public static void demeowthpiecefy(Player victim) {
        if (PlayerUtils.demeowthpiecefy(victim.getUniqueId())) {
            PlayerUtils.prepareRegular(victim, true);
        }
    }

    public static void tag(UUID uuid) {
        if (PlayerUtils.isRegular(uuid)) {
            Affected.put(uuid, new Tagged(uuid, uuid, 200));
        }
    }

    public static void tag(Player victim) {
        PlayerUtils.tag(victim.getUniqueId());
    }
}

