/*
 * Decompiled with CFR 0.152.
 */
package org.lirox.scatter;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.lirox.scatter.Scatter;
import org.lirox.scatter.Scatterred;

public class ConfigManager {
    private final FileConfiguration config;
    public final Map<String, Scatterred> scatteredPlayers = new HashMap<String, Scatterred>();
    public final Map<String, Entity> controlledMobs = new HashMap<String, Entity>();

    public ConfigManager(FileConfiguration config) {
        this.config = config;
    }

    public void load() {
        if (this.config.isConfigurationSection("players")) {
            for (String playerName : this.config.getConfigurationSection("players").getKeys(false)) {
                double x = this.config.getDouble("players." + playerName + ".death_pos.x", 0.0);
                double y = this.config.getDouble("players." + playerName + ".death_pos.y", 0.0);
                double z = this.config.getDouble("players." + playerName + ".death_pos.z", 0.0);
                String worldName = this.config.getString("players." + playerName + ".death_world", "");
                if (Bukkit.getWorld((String)worldName) == null || x == 0.0 && y == 0.0 && z == 0.0) continue;
                this.scatteredPlayers.put(playerName, new Scatterred(playerName, this.config.getString("players." + playerName + ".killer", null), 0, 2, 0, 0, new Location(Bukkit.getWorld((String)worldName), x, y, z)));
            }
        }
    }

    public void save() {
        for (Map.Entry<String, Scatterred> entry : this.scatteredPlayers.entrySet()) {
            if (entry.getValue().state != 2) continue;
            String playerName = entry.getKey();
            this.config.set("players." + playerName + ".killer", (Object)entry.getValue().killer);
            Location deathPos = entry.getValue().pos;
            if (deathPos == null) continue;
            this.config.set("players." + playerName + ".death_pos.x", (Object)deathPos.getX());
            this.config.set("players." + playerName + ".death_pos.y", (Object)deathPos.getY());
            this.config.set("players." + playerName + ".death_pos.z", (Object)deathPos.getZ());
            this.config.set("players." + playerName + ".death_world", (Object)deathPos.getWorld().getName());
        }
        Scatter.plugin.saveConfig();
    }
}

