/*
 * Decompiled with CFR 0.152.
 */
package org.lirox.scatter;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.lirox.scatter.ItemUtils;
import org.lirox.scatter.PlayerUtils;
import org.lirox.scatter.Scatter;
import org.lirox.scatter.Scatterred;

public class Events
implements Listener {
    private final Plugin plugin;
    public static final int hitsTillFinalize = 3;
    public float max_final_hp_mul = 0.5f;

    public Events(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Item droppedItem;
        Player player = event.getPlayer();
        if (PlayerUtils.isScattered(player)) {
            event.setCancelled(true);
        }
        if (!ItemUtils.isReviver((droppedItem = event.getItemDrop()).getItemStack())) {
            return;
        }
        for (Map.Entry<String, Scatterred> entry : Scatter.configManager.scatteredPlayers.entrySet()) {
            String victimName = entry.getKey();
            Location deathPos = entry.getValue().pos;
            Location deathLocation = new Location(player.getWorld(), deathPos.getX(), deathPos.getY(), deathPos.getZ());
            if (!(deathLocation.distance(player.getLocation()) <= 5.0)) continue;
            Player victim = Bukkit.getPlayer((String)victimName);
            if (victim == null) {
                player.sendMessage((Component)Component.text((String)"<> This player is offline. Go wake them up or smth."));
                return;
            }
            PlayerUtils.revive(victim);
            victim.teleport(deathLocation);
            victim.getWorld().playSound(player.getLocation(), Sound.BLOCK_RESPAWN_ANCHOR_DEPLETE, 1.0f, 1.0f);
            victim.getWorld().playSound(player.getLocation(), Sound.BLOCK_BELL_RESONATE, 1.0f, 1.0f);
            victim.sendMessage((Component)Component.text((String)("<> You have been revived by " + player.getName())));
            droppedItem.remove();
            break;
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player victim = event.getEntity();
        Player killer = victim.getKiller();
        if (killer == null) {
            return;
        }
        if (!ItemUtils.hasScatter(killer)) {
            return;
        }
        event.setCancelled(true);
        PlayerUtils.trap(victim, killer);
        victim.setHealth(victim.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
    }

    @EventHandler
    public void onEntityDamagedByEntity(EntityDamageByEntityEvent event) {
        Player damager;
        Entity entity = event.getDamager();
        if (entity instanceof Player && PlayerUtils.isScatterAffected(damager = (Player)entity)) {
            event.setCancelled(true);
            return;
        }
        entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        if (PlayerUtils.isScattered(victim)) {
            event.setCancelled(true);
            return;
        }
        if (!PlayerUtils.isTrapped(victim)) {
            return;
        }
        Scatterred scatterred = Scatter.configManager.scatteredPlayers.get(victim.getName());
        event.setCancelled(true);
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player damager2 = (Player)entity2;
        if (damager2.getName().equals(scatterred.killer) && damager2.getInventory().getItemInMainHand().getType().isAir()) {
            PlayerUtils.release(victim);
            return;
        }
        if (ItemUtils.hasScatter(damager2)) {
            --scatterred.remainingHits;
            victim.damage(1.0);
            victim.setHealth(1.0 + (victim.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() - 1.0) * ((double)scatterred.remainingHits / 3.0));
            damager2.sendMessage((Component)Component.text((String)("<> " + (3 - scatterred.remainingHits) + "/3")));
            damager2.getWorld().playSound(damager2.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_BREAK, 1.0f, 1.0f);
            if (scatterred.remainingHits <= 0) {
                this.finalizeTrap(victim);
            }
        }
    }

    private void finalizeTrap(Player victim) {
        PlayerUtils.scatter(victim, Scatter.configManager.scatteredPlayers.get((Object)victim.getName()).killer);
        victim.getWorld().playSound(victim.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
        victim.getWorld().spawnParticle(Particle.TOTEM, victim.getLocation(), 50);
        PlayerUtils.dropInventory(victim);
        PlayerUtils.dropEnderChest(victim);
        victim.kick((Component)Component.text((String)"There is no way back... Or is it?"));
    }

    @EventHandler
    public void onEntityDamaged(EntityDamageEvent event) {
        Player victim;
        Entity entity = event.getEntity();
        if (entity instanceof Player && PlayerUtils.isScatterAffected(victim = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (PlayerUtils.isTrapped(player)) {
            Location from = event.getFrom();
            Location to = event.getTo();
            Location loc = from.clone();
            loc.setPitch(to.getPitch());
            loc.setYaw(to.getYaw());
            if (loc.getY() < to.getY()) {
                loc.setY(to.getY());
            }
            player.teleport(loc);
        } else if (Scatter.configManager.controlledMobs.containsKey(event.getPlayer().getName())) {
            Entity mob = Scatter.configManager.controlledMobs.get(player.getName());
            Location to = event.getTo();
            mob.teleport(to);
            mob.setRotation(to.getYaw(), to.getPitch());
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (PlayerUtils.isScatterAffected(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!PlayerUtils.isScatterAffected(player)) {
            return;
        }
        event.joinMessage(null);
        player.setGameMode(GameMode.ADVENTURE);
        PlayerUtils.setVisibilityToAllPlayers(player, false);
        player.setCanPickupItems(false);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!PlayerUtils.isScatterAffected(player)) {
            return;
        }
        if (PlayerUtils.isScattered(player)) {
            event.quitMessage(null);
            Scatter.configManager.controlledMobs.remove(player.getName());
        }
        if (PlayerUtils.isTrapped(player)) {
            this.finalizeTrap(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncChatEvent event) {
        if (PlayerUtils.isScattered(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerAdvancement(PlayerAdvancementDoneEvent event) {
        if (PlayerUtils.isScattered(event.getPlayer())) {
            event.message(null);
        }
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (PlayerUtils.isScattered(event.getPlayer()) && !event.getPlayer().isOp()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        LivingEntity mob = (LivingEntity)event.getRightClicked();
        if (PlayerUtils.isScattered(player) && !Scatter.blockedControl.contains(mob.getType())) {
            Scatter.configManager.controlledMobs.put(player.getName(), (Entity)mob);
            player.teleport(mob.getLocation());
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDoSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (event.isSneaking() && PlayerUtils.isScattered(player)) {
            Scatter.configManager.controlledMobs.remove(player.getName());
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        Player player;
        Entity entity = event.getTarget();
        if (entity instanceof Player && PlayerUtils.isScattered(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }
}

