/*
 * Decompiled with CFR 0.152.
 */
package org.lirox.scatter;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Consumer;
import org.lirox.scatter.Scatter;

public class ItemUtils {
    public static List<Integer> SCATTER_VALUES = List.of(Integer.valueOf(1), Integer.valueOf(3));
    public static List<Integer> REVIVER_VALUES = List.of(Integer.valueOf(2), Integer.valueOf(3));
    public static Consumer<ItemStack> decrementOrRemove = item -> {
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            item.setAmount(0);
        }
    };

    public static boolean isScatter(ItemStack item) {
        return item != null && item.getType() != Material.AIR && item.getItemMeta() != null && SCATTER_VALUES.contains(item.getItemMeta().getPersistentDataContainer().getOrDefault(Scatter.SCATTER_KEY, PersistentDataType.INTEGER, (Object)0));
    }

    public static boolean hasScatterOffHand(Player player) {
        return ItemUtils.isScatter(player.getInventory().getItemInOffHand());
    }

    public static boolean hasScatterMainHand(Player player) {
        return ItemUtils.isScatter(player.getInventory().getItemInMainHand());
    }

    public static boolean hasScatter(Player player) {
        return ItemUtils.hasScatterMainHand(player) || ItemUtils.hasScatterOffHand(player) || ItemUtils.isScatter(player.getInventory().getItem(EquipmentSlot.HEAD)) || ItemUtils.isScatter(player.getInventory().getItem(EquipmentSlot.CHEST)) || ItemUtils.isScatter(player.getInventory().getItem(EquipmentSlot.LEGS)) || ItemUtils.isScatter(player.getInventory().getItem(EquipmentSlot.FEET));
    }

    public static boolean isReviver(ItemStack item) {
        return item != null && item.getType() != Material.AIR && item.getItemMeta() != null && REVIVER_VALUES.contains(item.getItemMeta().getPersistentDataContainer().getOrDefault(Scatter.SCATTER_KEY, PersistentDataType.INTEGER, (Object)0));
    }

    public static boolean hasReviverOffHand(Player player) {
        return ItemUtils.isReviver(player.getInventory().getItemInOffHand());
    }

    public static boolean hasReviverMainHand(Player player) {
        return ItemUtils.isReviver(player.getInventory().getItemInMainHand());
    }

    public static boolean hasReviver(Player player) {
        return ItemUtils.hasReviverMainHand(player) || ItemUtils.hasReviverOffHand(player);
    }

    public static void removeOneScatter(Player player) {
        if (ItemUtils.hasScatterMainHand(player)) {
            decrementOrRemove.accept((Object)player.getInventory().getItemInMainHand());
            return;
        }
        if (ItemUtils.hasScatterOffHand(player)) {
            decrementOrRemove.accept((Object)player.getInventory().getItemInOffHand());
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack item = player.getInventory().getItem(slot);
            if (!ItemUtils.isScatter(item)) continue;
            decrementOrRemove.accept((Object)item);
            return;
        }
    }
}

