/*
 * Decompiled with CFR 0.152.
 */
package org.lirox.scatter;

import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.lirox.scatter.Scatter;
import org.lirox.scatter.Scatterred;

public class PlayerUtils {
    public static void setVisibilityToPlayer(Player player, Player seeker, boolean visibility) {
        if (visibility) {
            seeker.showPlayer((Plugin)Scatter.plugin, player);
        } else {
            seeker.hidePlayer((Plugin)Scatter.plugin, player);
        }
    }

    public static void setVisibilityToAllPlayers(Player player, boolean visibility) {
        for (Player seeker : Bukkit.getOnlinePlayers()) {
            PlayerUtils.setVisibilityToPlayer(player, seeker, visibility);
        }
    }

    public static boolean isScattered(Player player) {
        return PlayerUtils.isScatterAffected(player) && Scatter.configManager.scatteredPlayers.get((Object)player.getName()).state == 2;
    }

    public static boolean isTrapped(Player player) {
        return PlayerUtils.isScatterAffected(player) && Scatter.configManager.scatteredPlayers.get((Object)player.getName()).state == 1;
    }

    public static boolean isScatterAffected(Player player) {
        return Scatter.configManager.scatteredPlayers.containsKey(player.getName());
    }

    public static void dropItems(ItemStack[] items, Location location) {
        for (ItemStack item : items) {
            if (item == null) continue;
            location.getWorld().dropItemNaturally(location, item);
        }
    }

    public static void dropInventory(Player player) {
        PlayerUtils.dropItems(player.getInventory().getContents(), player.getLocation());
        player.getInventory().clear();
    }

    public static void dropEnderChest(Player player) {
        PlayerUtils.dropItems(player.getEnderChest().getContents(), player.getLocation());
        player.getEnderChest().clear();
    }

    public static void scatter(Player player, String killer) {
        Scatter.configManager.scatteredPlayers.put(player.getName(), new Scatterred(player.getName(), killer, 0, 2, 0, 0, player.getLocation()));
        PlayerUtils.setVisibilityToAllPlayers(player, false);
        player.setGameMode(GameMode.ADVENTURE);
        player.setCanPickupItems(false);
        Scatter.noMobPushTeam.addPlayer((OfflinePlayer)player);
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false));
        player.setHealth(1.0);
        player.setSaturation(0.0f);
    }

    public static void scatter(Player player, Player killer) {
        PlayerUtils.scatter(player, killer.getName());
    }

    public static void revive(Player player) {
        Scatter.configManager.scatteredPlayers.remove(player.getName());
        PlayerUtils.setVisibilityToAllPlayers(player, true);
        player.setGameMode(GameMode.SURVIVAL);
        player.setCanPickupItems(true);
        Scatter.noMobPushTeam.removePlayer((OfflinePlayer)player);
        player.removePotionEffect(PotionEffectType.INVISIBILITY);
        player.setHealth(10.0);
        player.setSaturation(10.0f);
    }

    public static void trap(Player player, String killer) {
        Scatter.configManager.scatteredPlayers.put(player.getName(), new Scatterred(player.getName(), killer, 3, 1, 0, 2400, player.getLocation()));
    }

    public static void trap(Player player, Player killer) {
        PlayerUtils.trap(player, killer.getName());
    }

    public static void release(Player player) {
        Scatter.configManager.scatteredPlayers.remove(player.getName());
    }
}

