/*
 * Decompiled with CFR 0.152.
 */
package org.lirox.scatter;

import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.lirox.scatter.ConfigManager;
import org.lirox.scatter.Events;
import org.lirox.scatter.Scatterred;
import org.lirox.scatter.commands.GhostCommand;
import org.lirox.scatter.commands.ScatterCommand;
import org.lirox.scatter.commands.TrapCommand;

public final class Scatter
extends JavaPlugin
implements Listener {
    public static ConfigManager configManager;
    private final Random rand = new Random();
    public static Scatter plugin;
    public static NamespacedKey SCATTER_KEY;
    public static Team noMobPushTeam;
    public static List<EntityType> blockedControl;

    public void onEnable() {
        blockedControl = List.of(EntityType.WITHER, EntityType.CREEPER, EntityType.PLAYER, EntityType.SHULKER, EntityType.RAVAGER, EntityType.HOGLIN, EntityType.ZOGLIN, EntityType.PIGLIN_BRUTE, EntityType.VINDICATOR, EntityType.ELDER_GUARDIAN, EntityType.VILLAGER, EntityType.HORSE, EntityType.DONKEY, EntityType.MULE, EntityType.CAT, EntityType.PARROT, EntityType.WOLF, EntityType.EVOKER);
        this.getServer().getPluginManager().registerEvents((Listener)new Events((Plugin)this), (Plugin)this);
        this.getCommand("scatter").setExecutor((CommandExecutor)new ScatterCommand());
        this.getCommand("trap").setExecutor((CommandExecutor)new TrapCommand());
        this.getCommand("ghost").setExecutor((CommandExecutor)new GhostCommand());
        plugin = (Scatter)Scatter.getPlugin(((Object)((Object)this)).getClass());
        SCATTER_KEY = new NamespacedKey((Plugin)plugin, "scatter");
        this.saveDefaultConfig();
        configManager = new ConfigManager(this.getConfig());
        configManager.load();
        this.spawnParticlesLoop();
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        noMobPushTeam = scoreboard.getTeam("noMobPush");
        if (noMobPushTeam == null) {
            noMobPushTeam = scoreboard.registerNewTeam("noMobPush");
            noMobPushTeam.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
        }
    }

    public void onDisable() {
        configManager.save();
    }

    private void spawnParticlesLoop() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            for (Map.Entry<String, Entity> entry : Scatter.configManager.controlledMobs.entrySet()) {
                entry.getValue().setVelocity(entry.getValue().getVelocity().zero());
            }
            for (Map.Entry<String, Object> entry : Scatter.configManager.scatteredPlayers.entrySet()) {
                Player player = Bukkit.getPlayer((String)entry.getKey());
                Scatterred scatterred = (Scatterred)entry.getValue();
                Location deathPos = scatterred.pos;
                if (scatterred.state == 2) {
                    Location pos = deathPos.clone().add(0.0, 1.0, 0.0);
                    if (player != null) {
                        deathPos.getWorld().spawnParticle(Particle.TOTEM, pos, 1, 0.3, 0.3, 0.3, 0.02);
                        player.setExp(this.rand.nextFloat());
                    }
                    deathPos.getWorld().spawnParticle(Particle.DRAGON_BREATH, pos, 1, 0.3, 0.3, 0.3, 0.05);
                    deathPos.getWorld().spawnParticle(Particle.END_ROD, pos, 5, 10.0, 10.0, 10.0, 0.05);
                    continue;
                }
                if (scatterred.state != 1 || player == null) continue;
                ++scatterred.animationTime;
                --scatterred.timeout;
                if (scatterred.timeout <= 0) {
                    Scatter.configManager.scatteredPlayers.remove(scatterred.victim);
                    continue;
                }
                int time = scatterred.animationTime;
                float radius = (float)(time < 20 ? 0.5 + (double)(1.0f - (float)time / 20.0f) : 0.5);
                Location center = player.getLocation();
                Vector angle1 = new Vector(0.0, (double)time / 5.0, 0.0);
                Vector angle2 = new Vector(180.0, (double)(-time) / 5.0, 0.0);
                Vector size = new Vector(radius, 1.0f, 0.0f);
                Particle.DustOptions options = new Particle.DustOptions(Color.YELLOW, 1.0f);
                this.particleChain(center, angle1, size, options);
                this.particleChain(center, angle2, size, options);
            }
        }, 0L, 1L);
    }

    public Vector lerp(Vector start, Vector end, double t) {
        double x = start.getX() + (end.getX() - start.getX()) * t;
        double y = start.getY() + (end.getY() - start.getY()) * t;
        double z = start.getZ() + (end.getZ() - start.getZ()) * t;
        return new Vector(x, y, z);
    }

    private void particleChain(Location pos, Vector angle, Vector size, Particle.DustOptions options) {
        int i;
        float radius = (float)size.getX();
        double verticalOffset = size.getY();
        double baseAngle = Math.toRadians(angle.getY());
        Vector[] square = new Vector[4];
        for (i = 0; i < 4; ++i) {
            double angleOffset = baseAngle + Math.toRadians(i * 90);
            double offsetX = (double)radius * Math.cos(angleOffset);
            double offsetZ = (double)radius * Math.sin(angleOffset);
            double rotatedY = offsetX * Math.sin(baseAngle) + offsetZ * Math.cos(baseAngle) + verticalOffset;
            double rotatedX = offsetX * Math.cos(baseAngle) - offsetZ * Math.sin(baseAngle);
            square[i] = new Vector(rotatedX, rotatedY, offsetZ);
        }
        for (i = 0; i < 4; ++i) {
            Vector start = square[i];
            Vector end = square[(i + 1) % 4];
            for (double t = 0.0; t <= 1.0; t += 0.1) {
                Vector point = this.lerp(start, end, t);
                pos.add(point);
                pos.getWorld().spawnParticle(Particle.REDSTONE, pos, 1, (Object)options);
                pos.subtract(point);
            }
        }
    }
}

