/*
 * Decompiled with CFR 0.152.
 */
package com.bundleincreative.bundleincreative;

import com.bundleincreative.bundleincreative.BundleInCreativeConfig;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class BundleInCreativeConfigScreen
extends Screen {
    private static final List<TabOption> TAB_OPTIONS = List.of(new TabOption("tools_and_utilities", (Component)Component.m_237113_((String)"Tools & Utilities")), new TabOption("building_blocks", (Component)Component.m_237113_((String)"Building Blocks")), new TabOption("natural_blocks", (Component)Component.m_237113_((String)"Natural Blocks")), new TabOption("functional_blocks", (Component)Component.m_237113_((String)"Functional Blocks")), new TabOption("redstone", (Component)Component.m_237113_((String)"Redstone Blocks")), new TabOption("combat", (Component)Component.m_237113_((String)"Combat")), new TabOption("food_and_drinks", (Component)Component.m_237113_((String)"Food & Drinks")), new TabOption("ingredients", (Component)Component.m_237113_((String)"Ingredients")), new TabOption("spawn_eggs", (Component)Component.m_237113_((String)"Spawn Eggs")));
    private static final List<BundleInCreativeConfig.Common.RecipeMode> RECIPE_OPTIONS = List.of(BundleInCreativeConfig.Common.RecipeMode.OFF, BundleInCreativeConfig.Common.RecipeMode.RABBIT, BundleInCreativeConfig.Common.RecipeMode.LEATHER, BundleInCreativeConfig.Common.RecipeMode.BOTH);
    private final Screen parent;
    private boolean showBundle;
    private BundleInCreativeConfig.Common.RecipeMode recipeMode;
    private TabOption selectedTab;

    public BundleInCreativeConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Bundle In Creative Settings"));
        this.parent = parent;
        this.showBundle = (Boolean)BundleInCreativeConfig.COMMON.enableBundle.get();
        this.recipeMode = (BundleInCreativeConfig.Common.RecipeMode)((Object)BundleInCreativeConfig.COMMON.recipeMode.get());
        this.selectedTab = TAB_OPTIONS.stream().filter(option -> option.id().equals(BundleInCreativeConfig.COMMON.creativeTab.get())).findFirst().orElse(TAB_OPTIONS.get(0));
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int y = this.f_96544_ / 4;
        this.m_142416_((GuiEventListener)CycleButton.m_168919_().m_168948_((Object)this.showBundle).m_168936_(centerX - 100, y, 200, 20, (Component)Component.m_237113_((String)"Show in Creative"), (button, value) -> {
            this.showBundle = value;
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168894_(TabOption::label).m_232502_(TAB_OPTIONS).m_168948_((Object)this.selectedTab).m_168936_(centerX - 100, y += 28, 200, 20, (Component)Component.m_237113_((String)"Creative Tab"), (button, value) -> {
            this.selectedTab = value;
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168894_(BundleInCreativeConfigScreen::recipeModeLabel).m_232502_(RECIPE_OPTIONS).m_168948_((Object)this.recipeMode).m_168936_(centerX - 100, y += 28, 200, 20, (Component)Component.m_237113_((String)"Bundle Recipe"), (button, value) -> {
            this.recipeMode = value;
        }));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> this.m_7379_()).m_252987_(centerX - 100, y += 40, 200, 20).m_253136_());
    }

    public void m_7379_() {
        this.saveSettings();
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void saveSettings() {
        BundleInCreativeConfig.COMMON.enableBundle.set((Object)this.showBundle);
        BundleInCreativeConfig.COMMON.creativeTab.set((Object)this.selectedTab.id());
        BundleInCreativeConfig.COMMON.recipeMode.set((Object)this.recipeMode);
        BundleInCreativeConfig.save();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private static Component recipeModeLabel(BundleInCreativeConfig.Common.RecipeMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case BundleInCreativeConfig.Common.RecipeMode.OFF -> Component.m_237113_((String)"Off");
            case BundleInCreativeConfig.Common.RecipeMode.RABBIT -> Component.m_237113_((String)"Rabbit Hide");
            case BundleInCreativeConfig.Common.RecipeMode.LEATHER -> Component.m_237113_((String)"Leather");
            case BundleInCreativeConfig.Common.RecipeMode.BOTH -> Component.m_237113_((String)"Both Recipes");
        };
    }

    private record TabOption(String id, Component label) {
    }
}

