/*
 * Decompiled with CFR 0.152.
 */
package com.bundleincreative.bundleincreative;

import com.bundleincreative.bundleincreative.BundleInCreativeConfig;
import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class BundleRecipeCondition
implements ICondition {
    static final ResourceLocation ID = new ResourceLocation("bundleincreative", "enable_recipe");
    private final RecipeType recipeType;

    BundleRecipeCondition(RecipeType recipeType) {
        this.recipeType = recipeType;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        BundleInCreativeConfig.Common.RecipeMode mode = (BundleInCreativeConfig.Common.RecipeMode)((Object)BundleInCreativeConfig.COMMON.recipeMode.get());
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case BundleInCreativeConfig.Common.RecipeMode.OFF -> false;
            case BundleInCreativeConfig.Common.RecipeMode.RABBIT -> {
                if (this.recipeType == RecipeType.RABBIT) {
                    yield true;
                }
                yield false;
            }
            case BundleInCreativeConfig.Common.RecipeMode.LEATHER -> {
                if (this.recipeType == RecipeType.LEATHER) {
                    yield true;
                }
                yield false;
            }
            case BundleInCreativeConfig.Common.RecipeMode.BOTH -> true;
        };
    }

    static enum RecipeType {
        RABBIT,
        LEATHER;

    }

    public static final class Serializer
    implements IConditionSerializer<BundleRecipeCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public ResourceLocation getID() {
            return ID;
        }

        public BundleRecipeCondition read(JsonObject json) {
            String typeValue = GsonHelper.m_13851_((JsonObject)json, (String)"recipe_type", (String)"rabbit");
            RecipeType type = RecipeType.valueOf(typeValue.toUpperCase(Locale.ROOT));
            return new BundleRecipeCondition(type);
        }

        public void write(JsonObject json, BundleRecipeCondition value) {
            json.addProperty("recipe_type", value.recipeType.name().toLowerCase(Locale.ROOT));
        }
    }
}

