/*
 * Decompiled with CFR 0.152.
 */
package net.villagerultimate.forcebound.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.villagerultimate.forcebound.entity.AnakinEntity;
import net.villagerultimate.forcebound.entity.BlueBlasterProjectileEntity;
import net.villagerultimate.forcebound.entity.DinDjarinEntity;
import net.villagerultimate.forcebound.entity.LukeEntity;
import net.villagerultimate.forcebound.entity.SoloBlasterProjectileEntity;
import net.villagerultimate.forcebound.entity.TrooperEntity;
import net.villagerultimate.forcebound.entity.YellowBlasterProjectileEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ForceboundModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"forcebound");
    public static final DeferredHolder<EntityType<?>, EntityType<SoloBlasterProjectileEntity>> SOLO_BLASTER_PROJECTILE = ForceboundModEntities.register("solo_blaster_projectile", EntityType.Builder.of(SoloBlasterProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<AnakinEntity>> ANAKIN = ForceboundModEntities.register("anakin", EntityType.Builder.of(AnakinEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<LukeEntity>> LUKE = ForceboundModEntities.register("luke", EntityType.Builder.of(LukeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<TrooperEntity>> TROOPER = ForceboundModEntities.register("trooper", EntityType.Builder.of(TrooperEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<BlueBlasterProjectileEntity>> BLUE_BLASTER_PROJECTILE = ForceboundModEntities.register("blue_blaster_projectile", EntityType.Builder.of(BlueBlasterProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<YellowBlasterProjectileEntity>> YELLOW_BLASTER_PROJECTILE = ForceboundModEntities.register("yellow_blaster_projectile", EntityType.Builder.of(YellowBlasterProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<DinDjarinEntity>> DIN_DJARIN = ForceboundModEntities.register("din_djarin", EntityType.Builder.of(DinDjarinEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forcebound", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        AnakinEntity.init(event);
        LukeEntity.init(event);
        TrooperEntity.init(event);
        DinDjarinEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ANAKIN.get(), AnakinEntity.createAttributes().build());
        event.put((EntityType)LUKE.get(), LukeEntity.createAttributes().build());
        event.put((EntityType)TROOPER.get(), TrooperEntity.createAttributes().build());
        event.put((EntityType)DIN_DJARIN.get(), DinDjarinEntity.createAttributes().build());
    }
}

