/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.conversion.type;

import com.bergerkiller.bukkit.common.component.LibraryComponent;
import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.resources.ResourceKey;
import com.bergerkiller.bukkit.common.resources.SoundEffect;
import com.bergerkiller.bukkit.common.wrappers.Holder;
import com.bergerkiller.generated.net.minecraft.sounds.SoundEffectHandle;
import com.bergerkiller.generated.net.minecraft.world.effect.MobEffectListHandle;
import com.bergerkiller.generated.net.minecraft.world.entity.ai.attributes.AttributeBaseHandle;
import com.bergerkiller.mountiplex.conversion.annotations.ConverterMethod;
import com.bergerkiller.mountiplex.reflection.declarations.Template;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;

public class MC1_18_2_Conversion {
    private static WeakHashMap<Object, Object> holdersByDimensionManager = new WeakHashMap();
    private static HolderLogic handler;

    public static void init() {
        handler = Template.Class.create(HolderLogic.class);
        handler.forceInitialization();
    }

    public static LibraryComponent initComponent(final CommonPlugin plugin) {
        return new LibraryComponent(){

            @Override
            public void enable() throws Throwable {
                for (World world : Bukkit.getWorlds()) {
                    MC1_18_2_Conversion.track(world);
                }
                plugin.register(new Listener(){

                    @EventHandler(priority=EventPriority.LOWEST)
                    public void onWorldInit(WorldInitEvent event) {
                        MC1_18_2_Conversion.track(event.getWorld());
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disable() throws Throwable {
                WeakHashMap weakHashMap = holdersByDimensionManager;
                synchronized (weakHashMap) {
                    holdersByDimensionManager.clear();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void track(World world) {
        WeakHashMap<Object, Object> weakHashMap = holdersByDimensionManager;
        synchronized (weakHashMap) {
            holdersByDimensionManager.put(handler.getDimensionTypeOfWorld(world), handler.getHolderOfWorld(world));
        }
    }

    @ConverterMethod(input="net.minecraft.core.Holder<net.minecraft.world.level.dimension.DimensionManager>", output="net.minecraft.world.level.dimension.DimensionManager")
    public static Object fromHolderToDimensionManager(Object holder) {
        return handler.getValue(holder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConverterMethod(input="net.minecraft.world.level.dimension.DimensionManager", output="net.minecraft.core.Holder<net.minecraft.world.level.dimension.DimensionManager>")
    public static Object fromDimensionManagerToHolder(Object dimensionManager) {
        WeakHashMap<Object, Object> weakHashMap = holdersByDimensionManager;
        synchronized (weakHashMap) {
            Object holder = holdersByDimensionManager.get(dimensionManager);
            if (holder == null) {
                throw new IllegalArgumentException("Unknown or unregistered dimension type");
            }
            return holder;
        }
    }

    @ConverterMethod(input="net.minecraft.core.Holder<net.minecraft.sounds.SoundEffect>")
    public static ResourceKey<SoundEffect> soundEffectHolderToResourceKey(Object nmsHolderHandle) {
        return ResourceKey.fromResourceKeyHandle(handler.getResourceKey(nmsHolderHandle));
    }

    @ConverterMethod(output="net.minecraft.core.Holder<net.minecraft.sounds.SoundEffect>")
    public static Object soundEffectHolderFromResourceKey(ResourceKey<SoundEffect> soundKey) {
        return SoundEffectHandle.T.rawSoundEffectResourceKeyToHolder.invoke(soundKey.getRawHandle());
    }

    @ConverterMethod(input="net.minecraft.core.Holder<net.minecraft.world.effect.MobEffectList>")
    public static Holder<MobEffectListHandle> wrapMobEffectHolder(Object nmsHolder) {
        return Holder.fromHandle(nmsHolder, MobEffectListHandle::createHandle);
    }

    @ConverterMethod(output="net.minecraft.core.Holder<net.minecraft.world.effect.MobEffectList>")
    public static Object unwrapMobEffectHolder(Holder<MobEffectListHandle> holder) {
        return holder.toRawHolder();
    }

    @ConverterMethod(input="net.minecraft.core.Holder<net.minecraft.world.entity.ai.attributes.AttributeBase>")
    public static Holder<AttributeBaseHandle> wrapAttributeHolder(Object nmsHolder) {
        return Holder.fromHandle(nmsHolder, AttributeBaseHandle::createHandle);
    }

    @ConverterMethod(output="net.minecraft.core.Holder<net.minecraft.world.entity.ai.attributes.AttributeBase>")
    public static Object unwrapAttributeHolder(Holder<AttributeBaseHandle> holder) {
        return holder.toRawHolder();
    }

    @Template.Optional
    @Template.ImportList(value={@Template.Import(value="org.bukkit.craftbukkit.CraftWorld"), @Template.Import(value="net.minecraft.world.level.dimension.DimensionManager")})
    @Template.InstanceType(value="net.minecraft.core.Holder")
    public static abstract class HolderLogic
    extends Template.Class<Template.Handle> {
        @Template.Generated(value="public static Object getValue(Holder holder) {\n    return holder.value();\n}")
        public abstract Object getValue(Object var1);

        @Template.Generated(value="public static Object getResourceKey(Holder holder) {\n    return holder.unwrapKey().orElse(null);\n}")
        public abstract Object getResourceKey(Object var1);

        @Template.Generated(value="public static Object getDimensionType(CraftWorld world) {\n    return world.getHandle().dimensionType();\n}")
        public abstract Object getDimensionTypeOfWorld(World var1);

        @Template.Generated(value="public static Object getHolder(CraftWorld world) {\n    return ((net.minecraft.world.level.World) world.getHandle()).dimensionTypeRegistration();\n}")
        public abstract Object getHolderOfWorld(World var1);
    }
}

