/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.entity.type;

import com.bergerkiller.bukkit.common.entity.CommonEntity;
import com.bergerkiller.bukkit.common.utils.MathUtil;
import com.bergerkiller.bukkit.common.utils.WorldUtil;
import com.bergerkiller.generated.net.minecraft.world.entity.EntityLivingHandle;
import com.bergerkiller.generated.net.minecraft.world.entity.ai.attributes.GenericAttributesHandle;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.util.Vector;

public class CommonLivingEntity<T extends LivingEntity>
extends CommonEntity<T> {
    public CommonLivingEntity(T entity) {
        super(entity);
    }

    public double getEyeHeight() {
        return ((LivingEntity)this.entity).getEyeHeight();
    }

    public double getEyeHeight(boolean ignoreSneaking) {
        return ((LivingEntity)this.entity).getEyeHeight(ignoreSneaking);
    }

    public Location getEyeLocation() {
        return ((LivingEntity)this.entity).getEyeLocation();
    }

    public Block getTargetBlock() {
        return this.getTargetBlock(5.0);
    }

    public Block getTargetBlock(double maxDistance) {
        return WorldUtil.rayTraceBlock(this.getEyeLocation(), maxDistance);
    }

    public EntityEquipment getEquipment() {
        return ((LivingEntity)this.entity).getEquipment();
    }

    public double getMaxHealth() {
        return this.handle.cast(EntityLivingHandle.T).getMaxHealth();
    }

    public double getHealth() {
        EntityLivingHandle handle = this.handle.cast(EntityLivingHandle.T);
        return MathUtil.clamp(handle.getHealth(), 0.0f, handle.getMaxHealth());
    }

    public void setHealth(double health) {
        ((LivingEntity)this.entity).setHealth(health);
    }

    public void damage(double damage) {
        ((LivingEntity)this.entity).damage(damage);
    }

    public void damage(double damage, Entity damager) {
        ((LivingEntity)this.entity).damage(damage, damager);
    }

    public Vector getMovement() {
        return MathUtil.getDirection(this.loc.getYaw(), this.loc.getPitch()).multiply(this.getForwardMovement());
    }

    public double getForwardMovement() {
        return EntityLivingHandle.T.getMoveIntent.invoke(this.getHandle()).getZ();
    }

    public void setPathfindingRange(double range) {
        EntityLivingHandle nmsEntity = this.handle.cast(EntityLivingHandle.T);
        nmsEntity.getAttribute(GenericAttributesHandle.FOLLOW_RANGE).setBaseValue(range);
    }

    public double getPathfindingRange() {
        EntityLivingHandle nmsEntity = this.handle.cast(EntityLivingHandle.T);
        return nmsEntity.getAttribute(GenericAttributesHandle.FOLLOW_RANGE).getBaseValue();
    }
}

