/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.internal;

import com.bergerkiller.bukkit.common.Common;
import com.bergerkiller.bukkit.common.Logging;
import com.bergerkiller.bukkit.common.conversion.DuplexConversion;
import com.bergerkiller.bukkit.common.conversion.type.DimensionResourceKeyConversion;
import com.bergerkiller.bukkit.common.conversion.type.HandleConversion;
import com.bergerkiller.bukkit.common.conversion.type.ItemSlotConversion;
import com.bergerkiller.bukkit.common.conversion.type.JOMLConversion;
import com.bergerkiller.bukkit.common.conversion.type.MC1_17_Conversion;
import com.bergerkiller.bukkit.common.conversion.type.MC1_18_2_Conversion;
import com.bergerkiller.bukkit.common.conversion.type.MC1_8_8_Conversion;
import com.bergerkiller.bukkit.common.conversion.type.MapConversion;
import com.bergerkiller.bukkit.common.conversion.type.NBTConversion;
import com.bergerkiller.bukkit.common.conversion.type.PropertyConverter;
import com.bergerkiller.bukkit.common.conversion.type.ScoreboardDisplaySlotConversion;
import com.bergerkiller.bukkit.common.conversion.type.SerializedEnumConversion;
import com.bergerkiller.bukkit.common.conversion.type.WrapperConversion;
import com.bergerkiller.bukkit.common.entity.CommonEntityType;
import com.bergerkiller.bukkit.common.internal.CommonClasses;
import com.bergerkiller.bukkit.common.internal.logging.CommonLog4jTestLogging;
import com.bergerkiller.bukkit.common.internal.logic.NullPacketDataSerializerInit;
import com.bergerkiller.bukkit.common.internal.logic.ScopedProblemReporterInit;
import com.bergerkiller.bukkit.common.internal.logic.UnsetDataWatcherItemInit;
import com.bergerkiller.bukkit.common.server.ArclightServer;
import com.bergerkiller.bukkit.common.server.ArclightServerLegacy;
import com.bergerkiller.bukkit.common.server.Bukkit4FabricServer;
import com.bergerkiller.bukkit.common.server.CatServerServer;
import com.bergerkiller.bukkit.common.server.CommonServer;
import com.bergerkiller.bukkit.common.server.CraftBukkitServer;
import com.bergerkiller.bukkit.common.server.MagmaServer;
import com.bergerkiller.bukkit.common.server.MagmaServerLegacy;
import com.bergerkiller.bukkit.common.server.MohistServer;
import com.bergerkiller.bukkit.common.server.NachoSpigotServer;
import com.bergerkiller.bukkit.common.server.PurpurServer;
import com.bergerkiller.bukkit.common.server.SpigotServer;
import com.bergerkiller.bukkit.common.server.SportBukkitServer;
import com.bergerkiller.bukkit.common.server.UnknownServer;
import com.bergerkiller.bukkit.common.server.test.TestServerFactory;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.wrappers.Brightness;
import com.bergerkiller.bukkit.common.wrappers.ItemDisplayMode;
import com.bergerkiller.bukkit.common.wrappers.RelativeFlags;
import com.bergerkiller.generated.net.minecraft.nbt.NBTBaseHandle;
import com.bergerkiller.generated.net.minecraft.nbt.NBTTagCompoundHandle;
import com.bergerkiller.generated.net.minecraft.nbt.NBTTagListHandle;
import com.bergerkiller.mountiplex.MountiplexUtil;
import com.bergerkiller.mountiplex.conversion.Conversion;
import com.bergerkiller.mountiplex.reflection.declarations.Template;
import com.bergerkiller.mountiplex.reflection.resolver.ClassPathResolver;
import com.bergerkiller.mountiplex.reflection.resolver.CompiledFieldNameResolver;
import com.bergerkiller.mountiplex.reflection.resolver.CompiledMethodNameResolver;
import com.bergerkiller.mountiplex.reflection.resolver.FieldAliasResolver;
import com.bergerkiller.mountiplex.reflection.resolver.FieldNameResolver;
import com.bergerkiller.mountiplex.reflection.resolver.MethodAliasResolver;
import com.bergerkiller.mountiplex.reflection.resolver.MethodNameResolver;
import com.bergerkiller.mountiplex.reflection.resolver.Resolver;
import com.bergerkiller.mountiplex.reflection.util.asm.MPLType;
import com.bergerkiller.templates.TemplateResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.Bukkit;

public class CommonBootstrap {
    public static boolean WARN_WHEN_INIT_SERVER = false;
    public static boolean WARN_WHEN_INIT_TEMPLATES = false;
    private static boolean _hasInitTemplates = false;
    private static boolean _hasInitTestServer = false;
    private static boolean _isSpigotServer = false;
    private static boolean _isPaperServer = false;
    private static boolean _isPurpurServer = false;
    private static CommonServer _commonServer = null;
    private static boolean _isInitializingCommonServer = false;
    private static TemplateResolver _templateResolver;
    private static boolean _isCompatible;
    private static String _incompatibleReason;

    public static boolean evaluateMCVersion(String operand, String version) {
        return CommonBootstrap.initCommonServer().evaluateMCVersion(operand, version);
    }

    public static boolean isSpigotServer() {
        CommonBootstrap.initCommonServer();
        return _isSpigotServer;
    }

    public static boolean isPaperServer() {
        CommonBootstrap.initCommonServer();
        return _isPaperServer;
    }

    public static boolean isPurpurServer() {
        CommonBootstrap.initCommonServer();
        return _isPurpurServer;
    }

    public static boolean verifyShadedAssets(Logger logger) {
        try {
            Class.forName("com.bergerkiller.mountiplex.MountiplexUtil");
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "BKCommonLib jar lacks required shaded dependencies. Please redownload the correct jar!");
            logger.log(Level.SEVERE, "If your BKCommonLib.jar is less than 5 MB then you probably downloaded the wrong file.");
            logger.log(Level.SEVERE, "If using a FTP client, make sure the file is fully transferred to the server.");
            return false;
        }
        return true;
    }

    public static boolean isCommonServerInitialized() {
        return _commonServer != null && _isCompatible;
    }

    public static boolean initCommonServerCheckCompatibility() {
        CommonBootstrap.initCommonServer();
        return _isCompatible;
    }

    public static void initCommonServerAssertCompatibility() {
        if (!CommonBootstrap.initCommonServerCheckCompatibility()) {
            throw new UnsupportedOperationException(_incompatibleReason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonServer initCommonServer() {
        if (_commonServer == null) {
            if (_isInitializingCommonServer) {
                throw new UnsupportedOperationException("CommonServer is already being initialized. Fix your code!");
            }
            _templateResolver = new TemplateResolver();
            Resolver.getPackageNameCache().addDefaultPackage("net.minecraft.server").addDefaultPackage("net.minecraft.core").addDefaultPackage("org.bukkit.craftbukkit").addDefaultPackage("com.mojang.authlib").addDefaultPackage("org.spigotmc");
            _isInitializingCommonServer = true;
            try {
                CommonServer server = null;
                if (CommonBootstrap.isTestMode()) {
                    CommonLog4jTestLogging.initLog4j();
                    server = new SpigotServer();
                    if (!server.init()) {
                        server = null;
                    }
                } else {
                    ArrayList<CraftBukkitServer> servers = new ArrayList<CraftBukkitServer>();
                    servers.add(new MohistServer());
                    servers.add(new MagmaServer());
                    servers.add(new MagmaServerLegacy());
                    servers.add(new ArclightServer());
                    servers.add(new ArclightServerLegacy());
                    servers.add(new CatServerServer());
                    servers.add(new Bukkit4FabricServer());
                    servers.add(new NachoSpigotServer());
                    servers.add(new PurpurServer());
                    servers.add(new SpigotServer());
                    servers.add(new SportBukkitServer());
                    servers.add(new CraftBukkitServer());
                    for (CommonServer commonServer : servers) {
                        try {
                            if (!commonServer.init()) continue;
                            server = commonServer;
                            break;
                        }
                        catch (Throwable t) {
                            Logging.LOGGER.log(Level.SEVERE, "An error occurred during server type detection:", t);
                        }
                    }
                }
                if (server == null) {
                    server = new UnknownServer();
                    server.init();
                }
                CommonServer.PostInitEvent event = new CommonServer.PostInitEvent(_templateResolver);
                try {
                    CommonBootstrap.initServerResolvers(server);
                    server.postInit(event);
                }
                catch (Throwable t) {
                    Logging.LOGGER.log(Level.SEVERE, "An error occurred during server bootstrapping:", t);
                    if (event.isCompatible()) {
                        event.signalIncompatible("Server bootstrapping failed: " + t.getMessage());
                    }
                    server = new UnknownServer();
                    try {
                        server.init();
                        server.postInit(new CommonServer.PostInitEvent(_templateResolver));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                _commonServer = server;
                _isCompatible = event.isCompatible();
                _incompatibleReason = event.getIncompatibleReason();
                _isSpigotServer = _commonServer instanceof SpigotServer;
                _isPaperServer = _commonServer instanceof SpigotServer && ((SpigotServer)_commonServer).isPaperServer();
                _isPurpurServer = _commonServer instanceof PurpurServer;
            }
            finally {
                _isInitializingCommonServer = false;
            }
            if (_isCompatible) {
                boolean oldWarnTemplates = WARN_WHEN_INIT_TEMPLATES;
                WARN_WHEN_INIT_TEMPLATES = true;
                CommonBootstrap.initResolvers(_commonServer);
                WARN_WHEN_INIT_TEMPLATES = oldWarnTemplates;
            }
        }
        return _commonServer;
    }

    public static TemplateResolver initTemplates() {
        if (_hasInitTemplates) {
            return _templateResolver;
        }
        _hasInitTemplates = true;
        if (!CommonBootstrap.initCommonServerCheckCompatibility()) {
            return _templateResolver;
        }
        if (WARN_WHEN_INIT_TEMPLATES) {
            Logging.LOGGER.log(Level.WARNING, "WARN_WHEN_INIT_TEMPLATES", new RuntimeException("Initializing templates"));
        }
        _templateResolver.load();
        Resolver.registerClassDeclarationResolver(_templateResolver);
        MountiplexUtil.registerUnloader(_templateResolver::unload);
        return _templateResolver;
    }

    public static boolean isTestMode() {
        return _hasInitTestServer || Bukkit.getServer() == null;
    }

    public static void initServer() {
        CommonBootstrap.initCommonServerAssertCompatibility();
        if (!_hasInitTestServer && Bukkit.getServer() == null) {
            _hasInitTestServer = true;
            if (WARN_WHEN_INIT_SERVER) {
                Logging.LOGGER.log(Level.WARNING, "WARN_WHEN_INIT_SERVER", new RuntimeException("Initializing server"));
            }
            PrintStream oldout = System.out;
            PrintStream olderr = System.err;
            try {
                TestServerFactory.initTestServer();
            }
            finally {
                System.setOut(oldout);
                System.setErr(olderr);
            }
            Logging.LOGGER.log(Level.INFO, "Test running on " + Common.SERVER.getServerDetails());
        }
    }

    private static void initServerResolvers(CommonServer server) {
        if (server instanceof ClassPathResolver) {
            Resolver.registerClassResolver((ClassPathResolver)((Object)server));
        }
        if (server instanceof FieldNameResolver) {
            Resolver.registerFieldResolver((FieldNameResolver)((Object)server));
        }
        if (server instanceof MethodNameResolver) {
            Resolver.registerMethodResolver((MethodNameResolver)((Object)server));
        }
        if (server instanceof CompiledFieldNameResolver) {
            Resolver.registerCompiledFieldResolver((CompiledFieldNameResolver)((Object)server));
        }
        if (server instanceof CompiledMethodNameResolver) {
            Resolver.registerCompiledMethodResolver((CompiledMethodNameResolver)((Object)server));
        }
        if (server instanceof FieldAliasResolver) {
            Resolver.registerFieldAliasResolver((FieldAliasResolver)((Object)server));
        }
        if (server instanceof MethodAliasResolver) {
            Resolver.registerMethodAliasResolver((MethodAliasResolver)((Object)server));
        }
    }

    private static void initResolvers(CommonServer server) {
        boolean exists;
        String[] starlightNamespaces;
        boolean craftLegacyIsInUtil;
        HashMap<String, String> remappings = new HashMap<String, String>();
        remappings.put("net.minecraft.server.level.EntityTrackerEntryState", "net.minecraft.server.level.EntityTrackerEntry");
        remappings.put("com.bergerkiller.bukkit.common.internal.LongHashSet", "com.bergerkiller.bukkit.common.internal.proxy.LongHashSet_pre_1_13_2");
        remappings.put("com.bergerkiller.bukkit.common.internal.LongHashSet$LongIterator", "com.bergerkiller.bukkit.common.internal.proxy.LongHashSet_pre_1_13_2$LongIterator");
        remappings.put("net.minecraft.world.level.biome.BiomeSpawnCluster", "net.minecraft.world.level.biome.BiomeBase$BiomeMeta");
        remappings.put("net.minecraft.server.level.ChunkProviderServer$MainThreadExecutor", "net.minecraft.server.level.ChunkProviderServer$a");
        if (CommonBootstrap.evaluateMCVersion("<", "1.10.2")) {
            remappings.put("net.minecraft.world.level.EnumGamemode", "net.minecraft.world.level.WorldSettings$EnumGamemode");
        }
        if (CommonBootstrap.evaluateMCVersion("<", "1.14")) {
            remappings.put("net.minecraft.world.entity.player.EnumChatVisibility", "net.minecraft.world.entity.player.EntityHuman$EnumChatVisibility");
        }
        if (CommonBootstrap.evaluateMCVersion("<", "1.9")) {
            remappings.put("net.minecraft.world.level.MobSpawnerData", "net.minecraft.world.level.MobSpawnerAbstract$a");
            remappings.put("net.minecraft.world.level.block.SoundEffectType", "net.minecraft.world.level.block.Block$StepSound");
            remappings.put("net.minecraft.network.syncher.DataWatcher$Item", "net.minecraft.network.syncher.DataWatcher$WatchableObject");
            remappings.put("net.minecraft.network.syncher.DataWatcher$PackedItem", "net.minecraft.network.syncher.DataWatcher$WatchableObject");
            remappings.put("net.minecraft.server.level.PlayerChunk", "net.minecraft.server.level.PlayerChunkMap$PlayerChunk");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayInUseItem", "net.minecraft.network.protocol.game.PacketPlayInBlockPlace");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutCustomSoundEffect", "net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect");
            remappings.put("net.minecraft.world.entity.EnumItemSlot", "com.bergerkiller.bukkit.common.internal.proxy.EnumItemSlot");
            remappings.put("net.minecraft.world.level.chunk.DataPaletteBlock", "com.bergerkiller.bukkit.common.internal.proxy.DataPaletteBlock");
            remappings.put("net.minecraft.network.syncher.DataWatcherObject", "com.bergerkiller.bukkit.common.internal.proxy.DataWatcherObject");
            remappings.put("net.minecraft.sounds.SoundEffect", "com.bergerkiller.bukkit.common.internal.proxy.SoundEffect_1_8_8");
            remappings.put("net.minecraft.world.level.dimension.DimensionManager", "com.bergerkiller.bukkit.common.internal.proxy.DimensionManager_1_8_8");
            try {
                Class.forName(server.getNMSRoot() + ".MobEffectList");
            }
            catch (ClassNotFoundException e) {
                remappings.put("net.minecraft.world.effect.MobEffectList", "com.bergerkiller.bukkit.common.internal.proxy.MobEffectList");
            }
        }
        if (CommonBootstrap.evaluateMCVersion("<=", "1.8")) {
            remappings.put("net.minecraft.world.level.block.state.BlockStateList$BlockData", "net.minecraft.world.level.block.state.BlockData");
            remappings.put("net.minecraft.world.level.EnumGamemode", "net.minecraft.world.level.EnumGamemode");
            remappings.put("net.minecraft.world.level.block.SoundEffectType", "net.minecraft.world.level.block.StepSound");
            remappings.put("net.minecraft.world.level.block.Block$StepSound", "net.minecraft.world.level.block.StepSound");
            remappings.put("net.minecraft.core.EnumDirection$EnumAxis", "net.minecraft.core.EnumAxis");
            remappings.put("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$EnumPlayerInfoAction", "net.minecraft.network.protocol.game.EnumPlayerInfoAction");
            remappings.put("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$PlayerInfoData", "net.minecraft.network.protocol.game.PlayerInfoData");
            remappings.put("net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket$EnumPlayerInfoAction", "net.minecraft.network.protocol.game.EnumPlayerInfoAction");
            remappings.put("net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket$PlayerInfoData", "net.minecraft.network.protocol.game.PlayerInfoData");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayInUseEntity$EnumEntityUseAction", "net.minecraft.network.protocol.game.EnumEntityUseAction");
            remappings.put("net.minecraft.world.level.MobSpawnerData", "net.minecraft.world.level.block.entity.TileEntityMobSpawnerData");
            remappings.put("net.minecraft.network.syncher.DataWatcher$Item", "net.minecraft.network.syncher.WatchableObject");
            remappings.put("net.minecraft.network.syncher.DataWatcher$PackedItem", "net.minecraft.network.syncher.WatchableObject");
            remappings.put("net.minecraft.network.syncher.DataWatcher$WatchableObject", "net.minecraft.network.syncher.WatchableObject");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore$EnumScoreboardAction", "net.minecraft.network.protocol.game.EnumScoreboardAction");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutMapChunk$ChunkMap", "net.minecraft.network.protocol.game.ChunkMap");
            remappings.put("net.minecraft.world.entity.RelativeMovement", "net.minecraft.network.protocol.game.EnumPlayerTeleportFlags");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutTitle$EnumTitleAction", "net.minecraft.network.protocol.game.EnumTitleAction");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutCombatEvent$EnumCombatEventType", "net.minecraft.network.protocol.game.EnumCombatEventType");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutWorldBorder$EnumWorldBorderAction", "net.minecraft.network.protocol.game.EnumWorldBorderAction");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayInResourcePackStatus$EnumResourcePackStatus", "net.minecraft.network.protocol.game.EnumResourcePackStatus");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayInBlockDig$EnumPlayerDigType", "net.minecraft.network.protocol.game.EnumPlayerDigType");
            remappings.put("net.minecraft.world.entity.player.EnumChatVisibility", "net.minecraft.world.entity.player.EnumChatVisibility");
            remappings.put("net.minecraft.server.level.PlayerChunk", "net.minecraft.server.level.PlayerChunk");
            remappings.put("net.minecraft.util.WeightedRandom$WeightedRandomChoice", "net.minecraft.util.WeightedRandomChoice");
            remappings.put("net.minecraft.world.level.biome.BiomeSpawnCluster", "net.minecraft.world.level.biome.BiomeMeta");
            remappings.put("net.minecraft.util.IntHashMap$IntHashMapEntry", "net.minecraft.util.IntHashMapEntry");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutEntity$PacketPlayOutEntityLook", "net.minecraft.network.protocol.game.PacketPlayOutEntityLook");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutEntity$PacketPlayOutRelEntityMove", "net.minecraft.network.protocol.game.PacketPlayOutRelEntityMove");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutEntity$PacketPlayOutRelEntityMoveLook", "net.minecraft.network.protocol.game.PacketPlayOutRelEntityMoveLook");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayInFlying$PacketPlayInLook", "net.minecraft.network.protocol.game.PacketPlayInLook");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayInFlying$PacketPlayInPosition", "net.minecraft.network.protocol.game.PacketPlayInPosition");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayInFlying$PacketPlayInPositionLook", "net.minecraft.network.protocol.game.PacketPlayInPositionLook");
            remappings.put("net.minecraft.network.chat.IChatBaseComponent$ChatSerializer", "net.minecraft.network.chat.ChatSerializer");
            remappings.put("net.minecraft.network.NetworkManager$QueuedPacket", "net.minecraft.network.QueuedPacket");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutPosition$EnumPlayerTeleportFlags", "net.minecraft.network.protocol.game.EnumPlayerTeleportFlags");
            remappings.put("net.minecraft.network.chat.ChatClickable$EnumClickAction", "net.minecraft.network.chat.EnumClickAction");
            remappings.put("net.minecraft.network.chat.ChatHoverable$EnumHoverAction", "net.minecraft.network.chat.EnumHoverAction");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayInClientCommand$EnumClientCommand", "net.minecraft.network.protocol.game.EnumClientCommand");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayInEntityAction$EnumPlayerAction", "net.minecraft.network.protocol.game.EnumPlayerAction");
            remappings.put("net.minecraft.world.scores.criteria.IScoreboardCriteria$EnumScoreboardHealthDisplay", "net.minecraft.world.scores.criteria.EnumScoreboardHealthDisplay");
            remappings.put("net.minecraft.nbt.MojangsonParser$MojangsonTypeParser", "net.minecraft.nbt.MojangsonTypeParser");
        }
        if (CommonBootstrap.evaluateMCVersion("<", "1.11")) {
            remappings.put("net.minecraft.world.level.saveddata.maps.MapDecorationType", "com.bergerkiller.bukkit.common.internal.proxy.MapDecorationType_1_8_to_1_10_2");
        }
        if (CommonBootstrap.evaluateMCVersion("<", "1.13")) {
            remappings.put("net.minecraft.world.level.levelgen.HeightMap", "com.bergerkiller.bukkit.common.internal.proxy.HeightMapProxy_1_12_2");
            remappings.put("net.minecraft.world.level.levelgen.HeightMap$Type", "com.bergerkiller.bukkit.common.internal.proxy.HeightMapProxy_1_12_2$Type");
            remappings.put("com.bergerkiller.bukkit.common.internal.proxy.HeightMap.Type", "com.bergerkiller.bukkit.common.internal.proxy.HeightMapProxy_1_12_2$Type");
            remappings.put("net.minecraft.world.phys.shapes.VoxelShape", "com.bergerkiller.bukkit.common.internal.proxy.VoxelShapeProxy");
            remappings.put("net.minecraft.world.level.block.entity.TileEntityTypes", "com.bergerkiller.bukkit.common.internal.proxy.TileEntityTypesProxy_1_8_to_1_12_2");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutStopSound", "net.minecraft.network.protocol.game.PacketPlayOutCustomPayload");
        }
        if (CommonBootstrap.evaluateMCVersion("<=", "1.8")) {
            remappings.put("net.minecraft.world.entity.decoration.Paintings", "net.minecraft.world.entity.decoration.EnumArt");
        } else if (CommonBootstrap.evaluateMCVersion("<", "1.13")) {
            remappings.put("net.minecraft.world.entity.decoration.Paintings", "net.minecraft.world.entity.decoration.EntityPainting$EnumArt");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.14") && CommonBootstrap.evaluateMCVersion("<=", "1.14.1")) {
            remappings.put("net.minecraft.world.level.block.state.pattern.ShapeDetector$Shape", "net.minecraft.world.level.block.state.pattern.ShapeDetector$c");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.13")) {
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore$EnumScoreboardAction", "net.minecraft.server.ScoreboardServer$Action");
        } else {
            remappings.put("net.minecraft.core.particles.Particle", "net.minecraft.core.particles.EnumParticle");
            remappings.put("net.minecraft.core.particles.Particles", "net.minecraft.core.particles.EnumParticle");
            remappings.put("net.minecraft.core.particles.ParticleType", "net.minecraft.core.particles.EnumParticle");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.14")) {
            String unimi_fastutil_path = "org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.";
            try {
                MPLType.getClassByName(unimi_fastutil_path + "longs.LongSet");
                for (String fastutilClass : new String[]{"ints.Int2ObjectMap", "ints.Int2ObjectOpenHashMap", "ints.IntList", "ints.IntLists", "ints.IntArrayList", "longs.Long2ObjectMap", "longs.Long2ObjectOpenHashMap", "longs.Long2ObjectLinkedOpenHashMap", "longs.Long2IntOpenHashMap", "longs.LongIterator", "longs.LongLinkedOpenHashSet", "longs.LongOpenHashSet", "longs.LongSet", "longs.LongSortedSet", "longs.LongBidirectionalIterator", "objects.Object2IntMap", "objects.ObjectCollection", "objects.ObjectIterator"}) {
                    remappings.put("it.unimi.dsi.fastutil." + fastutilClass, unimi_fastutil_path + fastutilClass);
                }
            }
            catch (ClassNotFoundException ex) {
                unimi_fastutil_path = "it.unimi.dsi.fastutil.";
            }
            remappings.put("com.bergerkiller.bukkit.common.internal.LongHashSet", unimi_fastutil_path + "longs.LongSet");
            remappings.put("org.bukkit.craftbukkit.util.LongObjectHashMap", unimi_fastutil_path + "longs.Long2ObjectMap");
            remappings.put("net.minecraft.util.IntHashMap", unimi_fastutil_path + "ints.Int2ObjectMap");
            remappings.put("net.minecraft.util.IntHashMap$IntHashMapEntry", unimi_fastutil_path + "ints.Int2ObjectMap$Entry");
            remappings.put(unimi_fastutil_path + "ints.IntHashMap$IntHashMapEntry", unimi_fastutil_path + "ints.Int2ObjectMap$Entry");
            remappings.put("net.minecraft.server.level.EntityTracker", "net.minecraft.server.level.PlayerChunkMap");
            remappings.put("net.minecraft.server.level.EntityTrackerEntry", "net.minecraft.server.level.PlayerChunkMap$EntityTracker");
        }
        if (CommonBootstrap.evaluateMCVersion("<", "1.15.2")) {
            craftLegacyIsInUtil = true;
        } else if (CommonBootstrap.evaluateMCVersion("==", "1.15.2")) {
            try {
                Class.forName(server.getCBRoot() + ".legacy.CraftLegacy");
                craftLegacyIsInUtil = false;
            }
            catch (Throwable t) {
                craftLegacyIsInUtil = true;
            }
        } else {
            craftLegacyIsInUtil = false;
        }
        if (craftLegacyIsInUtil) {
            remappings.put("org.bukkit.craftbukkit.legacy.CraftLegacy", "org.bukkit.craftbukkit.util.CraftLegacy");
        }
        if (CommonBootstrap.evaluateMCVersion("<", "1.16")) {
            remappings.put("net.minecraft.resources.ResourceKey", "com.bergerkiller.bukkit.common.internal.proxy.ResourceKey_1_15_2");
        }
        if (CommonBootstrap.evaluateMCVersion("<", "1.16")) {
            remappings.put("net.minecraft.world.level.storage.WorldDataServer", "net.minecraft.world.level.storage.WorldData");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.16.2")) {
            remappings.put("net.minecraft.world.level.biome.BiomeSpawnCluster", "net.minecraft.world.level.biome.BiomeSettingsMobs$c");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.17")) {
            remappings.put("net.minecraft.network.protocol.game.PacketPlayInUseEntity$EnumEntityUseAction", "net.minecraft.network.protocol.game.PacketPlayInUseEntity$b");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayInUseEntity$UseType", "net.minecraft.network.protocol.game.PacketPlayInUseEntity$EnumEntityUseAction");
            remappings.put("net.minecraft.world.level.saveddata.maps.WorldMap$PatchData", "net.minecraft.world.level.saveddata.maps.WorldMap$b");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.18")) {
            remappings.put("net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$BlockEntityData", "net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$a");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutMapChunk", "net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket");
            remappings.put("net.minecraft.server.level.ChunkProviderServer$MainThreadExecutor", "net.minecraft.server.level.ChunkProviderServer$b");
        } else {
            remappings.put("net.minecraft.world.ticks.TickListServer", "net.minecraft.world.level.TickListServer");
            remappings.put("net.minecraft.world.ticks.TickList", "net.minecraft.world.level.TickList");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.19")) {
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving", "net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityPainting", "net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity");
        } else {
            remappings.put("net.minecraft.util.RandomSource", "java.util.Random");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.19.3")) {
            remappings.put("net.minecraft.network.syncher.DataWatcher$PackedItem", "net.minecraft.network.syncher.DataWatcher$b");
            remappings.put("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket", "net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket");
            remappings.put("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$EnumPlayerInfoAction", "net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a");
            remappings.put("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$PlayerInfoData", "net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$b");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutCustomSoundEffect", "net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect");
        } else {
            remappings.put("net.minecraft.core.registries.BuiltInRegistries", "net.minecraft.core.IRegistry");
            remappings.putIfAbsent("net.minecraft.network.syncher.DataWatcher$PackedItem", "net.minecraft.network.syncher.DataWatcher$Item");
            remappings.put("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket", "net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo");
            remappings.putIfAbsent("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$EnumPlayerInfoAction", "net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo$EnumPlayerInfoAction");
            remappings.putIfAbsent("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$PlayerInfoData", "net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo$PlayerInfoData");
            remappings.put("net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket", "net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo");
            remappings.putIfAbsent("net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket$EnumPlayerInfoAction", "net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo$EnumPlayerInfoAction");
            remappings.putIfAbsent("net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket$PlayerInfoData", "net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo$PlayerInfoData");
        }
        if (!CommonBootstrap.evaluateMCVersion(">=", "1.19.4")) {
            remappings.put("net.minecraft.world.entity.RelativeMovement", "net.minecraft.network.protocol.game.PacketPlayOutPosition$EnumPlayerTeleportFlags");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.20")) {
            remappings.put("net.minecraft.world.level.storage.loot.LootParams$Builder", "net.minecraft.world.level.storage.loot.LootParams$a");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.20.2")) {
            remappings.put("net.minecraft.network.protocol.common.ServerboundResourcePackPacket$EnumResourcePackStatus", "net.minecraft.network.protocol.common.ServerboundResourcePackPacket$a");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn", "net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity");
            if (CommonBootstrap.evaluateMCVersion("<", "1.20.3")) {
                remappings.put("net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket", "net.minecraft.network.protocol.common.ClientboundResourcePackPacket");
            }
            if (CommonBootstrap.evaluateMCVersion("<", "1.20.5")) {
                Class<?> customPayloadType = null;
                try {
                    customPayloadType = MPLType.getClassByName("net.minecraft.network.protocol.common.custom.CustomPacketPayload");
                }
                catch (Throwable t) {
                    Logging.LOGGER_REFLECTION.log(Level.WARNING, "Unable to identify the CustomPacketPayload type", t);
                }
                String anonTypeName = null;
                if (customPayloadType != null) {
                    for (int n = 1; n < 1000; ++n) {
                        String name = server.getCBRoot() + ".entity.CraftPlayer$" + n;
                        try {
                            Class<?> type = MPLType.getClassByName(name);
                            if (!customPayloadType.isAssignableFrom(type)) continue;
                            anonTypeName = name;
                        }
                        catch (ClassNotFoundException e) {}
                        break;
                    }
                }
                if (anonTypeName != null) {
                    remappings.put("net.minecraft.network.protocol.common.custom.BukkitCustomPayload", anonTypeName);
                } else {
                    Logging.LOGGER_REFLECTION.log(Level.WARNING, "Unable to identify the Bukkit custom payload type");
                }
            }
        } else {
            remappings.put("net.minecraft.network.protocol.common.ServerboundKeepAlivePacket", "net.minecraft.network.protocol.game.PacketPlayInKeepAlive");
            remappings.put("net.minecraft.network.protocol.common.ClientboundKeepAlivePacket", "net.minecraft.network.protocol.game.PacketPlayOutKeepAlive");
            remappings.put("net.minecraft.network.protocol.common.ServerboundResourcePackPacket", "net.minecraft.network.protocol.game.PacketPlayInResourcePackStatus");
            remappings.put("net.minecraft.network.protocol.common.ServerboundResourcePackPacket$EnumResourcePackStatus", "net.minecraft.network.protocol.game.PacketPlayInResourcePackStatus$EnumResourcePackStatus");
            remappings.put("net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket", "net.minecraft.network.protocol.game.PacketPlayOutResourcePackSend");
            remappings.put("net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket", "net.minecraft.network.protocol.game.PacketPlayOutCustomPayload");
            remappings.put("net.minecraft.network.protocol.common.ClientboundDisconnectPacket", "net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect");
            remappings.put("net.minecraft.network.protocol.common.ServerboundClientInformationPacket", "net.minecraft.network.protocol.game.PacketPlayInSettings");
        }
        if (!CommonBootstrap.evaluateMCVersion(">=", "1.20.3")) {
            remappings.put("net.minecraft.network.protocol.game.ClientboundResetScorePacket", "net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.20.5")) {
            remappings.put("net.minecraft.network.syncher.DataWatcher$PackedItem", "net.minecraft.network.syncher.DataWatcher$c");
        } else {
            remappings.put("net.minecraft.world.level.chunk.status.ChunkStatus", "net.minecraft.world.level.chunk.ChunkStatus");
            remappings.put("net.minecraft.world.level.saveddata.maps.MapDecorationType", remappings.getOrDefault("net.minecraft.world.level.saveddata.maps.MapDecorationType", "net.minecraft.world.level.saveddata.maps.MapIcon$Type"));
            remappings.put("org.bukkit.craftbukkit.inventory.SerializableMeta", "org.bukkit.craftbukkit.inventory.CraftMetaItem$SerializableMeta");
            remappings.put("net.minecraft.world.item.component.CustomModelData", "com.bergerkiller.bukkit.common.internal.proxy.CustomModelData_pre_1_20_5");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.21.2")) {
            remappings.put("net.minecraft.world.entity.RelativeMovement", "net.minecraft.world.entity.Relative");
            remappings.put("net.minecraft.world.level.saveddata.maps.WorldMap$PatchData", "net.minecraft.world.level.saveddata.maps.WorldMap$c");
            remappings.put("net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport", "net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket");
            remappings.put("net.minecraft.world.entity.vehicle.NewMinecartBehavior$LerpStep", "net.minecraft.world.entity.vehicle.NewMinecartBehavior$a");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.21.5")) {
            remappings.put("net.minecraft.server.level.ChunkProviderServer$MainThreadExecutor", "net.minecraft.server.level.ChunkProviderServer$a");
        } else {
            remappings.put("net.minecraft.server.level.EntityPlayer$RespawnConfig", "com.bergerkiller.bukkit.common.internal.proxy.PlayerRespawnConfig_pre_1_21_5");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.21.6")) {
            remappings.put("net.minecraft.world.level.storage.ValueInput$TypedInputList", "net.minecraft.world.level.storage.ValueInput$a");
            remappings.put("net.minecraft.world.level.storage.ValueOutput$TypedOutputList", "net.minecraft.world.level.storage.ValueOutput$a");
            remappings.put("net.minecraft.world.level.storage.TagValueInput$TypedListWrapper", "net.minecraft.world.level.storage.TagValueInput$f");
            remappings.put("net.minecraft.world.level.storage.TagValueOutput$TypedListWrapper", "net.minecraft.world.level.storage.TagValueOutput$e");
        } else {
            remappings.put("net.minecraft.world.level.storage.ValueOutput", "net.minecraft.nbt.NBTTagCompound");
            remappings.put("net.minecraft.world.level.storage.ValueInput", "net.minecraft.nbt.NBTTagCompound");
            remappings.put("net.minecraft.world.level.storage.TagValueOutput", "net.minecraft.nbt.NBTTagCompound");
            remappings.put("net.minecraft.world.level.storage.TagValueInput", "net.minecraft.nbt.NBTTagCompound");
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.21.9")) {
            remappings.put("net.minecraft.world.level.storage.WorldData$RespawnData", "net.minecraft.world.level.storage.WorldData$a");
        }
        String defaultNamespace = "ca.spottedleaf.moonrise.patches.starlight.light.";
        for (String namespace : starlightNamespaces = new String[]{defaultNamespace, "ca.spottedleaf.starlight.common.light.", "ca.spottedleaf.starlight.light.", "com.tuinity.tuinity.chunk.light."}) {
            exists = false;
            try {
                MPLType.getClassByName(namespace + "StarLightEngine");
                exists = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!exists) continue;
            if (namespace.equals(defaultNamespace)) break;
            for (String name : new String[]{"SWMRNibbleArray", "StarLightInterface", "StarLightEngine", "SkyStarLightEngine", "BlockStarLightEngine"}) {
                remappings.put(defaultNamespace + name, namespace + name);
            }
            break;
        }
        defaultNamespace = "org.purpurmc.purpur.";
        String[] purpurNamespaces = new String[]{defaultNamespace, "net.pl3x.purpur."};
        for (String namespace : purpurNamespaces) {
            exists = false;
            try {
                MPLType.getClassByName(namespace + "PurpurConfig");
                exists = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!exists) continue;
            if (namespace.equals(defaultNamespace)) break;
            for (String name : new String[]{"PurpurConfig", "PurpurWorldConfig"}) {
                remappings.put(defaultNamespace + name, namespace + name);
            }
            break;
        }
        if (!remappings.isEmpty()) {
            if (server instanceof CraftBukkitServer) {
                ((CraftBukkitServer)server).setEarlyRemappings(remappings);
            } else {
                Resolver.registerClassResolver(classPath -> {
                    String remapped = (String)remappings.get(classPath);
                    return remapped != null ? remapped : classPath;
                });
            }
        }
        NullPacketDataSerializerInit.initialize();
        ScopedProblemReporterInit.initialize();
        UnsetDataWatcherItemInit.initialize();
        Conversion.registerConverters(WrapperConversion.class);
        Conversion.registerConverters(HandleConversion.class);
        Conversion.registerConverters(NBTConversion.class);
        Conversion.registerConverters(ItemDisplayMode.class);
        Conversion.registerConverters(Brightness.class);
        Conversion.registerConverters(CommonEntityType.class);
        Conversion.registerConverters(MapConversion.class);
        Conversion.registerConverters(RelativeFlags.class);
        boolean hasEquipmentSlotClass = false;
        try {
            Class.forName("org.bukkit.inventory.EquipmentSlot");
            hasEquipmentSlotClass = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (hasEquipmentSlotClass) {
            Conversion.registerConverters(ItemSlotConversion.class);
        }
        if (CommonBootstrap.evaluateMCVersion("<", "1.9")) {
            Conversion.registerConverters(MC1_8_8_Conversion.class);
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.17")) {
            MC1_17_Conversion.init();
            Conversion.registerConverters(MC1_17_Conversion.class);
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.16") && CommonBootstrap.evaluateMCVersion("<=", "1.16.1") || CommonBootstrap.evaluateMCVersion(">=", "1.19")) {
            try {
                DimensionResourceKeyConversion.init();
                Conversion.registerConverters(DimensionResourceKeyConversion.class);
            }
            catch (Throwable t) {
                Logging.LOGGER_REFLECTION.log(Level.SEVERE, "Failed to register ResourceKey<>DimensionManager converter", t);
            }
        }
        if (CommonBootstrap.evaluateMCVersion(">=", "1.18.2")) {
            MC1_18_2_Conversion.init();
            Conversion.registerConverters(MC1_18_2_Conversion.class);
        }
        try {
            ScoreboardDisplaySlotConversion.init();
            Conversion.registerConverters(ScoreboardDisplaySlotConversion.class);
        }
        catch (Throwable t) {
            Logging.LOGGER_REFLECTION.log(Level.SEVERE, "Failed to register Scoreboard DisplaySlot converters", t);
        }
        try {
            if (JOMLConversion.available()) {
                JOMLConversion.init();
                Conversion.registerConverters(JOMLConversion.class);
            }
        }
        catch (Throwable t) {
            Logging.LOGGER_REFLECTION.log(Level.SEVERE, "Failed to register JOML converters", t);
        }
        SerializedEnumConversion.registerMinecraftEnumConversion();
        CommonUtil.getClass(Conversion.class.getName(), true);
        CommonUtil.getClass(PropertyConverter.class.getName(), true);
        CommonUtil.getClass(DuplexConversion.class.getName(), true);
    }

    public static void preloadCriticalComponents() {
        NBTBaseHandle.NBTTagByteArrayHandle.T.forceInitialization();
        NBTBaseHandle.NBTTagByteHandle.T.forceInitialization();
        NBTBaseHandle.NBTTagDoubleHandle.T.forceInitialization();
        NBTBaseHandle.NBTTagFloatHandle.T.forceInitialization();
        NBTBaseHandle.NBTTagIntArrayHandle.T.forceInitialization();
        NBTBaseHandle.NBTTagIntHandle.T.forceInitialization();
        if (CommonBootstrap.evaluateMCVersion(">=", "1.12")) {
            NBTBaseHandle.NBTTagLongArrayHandle.T.forceInitialization();
        }
        NBTBaseHandle.NBTTagLongHandle.T.forceInitialization();
        NBTBaseHandle.NBTTagShortHandle.T.forceInitialization();
        NBTBaseHandle.NBTTagStringHandle.T.forceInitialization();
        NBTTagCompoundHandle.T.forceInitialization();
        NBTTagListHandle.T.forceInitialization();
    }

    public static void preloadTemplateClasses(Random classLoaderOrderRandom) {
        List<String> classNames;
        block22: {
            if (Common.IS_TEST_MODE) {
                String bkclClassesDir = System.getProperty("main.classes.dir");
                if (bkclClassesDir == null || bkclClassesDir.isEmpty()) {
                    throw new IllegalStateException("Run under test without main.classes.dir set (gradle error?)");
                }
                Path bkclClassesPath = new File(bkclClassesDir).toPath();
                try (Stream<Path> bkclClassFiles = Files.walk(bkclClassesPath, new FileVisitOption[0]);){
                    classNames = bkclClassFiles.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(bkclClassesPath::relativize).map(Path::toString).collect(Collectors.toCollection(ArrayList::new));
                    break block22;
                }
                catch (IOException ex) {
                    Logging.LOGGER.log(Level.WARNING, "Failed to pre-load template classes: listing failed", ex);
                    return;
                }
            }
            classNames = new ArrayList();
            URLClassLoader loader = (URLClassLoader)CommonClasses.class.getClassLoader();
            File jarFile = null;
            for (URL url : loader.getURLs()) {
                jarFile = new File(url.getFile());
                if (jarFile.exists()) continue;
                jarFile = null;
            }
            if (jarFile == null) {
                Logging.LOGGER.log(Level.WARNING, "Failed to figure out the jar file of BKCommonLib. No template classes pre-loaded.");
                return;
            }
            try (ZipInputStream zip = new ZipInputStream(new FileInputStream(jarFile));){
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        classNames.add(entry.getName());
                    }
                    entry = zip.getNextEntry();
                }
            }
            catch (IOException ex) {
                Logging.LOGGER.log(Level.WARNING, "Failed to pre-load template classes: listing failed", ex);
                return;
            }
        }
        if (classLoaderOrderRandom != null) {
            Collections.shuffle(classNames, classLoaderOrderRandom);
        }
        classNames.parallelStream().map(className -> {
            if (className.startsWith("/")) {
                className = className.substring(1);
            }
            return className;
        }).filter(name -> name.startsWith("com/bergerkiller/generated") && name.endsWith(".class")).filter(name -> !name.equals("com/bergerkiller/generated/net/minecraft/network/protocol/game/PacketPlayOutCustomPayloadHandle.class")).map(name -> name.substring(0, name.length() - 6).replace('/', '.')).map(className -> {
            try {
                Class<?> templateClass = Class.forName(className, true, CommonClasses.class.getClassLoader());
                if (Template.Handle.class.isAssignableFrom(templateClass)) {
                    Field templateClassInstanceField = templateClass.getDeclaredField("T");
                    Template.Class cls = (Template.Class)templateClassInstanceField.get(null);
                    return cls;
                }
            }
            catch (Throwable t) {
                Logging.LOGGER.log(Level.SEVERE, "Failed to load class " + className, t);
                return null;
            }
            return null;
        }).filter(Objects::nonNull).forEach(cls -> {
            try {
                cls.forceInitialization();
            }
            catch (Throwable t) {
                Logging.LOGGER.log(Level.SEVERE, "Failed to initialize " + cls.getHandleType(), t);
            }
        });
    }

    public static boolean isHeadlessJDK() {
        try {
            Class.forName("java.awt.Color");
            return false;
        }
        catch (ClassNotFoundException ex) {
            return true;
        }
    }

    static {
        _isCompatible = false;
        _incompatibleReason = null;
    }
}

