/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.internal;

import com.bergerkiller.bukkit.common.Common;
import com.bergerkiller.bukkit.common.conversion.Conversion;
import com.bergerkiller.bukkit.common.conversion.type.HandleConversion;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.generated.net.minecraft.server.dedicated.DedicatedPlayerListHandle;
import com.bergerkiller.generated.net.minecraft.server.level.EntityPlayerHandle;
import com.bergerkiller.generated.net.minecraft.server.level.WorldServerHandle;
import com.bergerkiller.generated.net.minecraft.world.entity.EntityHandle;
import com.bergerkiller.generated.net.minecraft.world.entity.EntityLivingHandle;
import com.bergerkiller.generated.net.minecraft.world.entity.item.EntityItemHandle;
import com.bergerkiller.generated.net.minecraft.world.entity.player.EntityHumanHandle;
import com.bergerkiller.generated.net.minecraft.world.item.ItemHandle;
import com.bergerkiller.generated.net.minecraft.world.item.ItemStackHandle;
import com.bergerkiller.generated.net.minecraft.world.level.chunk.ChunkHandle;
import com.bergerkiller.generated.org.bukkit.craftbukkit.CraftServerHandle;
import com.bergerkiller.mountiplex.reflection.declarations.Template;
import java.util.Optional;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommonNMS {
    private static Class<?> JAVA_UTIL_OPTIONAL_TYPE = CommonUtil.getClass("java.util.Optional");
    private static Class<?> GOOGLE_OPTIONAL_TYPE = CommonUtil.getClass("com.google.common.base.Optional");
    public static Class<?> DWR_OPTIONAL_TYPE = Common.evaluateMCVersion(">=", "1.13") ? JAVA_UTIL_OPTIONAL_TYPE : GOOGLE_OPTIONAL_TYPE;

    public static boolean isDWROptionalType(Class<?> type) {
        return type != null && type.equals(DWR_OPTIONAL_TYPE);
    }

    public static Object unwrapDWROptional(Object value) {
        if (DWR_OPTIONAL_TYPE != null) {
            if (DWR_OPTIONAL_TYPE == GOOGLE_OPTIONAL_TYPE) {
                if (value instanceof com.google.common.base.Optional) {
                    com.google.common.base.Optional opt = (com.google.common.base.Optional)value;
                    return opt.isPresent() ? opt.get() : null;
                }
            } else if (DWR_OPTIONAL_TYPE == JAVA_UTIL_OPTIONAL_TYPE && value instanceof Optional) {
                Optional opt = (Optional)value;
                return opt.isPresent() ? opt.get() : null;
            }
        }
        return value;
    }

    public static Object wrapDWROptional(Object value) {
        if (!(DWR_OPTIONAL_TYPE == null || value != null && DWR_OPTIONAL_TYPE.isAssignableFrom(value.getClass()))) {
            value = DWR_OPTIONAL_TYPE.equals(JAVA_UTIL_OPTIONAL_TYPE) ? Optional.ofNullable(value) : com.google.common.base.Optional.fromNullable((Object)value);
        }
        return value;
    }

    public static boolean isItemEmpty(Object rawItemStackHandle) {
        if (rawItemStackHandle == null) {
            return true;
        }
        if (ItemStackHandle.T.isEmpty.isAvailable()) {
            return ItemStackHandle.T.isEmpty.invoke(rawItemStackHandle);
        }
        return false;
    }

    public static ChunkHandle getHandle(Chunk chunk) {
        return ChunkHandle.createHandle(HandleConversion.toChunkHandle(chunk));
    }

    public static ItemStackHandle getHandle(ItemStack stack) {
        return ItemStackHandle.createHandle(Conversion.toItemStackHandle.convert(stack));
    }

    public static EntityHandle getHandle(Entity entity) {
        return CommonNMS.getHandle(entity, EntityHandle.T);
    }

    public static EntityItemHandle getHandle(Item item) {
        return CommonNMS.getHandle((Entity)item, EntityItemHandle.T);
    }

    public static EntityLivingHandle getHandle(LivingEntity l) {
        return CommonNMS.getHandle((Entity)l, EntityLivingHandle.T);
    }

    public static EntityHumanHandle getHandle(HumanEntity h) {
        return CommonNMS.getHandle((Entity)h, EntityHumanHandle.T);
    }

    public static EntityPlayerHandle getHandle(Player p) {
        return CommonNMS.getHandle((Entity)p, EntityPlayerHandle.T);
    }

    public static Object getRawHandle(Entity e, Template.Class<?> type) {
        return LogicUtil.tryCast(HandleConversion.toEntityHandle(e), type.getType());
    }

    public static <T extends Template.Handle> T getHandle(Entity e, Template.Class<T> type) {
        Object rawInstance = HandleConversion.toEntityHandle(e);
        if (type.isAssignableFrom(rawInstance)) {
            return type.createHandle(rawInstance);
        }
        return null;
    }

    public static WorldServerHandle getHandle(World world) {
        return WorldServerHandle.createHandle(HandleConversion.toWorldHandle(world));
    }

    public static ItemHandle getItem(Material material) {
        return material == null ? null : ItemHandle.createHandle(HandleConversion.toItemHandle(material));
    }

    public static DedicatedPlayerListHandle getPlayerList() {
        return CraftServerHandle.instance().getPlayerList();
    }
}

