/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.internal.cdn;

import com.bergerkiller.bukkit.common.Logging;
import com.bergerkiller.bukkit.common.internal.cdn.MojangIO;
import com.bergerkiller.bukkit.common.internal.cdn.MojangMappings;
import com.bergerkiller.bukkit.common.io.VersionedMappingsFileIO;
import com.bergerkiller.bukkit.common.server.CraftBukkitServer;
import com.bergerkiller.mountiplex.logic.TextValueSequence;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpigotMappings
extends VersionedMappingsFileIO<ClassMappings> {
    public SpigotMappings() {
        super(TextValueSequence.STRING_COMPARATOR, x$0 -> new ClassMappings((VersionedMappingsFileIO.MappedVersion)x$0));
    }

    public boolean assertMappings(String ... versions) throws IOException {
        boolean changed = false;
        for (String version : versions) {
            if (this.byVersion.containsKey(version)) continue;
            this.downloadMappings(null, version);
            changed = true;
        }
        return changed;
    }

    public void downloadMappings(MojangMappings mojangMappings, String version) throws IOException {
        if (mojangMappings == null) {
            mojangMappings = MojangMappings.fromCacheOrDownload(version);
        }
        SpigotVersionMeta versionMeta = MojangIO.downloadJson(SpigotVersionMeta.class, "https://hub.spigotmc.org/versions/" + version + ".json");
        if (versionMeta.refs == null || versionMeta.refs.BuildData == null) {
            throw new IOException("No BuildData ref in response to /versions");
        }
        File mappingsFile = File.createTempFile("bukkit-" + version + "-cl", ".csrg");
        MojangIO.VersionManifest.VersionAssets.Download download = new MojangIO.VersionManifest.VersionAssets.Download();
        download.sha1 = null;
        download.size = 0L;
        download.url = "https://hub.spigotmc.org/stash/projects/SPIGOT/repos/builddata/raw/mappings/bukkit-" + version + "-cl.csrg?at=" + versionMeta.refs.BuildData;
        MojangIO.downloadFile("Minecraft - Bukkit " + version + " class mappings", download, mappingsFile);
        Pattern classNamePattern = Pattern.compile("([\\w\\._\\-/$]+)\\s+([\\w\\._\\-/$]+)");
        HashMap<String, String> obfuscatedToBukkit = new HashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new FileReader(mappingsFile));){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher m = classNamePattern.matcher(line);
                if (!m.matches()) continue;
                String obfuscatedName = m.group(1).replace('/', '.');
                String bukkitFullName = m.group(2).replace('/', '.');
                obfuscatedToBukkit.put(obfuscatedName, bukkitFullName);
            }
        }
        HashMap<String, String> newMappings = new HashMap<String, String>();
        for (MojangMappings.ClassMappings cl : mojangMappings.classes()) {
            String bukkitFullName = (String)obfuscatedToBukkit.get(cl.name_obfuscated);
            if (bukkitFullName == null) {
                int subClassIndex = cl.name_obfuscated.length();
                while ((subClassIndex = cl.name_obfuscated.lastIndexOf(36, subClassIndex - 1)) != -1) {
                    bukkitFullName = (String)obfuscatedToBukkit.get(cl.name_obfuscated.substring(0, subClassIndex));
                    if (bukkitFullName == null) continue;
                    bukkitFullName = bukkitFullName + cl.name_obfuscated.substring(subClassIndex);
                    break;
                }
            }
            if (bukkitFullName == null) continue;
            newMappings.put(bukkitFullName, cl.name);
        }
        this.store(version, newMappings);
        mappingsFile.delete();
    }

    public static ClassMappings fromCacheOrDownload(String minecraftVersion) {
        SpigotMappings spigotMappings = new SpigotMappings();
        String classMappingsFile = "/com/bergerkiller/bukkit/common/internal/resources/class_mappings.dat";
        try (InputStream in = CraftBukkitServer.class.getResourceAsStream(classMappingsFile);){
            spigotMappings.read(in);
        }
        catch (IOException ex) {
            Logging.LOGGER.log(Level.SEVERE, "Failed to read class mappings (corrupted jar?)", ex);
        }
        if (!spigotMappings.byVersion.containsKey(minecraftVersion)) {
            Logging.LOGGER.log(Level.WARNING, "[Developer] Class mappings file has no mappings for this Minecraft version. Build problem?");
            try {
                spigotMappings.downloadMappings(MojangMappings.fromCacheOrDownload(minecraftVersion), minecraftVersion);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to download Spigot-Mojang class name mappings");
            }
        }
        return (ClassMappings)spigotMappings.get(minecraftVersion).orElseThrow(() -> new IllegalStateException("Version has no mappings"));
    }

    private static class SpigotVersionMeta {
        public Refs refs;

        private SpigotVersionMeta() {
        }

        private static class Refs {
            public String BuildData;

            private Refs() {
            }
        }
    }

    public static class ClassMappings {
        private final BiMap<String, String> mojangToSpigot;
        private final BiMap<String, String> spigotToMojang;

        private ClassMappings(VersionedMappingsFileIO.MappedVersion<ClassMappings> mappedVersion) {
            this(mappedVersion.mappings);
        }

        public ClassMappings(Map<String, String> spigotToMojang) {
            this.spigotToMojang = HashBiMap.create(spigotToMojang);
            this.mojangToSpigot = this.spigotToMojang.inverse();
        }

        public void put(String spigotClassName, String mojangClassName) {
            this.spigotToMojang.put((Object)spigotClassName, (Object)mojangClassName);
        }

        public void remapSubClass(String spigotClassName, String subClassName) {
            this.put(spigotClassName + "$" + subClassName, this.toMojang(spigotClassName) + "$" + subClassName);
        }

        public String toMojang(String spigotClassName) {
            return (String)this.spigotToMojang.getOrDefault((Object)spigotClassName, (Object)spigotClassName);
        }

        public String toSpigot(String mojangClassName) {
            return (String)this.mojangToSpigot.getOrDefault((Object)mojangClassName, (Object)mojangClassName);
        }
    }
}

