/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.internal.logic;

import com.bergerkiller.bukkit.common.internal.CommonBootstrap;
import com.bergerkiller.bukkit.common.internal.logic.BlockDataWrapperHook;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.wrappers.BlockData;
import com.bergerkiller.generated.net.minecraft.world.level.block.state.IBlockDataHandle;
import com.bergerkiller.mountiplex.dep.org.objectweb.asm.FieldVisitor;
import com.bergerkiller.mountiplex.dep.org.objectweb.asm.MethodVisitor;
import com.bergerkiller.mountiplex.reflection.ReflectionUtil;
import com.bergerkiller.mountiplex.reflection.SafeField;
import com.bergerkiller.mountiplex.reflection.declarations.Template;
import com.bergerkiller.mountiplex.reflection.resolver.Resolver;
import com.bergerkiller.mountiplex.reflection.util.ExtendedClassWriter;
import com.bergerkiller.mountiplex.reflection.util.FastField;
import com.bergerkiller.mountiplex.reflection.util.FastMethod;
import com.bergerkiller.mountiplex.reflection.util.NullInstantiator;
import com.bergerkiller.mountiplex.reflection.util.asm.MPLType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class BlockDataWrapperHook_Impl_Default
extends BlockDataWrapperHook {
    private final FastMethod<Object> getValues = new FastMethod();
    private final FastField<Object> values = new FastField();
    private NullInstantiator<Object> hookBuilder = null;
    private final FastField<Object> hookBaseField = new FastField();
    private final FastField<BlockData> hookBlockDataField = new FastField();

    BlockDataWrapperHook_Impl_Default() {
    }

    @Override
    protected void baseEnable() throws Throwable {
        Field valuesField;
        Class<?> iBlockDataHolderType;
        Class<?> immutableMapType;
        if (CommonBootstrap.evaluateMCVersion(">=", "1.20.5")) {
            immutableMapType = this.getClassVerify("it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap");
            iBlockDataHolderType = this.getClassVerify("net.minecraft.world.level.block.state.IBlockDataHolder");
            valuesField = Resolver.resolveAndGetDeclaredField(iBlockDataHolderType, "values");
        } else {
            immutableMapType = this.getClassVerify("com.google.common.collect.ImmutableMap");
            if (CommonBootstrap.evaluateMCVersion(">=", "1.16")) {
                iBlockDataHolderType = this.getClassVerify("net.minecraft.world.level.block.state.IBlockDataHolder");
                valuesField = CommonBootstrap.evaluateMCVersion(">=", "1.18") ? Resolver.resolveAndGetDeclaredField(iBlockDataHolderType, "values") : (CommonBootstrap.evaluateMCVersion(">=", "1.17") ? Resolver.resolveAndGetDeclaredField(iBlockDataHolderType, "values") : Resolver.resolveAndGetDeclaredField(iBlockDataHolderType, "b"));
            } else if (CommonBootstrap.evaluateMCVersion(">=", "1.13")) {
                Class<?> blockDataAbstractType = CommonUtil.getClass("net.minecraft.world.level.block.state.BlockDataAbstract");
                valuesField = CommonBootstrap.evaluateMCVersion(">=", "1.14") ? Resolver.resolveAndGetDeclaredField(blockDataAbstractType, "d") : Resolver.resolveAndGetDeclaredField(blockDataAbstractType, "c");
            } else {
                Class<?> blockDataType = CommonUtil.getClass("net.minecraft.world.level.block.state.BlockStateList$BlockData");
                valuesField = SafeField.contains(blockDataType, "bAsImmutableMap", immutableMapType) ? blockDataType.getDeclaredField("bAsImmutableMap") : Resolver.resolveAndGetDeclaredField(blockDataType, "b");
            }
        }
        if (valuesField.getType() != immutableMapType) {
            throw new UnsupportedOperationException("Values field is of type " + valuesField.getType() + ", expected " + immutableMapType);
        }
        this.values.init(valuesField);
        this.values.forceInitialization();
        Method getValuesMethod = ((Template.Method)IBlockDataHandle.T.getStates.raw).toJavaMethod();
        this.getValues.init(getValuesMethod);
        this.getValues.forceInitialization();
        ExtendedClassWriter cw = ExtendedClassWriter.builder(immutableMapType).addInterface(BlockDataWrapperHook.Accessor.class).setFlags(1).setClassLoader(BlockDataWrapperHook_Impl_Default.class.getClassLoader()).build();
        String blockDataDesc = MPLType.getDescriptor(BlockData.class);
        String immutableMapDesc = MPLType.getDescriptor(immutableMapType);
        FieldVisitor fv = cw.visitField(18, "base", immutableMapDesc, null, null);
        fv.visitEnd();
        fv = cw.visitField(18, "blockData", blockDataDesc, null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "bkcGetOriginalValue", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, cw.getInternalName(), "base", immutableMapDesc);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "bkcGetBlockData", "()" + blockDataDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, cw.getInternalName(), "blockData", blockDataDesc);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        ReflectionUtil.getAllMethods(immutableMapType).filter(m -> {
            if (m.getName().equals("finalize") && m.getParameterCount() == 0) {
                return false;
            }
            if (m.getName().equals("clone") && m.getParameterCount() == 0) {
                return false;
            }
            int modifiers = m.getModifiers();
            return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isPrivate(modifiers);
        }).forEachOrdered(m -> {
            MethodVisitor mv = cw.visitMethod(1, MPLType.getName(m), MPLType.getMethodDescriptor(m), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, cw.getInternalName(), "base", immutableMapDesc);
            int registerInitial = 1;
            for (Class<?> param : m.getParameterTypes()) {
                registerInitial = MPLType.visitVarILoad(mv, registerInitial, param);
            }
            ExtendedClassWriter.visitInvoke(mv, immutableMapType, m);
            mv.visitInsn(MPLType.getReturnType(m).getOpcode(172));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        });
        Class type = cw.generate();
        this.hookBuilder = NullInstantiator.of(type);
        this.hookBaseField.init(type.getDeclaredField("base"));
        this.hookBlockDataField.init(type.getDeclaredField("blockData"));
    }

    private Class<?> getClassVerify(String name) {
        Class<?> type = CommonUtil.getClass(name);
        if (type == null) {
            throw new UnsupportedOperationException("Class not found: " + name);
        }
        return type;
    }

    @Override
    public Object getAccessor(Object nmsIBlockData) {
        return this.getValues.invoke(nmsIBlockData);
    }

    @Override
    protected void setAccessor(Object nmsIBlockdata, Object accessor) {
        this.values.set(nmsIBlockdata, accessor);
    }

    @Override
    protected Object hook(Object accessor, BlockData blockData) {
        Object hook = this.hookBuilder.create();
        this.hookBaseField.set(hook, accessor);
        this.hookBlockDataField.set(hook, blockData);
        return hook;
    }
}

