/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.map;

import com.bergerkiller.bukkit.common.Common;
import com.bergerkiller.bukkit.common.Logging;
import com.bergerkiller.bukkit.common.bases.DeferredSupplier;
import com.bergerkiller.bukkit.common.config.ConfigurationNode;
import com.bergerkiller.bukkit.common.internal.CommonBootstrap;
import com.bergerkiller.bukkit.common.internal.CommonCapabilities;
import com.bergerkiller.bukkit.common.internal.blocks.BlockRenderProvider;
import com.bergerkiller.bukkit.common.internal.resources.ResourceOverrides;
import com.bergerkiller.bukkit.common.internal.resources.builtin.GeneratedModel;
import com.bergerkiller.bukkit.common.inventory.CommonItemStack;
import com.bergerkiller.bukkit.common.map.MapTexture;
import com.bergerkiller.bukkit.common.map.archive.MapResourcePackArchive;
import com.bergerkiller.bukkit.common.map.archive.MapResourcePackAutoArchive;
import com.bergerkiller.bukkit.common.map.archive.MapResourcePackClientArchive;
import com.bergerkiller.bukkit.common.map.gson.MapResourcePackDeserializer;
import com.bergerkiller.bukkit.common.map.gson.types.ResourcePackDescription;
import com.bergerkiller.bukkit.common.map.util.BlockModelState;
import com.bergerkiller.bukkit.common.map.util.ItemModel;
import com.bergerkiller.bukkit.common.map.util.Model;
import com.bergerkiller.bukkit.common.map.util.ModelInfo;
import com.bergerkiller.bukkit.common.map.util.ModelInfoLookup;
import com.bergerkiller.bukkit.common.map.util.VanillaResourcePack;
import com.bergerkiller.bukkit.common.map.util.VanillaResourcePackFormat;
import com.bergerkiller.bukkit.common.math.Matrix4x4;
import com.bergerkiller.bukkit.common.math.Vector3;
import com.bergerkiller.bukkit.common.utils.DebugUtil;
import com.bergerkiller.bukkit.common.utils.WorldUtil;
import com.bergerkiller.bukkit.common.wrappers.BlockData;
import com.bergerkiller.bukkit.common.wrappers.BlockRenderOptions;
import com.bergerkiller.bukkit.common.wrappers.ItemRenderOptions;
import com.bergerkiller.bukkit.common.wrappers.RenderOptions;
import com.bergerkiller.generated.net.minecraft.server.MinecraftServerHandle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.yaml.snakeyaml.error.YAMLException;

public class MapResourcePack {
    public static final VanillaResourcePack VANILLA = new VanillaResourcePack();
    public static final MapResourcePack SERVER = new MapResourcePack("server");
    private final MapResourcePack baseResourcePack;
    protected MapResourcePackArchive archive;
    protected Metadata metadata = null;
    private final Map<String, MapTexture> textureCache = new HashMap<String, MapTexture>();
    private final Map<String, ConfigurationNode> yamlCache = new HashMap<String, ConfigurationNode>();
    private final Map<String, ItemModel> itemModelCache = new HashMap<String, ItemModel>();
    private final Map<String, Model> modelCache = new HashMap<String, Model>();
    private final Map<BlockRenderOptions, Model> blockModelCache = new HashMap<BlockRenderOptions, Model>();
    private BlockRenderProvider currProvider = null;
    private MapResourcePackDeserializer deserializer = null;
    private boolean loaded = false;

    public MapResourcePack(String resourcePackPath) {
        this(VANILLA, resourcePackPath, "");
    }

    public MapResourcePack(String resourcePackPath, String resourcePackHash) {
        this(VANILLA, resourcePackPath, resourcePackHash);
    }

    public MapResourcePack(MapResourcePack baseResourcePack, String resourcePackPath) {
        this(baseResourcePack, resourcePackPath, "");
    }

    public MapResourcePack(MapResourcePack baseResourcePack, String resourcePackPath, String resourcePackHash) {
        this.baseResourcePack = baseResourcePack;
        this.archive = null;
        if (resourcePackPath != null && resourcePackPath.equalsIgnoreCase("server")) {
            if (CommonBootstrap.isTestMode()) {
                resourcePackPath = "vanilla";
            } else {
                MinecraftServerHandle mcs = MinecraftServerHandle.instance();
                resourcePackPath = mcs.getResourcePack();
                resourcePackHash = mcs.getResourcePackHash();
            }
        }
        if (resourcePackPath == null || resourcePackPath.isEmpty() || resourcePackPath.equalsIgnoreCase("vanilla") || resourcePackPath.equalsIgnoreCase("default")) {
            this.archive = this.baseResourcePack == null ? new MapResourcePackClientArchive() : null;
            return;
        }
        this.archive = new MapResourcePackAutoArchive(resourcePackPath, resourcePackHash);
    }

    protected MapResourcePack() {
        this.baseResourcePack = null;
        this.archive = null;
    }

    public Metadata getMetadata() {
        this.handleLoad(true, false);
        return this.metadata;
    }

    public MapResourcePack getBase() {
        return this.baseResourcePack;
    }

    public void load() {
        this.handleLoad(false, false);
    }

    protected void handleLoad(boolean lazy, boolean recurse) {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        this.metadata = Metadata.fallback("Failed to load resource pack");
        if (lazy && !recurse) {
            Logging.LOGGER_MAPDISPLAY.warning("[Developer] You must call MapResourcePack.load() when enabling your plugin!");
            Logging.LOGGER_MAPDISPLAY.warning("[Developer] This avoids stalling the server while downloading large resource packs/Minecraft client.");
            Logging.LOGGER_MAPDISPLAY.warning("[Developer] Potential plugins that caused this: " + DebugUtil.getPluginCauses());
        }
        if (this.archive != null) {
            this.archive.load(lazy);
            if (this.deserializer == null) {
                this.deserializer = MapResourcePackDeserializer.create();
            }
            this.metadata = this.archive.tryLoadMetadata(this.deserializer);
        }
        if (this.baseResourcePack != null) {
            this.baseResourcePack.handleLoad(lazy, true);
        }
    }

    public void clearCache() {
        this.textureCache.clear();
        this.modelCache.clear();
        this.blockModelCache.clear();
    }

    public final Model getBlockModel(Block block) {
        return this.getBlockModel(WorldUtil.getBlockData(block).getRenderOptions(block));
    }

    public final Model getBlockModel(World world, int x, int y, int z) {
        return this.getBlockModel(WorldUtil.getBlockData(world, x, y, z).getRenderOptions(world, x, y, z));
    }

    public final Model getBlockModel(Material blockMaterial) {
        return this.getBlockModel(BlockData.fromMaterial(blockMaterial));
    }

    public final Model getBlockModel(Material blockMaterial, int data) {
        return this.getBlockModel(BlockData.fromMaterialData(blockMaterial, data));
    }

    public Model getBlockModel(BlockData blockData) {
        return this.getBlockModel(blockData.getDefaultRenderOptions());
    }

    public Model getBlockModel(BlockRenderOptions blockRenderOptions) {
        Model model = this.blockModelCache.get(blockRenderOptions);
        if (model == null) {
            if (blockRenderOptions.getBlockData() != null) {
                model = this.loadBlockModel(blockRenderOptions);
            }
            if (model == null) {
                model = Model.createPlaceholderModel(blockRenderOptions);
            }
            this.blockModelCache.put(blockRenderOptions, model);
        }
        return model;
    }

    public ModelInfo getModelInfo(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Input path is null");
        }
        Model model = this.modelCache.get(path);
        if (model != null) {
            return model;
        }
        ModelInfo info = this.openGsonObject(ModelInfo.class, ResourceType.MODELS, path);
        if (info != null) {
            info.setName(path);
            return info;
        }
        return ModelInfo.createPlaceholder(path);
    }

    public ItemModel getItemModelConfig(ItemStack itemStack) {
        return this.getItemModelConfig(CommonItemStack.of(itemStack));
    }

    public ItemModel getItemModelConfig(CommonItemStack itemStack) {
        return this.getItemModelConfig(ModelInfoLookup.lookupItem(itemStack));
    }

    public ItemModel getItemModelConfig(String itemName) {
        ItemModel.Root root;
        ItemModel cached = this.itemModelCache.get(itemName);
        if (cached != null) {
            return cached;
        }
        CommonItemStack baseItemStack = ModelInfoLookup.findItemStackByModelName(itemName).orElse(null);
        if (this.getMetadata().hasItemOverrides()) {
            root = this.openGsonObject(ItemModel.Root.class, ResourceType.ITEMS, itemName);
        } else {
            ItemModel.MinecraftModel vanillaModel = ItemModel.MinecraftModel.of("item/" + itemName);
            ItemModel.Overrides overrides = this.openGsonObject(ItemModel.Overrides.class, ResourceType.MODELS, vanillaModel.model);
            if (overrides != null) {
                overrides.fallback = vanillaModel;
                if (baseItemStack != null) {
                    for (ItemModel.Overrides.OverriddenModel override : overrides.overrides) {
                        override.itemStack = override.tryMakeMatching(baseItemStack).orElse(null);
                    }
                }
                root = new ItemModel.Root();
                root.model = overrides;
            } else {
                root = null;
            }
        }
        if (root == null) {
            root = new ItemModel.Root();
            root.model = ItemModel.MinecraftModel.NOT_SET;
        }
        root.baseItemStack = baseItemStack;
        this.itemModelCache.put(itemName, root);
        return root;
    }

    public Set<String> listOverriddenItemModelNames() {
        LinkedHashSet allOverridenModels = new LinkedHashSet();
        for (MapResourcePack p = this; p != null && p != VANILLA; p = p.getBase()) {
            for (String namespace : p.listNamespaces(false)) {
                SearchOptions searchOptions = SearchOptions.create().setResourceType(ResourceType.ITEMS).setNamespace(namespace).setIncludingParentPacks(false).setDeep(true).setPrependNamespace(!namespace.equals("minecraft"));
                p.forAllResources(searchOptions, allOverridenModels::add);
            }
        }
        return Collections.unmodifiableSet(allOverridenModels);
    }

    public Model getModel(String path) {
        Model model = this.modelCache.get(path);
        if (model != null) {
            return model;
        }
        model = this.loadModel(path);
        if (model == null) {
            model = Model.createPlaceholderModel(BlockData.AIR.getDefaultRenderOptions());
            model.setName(path);
        }
        this.modelCache.put(path, model);
        return model;
    }

    public Model getItemModel(ItemStack item) {
        return this.getItemModel(CommonItemStack.of(item));
    }

    public Model getItemModel(CommonItemStack item) {
        ItemRenderOptions options;
        Model m;
        ItemModel itemModel = this.getItemModelConfig(item);
        List<ItemModel.MinecraftModel> models = itemModel.resolveModels(item);
        if (models.isEmpty()) {
            models = ItemModel.MinecraftModel.NOT_SET_LIST;
        }
        if ((m = this.loadModel(models.get((int)0).model, options = ModelInfoLookup.lookupItemRenderOptions(item))) != null) {
            m.buildBlock(options);
            m.buildQuads();
        }
        if (m == null) {
            m = Model.createPlaceholderModel(options);
        }
        return m;
    }

    public MapTexture getItemTexture(ItemStack item, int width, int height) {
        return this.getItemTexture(CommonItemStack.of(item), width, height);
    }

    public MapTexture getItemTexture(CommonItemStack item, int width, int height) {
        Model.Display display;
        Model model = this.getItemModel(item);
        if (model == null || model.isPlaceholder()) {
            return Model.createPlaceholderTexture(width, height);
        }
        MapTexture texture = MapTexture.createEmpty(width, height);
        Matrix4x4 transform = new Matrix4x4();
        if (width != 16 || height != 16) {
            transform.scale((double)width / 16.0, 1.0, (double)height / 16.0);
        }
        if ((display = model.display.get("gui")) != null) {
            display.apply(transform);
            texture.setLightOptions(0.0f, 1.0f, new Vector3(-1.0, 1.0, -1.0));
        }
        texture.drawModel(model, transform);
        return texture;
    }

    public Set<String> listResources(ResourceType type, String folder) {
        return this.listResources(type, folder, true);
    }

    public Set<String> listResources(ResourceType type, String folder, boolean includingParentPacks) {
        return this.listResources(type, "minecraft", folder, includingParentPacks);
    }

    public Set<String> listResources(ResourceType type, String namespace, String folder) {
        return this.listResources(type, namespace, folder, true);
    }

    public Set<String> listResources(ResourceType type, String namespace, String folder, boolean includingParentPacks) {
        return this.listResources(SearchOptions.create().setResourceType(type).setNamespace(namespace).setFolder(folder).setIncludingParentPacks(includingParentPacks));
    }

    public Set<String> listResources(SearchOptions searchOptions) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.forAllResources(searchOptions, result::add);
        return result;
    }

    public void forAllResources(SearchOptions searchOptions, Consumer<String> callback) {
        if (searchOptions.getResourceType() == null) {
            throw new IllegalArgumentException("Resource Type is not set");
        }
        String folder = searchOptions.getFolder();
        if (!folder.endsWith("/")) {
            folder = folder + "/";
        }
        if (searchOptions.getResourceType() == ResourceType.ITEMS && !this.getMetadata().hasItemOverrides()) {
            folder = folder.equals("/") ? "item" : (folder.startsWith("/") ? "item" + folder : "item/" + folder);
            this.forAllResources(searchOptions.clone().setResourceType(ResourceType.MODELS).setFolder(folder).setDeep(false).setPrependNamespace(false), path -> callback.accept(path.substring(5)));
            return;
        }
        this.forAllArchiveEntries(searchOptions.getResourceType(), searchOptions.getFullArchivePath(), false, searchOptions.isIncludingParentPacks(), searchOptions.isDeep(), path -> callback.accept(searchOptions.populatePathPrefix((String)path)));
    }

    public Set<String> listNamespaces() {
        return this.listNamespaces(true);
    }

    public Set<String> listNamespaces(boolean recurse) {
        HashSet<String> result = new HashSet<String>();
        this.forAllArchiveEntries(null, "assets/", true, recurse, false, result::add);
        return result;
    }

    public Set<String> listDirectories(ResourceType type, String folder) {
        return this.listDirectories(type, folder, true);
    }

    public Set<String> listDirectories(ResourceType type, String folder, boolean includingParentPacks) {
        return this.listDirectories(type, "minecraft", folder, includingParentPacks);
    }

    public Set<String> listDirectories(ResourceType type, String namespace, String folder) {
        return this.listDirectories(type, namespace, folder, true);
    }

    public Set<String> listDirectories(ResourceType type, String namespace, String folder, boolean includingParentPacks) {
        return this.listDirectories(SearchOptions.create().setResourceType(type).setNamespace(namespace).setFolder(folder).setIncludingParentPacks(includingParentPacks));
    }

    public Set<String> listDirectories(SearchOptions searchOptions) {
        if (searchOptions.getResourceType() == null) {
            throw new IllegalArgumentException("Resource Type is not set");
        }
        HashSet<String> result = new HashSet<String>();
        this.forAllArchiveEntries(searchOptions.getResourceType(), searchOptions.getFullArchivePath(), true, searchOptions.isIncludingParentPacks(), searchOptions.isDeep(), path -> result.add(searchOptions.populatePathPrefix((String)path)));
        return result;
    }

    public ConfigurationNode getConfig(String path) throws YAMLException {
        ConfigurationNode result = this.yamlCache.get(path);
        if (result == null) {
            result = new ConfigurationNode();
            try (InputStream inputStream = this.openFileStream(ResourceType.YAML, path);){
                if (inputStream != null) {
                    result.loadFromStream(inputStream);
                }
            }
            catch (YAMLException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw new YAMLException("Failed to open YAML file stream at " + path, (Throwable)ex);
            }
            this.yamlCache.put(path, result);
        }
        return result;
    }

    public MapTexture getTexture(String path) {
        MapTexture result = this.textureCache.get(path);
        if (result == null) {
            int num_frames;
            if (path.startsWith("#")) {
                result = Model.createPlaceholderTexture();
                this.textureCache.put(path, result);
                return result;
            }
            try (InputStream inputStream = this.openFileStream(ResourceType.TEXTURES, path);){
                if (inputStream != null) {
                    result = MapTexture.fromStream(inputStream);
                }
            }
            catch (IOException ex) {
                throw new MapTexture.TextureLoadException("Failed to open image stream at " + path, ex);
            }
            if (result == null) {
                Logging.LOGGER_MAPDISPLAY.once(Level.WARNING, "Failed to load texture: " + path);
                result = Model.createPlaceholderTexture();
            }
            if ((num_frames = result.getHeight() / result.getWidth()) > 1 && num_frames * result.getWidth() == result.getHeight()) {
                InputStream metaStream = this.openFileStream(ResourceType.TEXTURES_META, path);
                if (metaStream == null) {
                    Logging.LOGGER_MAPDISPLAY.once(Level.WARNING, "Failed to load animated texture (missing mcmeta): " + path);
                    result = Model.createPlaceholderTexture();
                } else {
                    result = result.getView(0, 0, result.getWidth(), result.getWidth()).clone();
                    try {
                        metaStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.textureCache.put(path, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Model loadBlockModel(BlockRenderOptions blockRenderOptions) {
        if (blockRenderOptions.getBlockData().isType(Material.AIR)) {
            return new Model();
        }
        BlockRenderProvider oldProvider = this.currProvider;
        try {
            Object object;
            Object variant;
            List<BlockModelState.Variant> variants;
            Model model;
            this.currProvider = BlockRenderProvider.get(blockRenderOptions.getBlockData());
            if (this.currProvider != null && (model = this.currProvider.createModel(this, blockRenderOptions)) != null) {
                Model model2 = model;
                return model2;
            }
            String blockName = blockRenderOptions.lookupModelName();
            BlockModelState state = this.openGsonObject(BlockModelState.class, ResourceType.BLOCKSTATES, blockName);
            if (state != null) {
                variants = state.findVariants(blockRenderOptions);
            } else {
                variant = new BlockModelState.Variant();
                ((BlockModelState.Variant)variant).modelName = "block/" + blockName;
                variants = Arrays.asList(variant);
            }
            if (variants.isEmpty()) {
                variant = new Model();
                return variant;
            }
            if (variants.size() == 1) {
                variant = this.loadBlockVariant((BlockModelState.Variant)variants.get(0), blockRenderOptions);
                return variant;
            }
            Model result = new Model();
            boolean succ = true;
            for (BlockModelState.Variant variant2 : variants) {
                Model subModel = this.loadBlockVariant(variant2, blockRenderOptions);
                if (subModel != null) {
                    result.elements.addAll(subModel.elements);
                    continue;
                }
                succ = false;
            }
            if (!succ && result.elements.isEmpty()) {
                object = null;
                return object;
            }
            object = result;
            return object;
        }
        finally {
            this.currProvider = oldProvider;
        }
    }

    private Model loadBlockVariant(BlockModelState.Variant variant, BlockRenderOptions blockRenderOptions) {
        Model model = this.loadModel(variant.modelName, blockRenderOptions);
        if (model == null) {
            return null;
        }
        model.buildBlock(blockRenderOptions);
        variant.update(model);
        model.buildQuads();
        return model;
    }

    protected final Model loadModel(String path) {
        return this.loadModel(path, BlockData.AIR.getDefaultRenderOptions());
    }

    protected final Model loadModel(String path, RenderOptions options) {
        if (path.equals("builtin/generated")) {
            return new GeneratedModel();
        }
        if (path.equals(ItemModel.MinecraftModel.NOT_SET.model)) {
            return Model.createPlaceholderModel(options);
        }
        Model model = this.openGsonObject(Model.class, ResourceType.MODELS, path);
        if (model == null) {
            Logging.LOGGER_MAPDISPLAY.once(Level.WARNING, "Failed to load model " + path);
            return null;
        }
        for (Model.ModelOverride override : model.getOverrides()) {
            if (!override.matches(options) || override.model.equals(path)) continue;
            return this.loadModel(override.model, options);
        }
        String parentModelName = model.getParentName();
        if (parentModelName == null && !CommonCapabilities.RESOURCE_PACK_MODEL_BASE_TRANSFORMS && !path.equals("block/block")) {
            parentModelName = "block/block";
        }
        if (parentModelName != null) {
            Model parentModel = this.loadModel(parentModelName, options);
            if (parentModel == null || parentModel.isPlaceholder()) {
                Logging.LOGGER_MAPDISPLAY.once(Level.WARNING, "Parent of model " + path + " not found: " + model.getParentName());
                return null;
            }
            model.loadParent(parentModel);
        }
        model.build(this, options);
        return model;
    }

    protected void forAllArchiveEntries(ResourceType type, String rootArchivePath, boolean directories, boolean recurse, boolean deep, Consumer<String> callback) {
        this.handleLoad(true, false);
        if (this.archive != null) {
            try {
                if (directories) {
                    for (String file : this.archive.listFiles(rootArchivePath, deep)) {
                        if (!file.endsWith("/")) continue;
                        callback.accept(file.substring(0, file.length() - 1));
                    }
                } else {
                    for (String file : this.archive.listFiles(rootArchivePath, deep)) {
                        if (!type.isExtension(file)) continue;
                        callback.accept(file.substring(0, file.length() - type.getExtension().length()));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (recurse && this.baseResourcePack != null) {
            this.baseResourcePack.forAllArchiveEntries(type, rootArchivePath, directories, recurse, false, callback);
        }
    }

    protected InputStream openFileStream(ResourceType type, String path) {
        InputStream bkc_stream;
        if (type == null) {
            throw new IllegalArgumentException("Input resource type is null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Input path is null");
        }
        String fullPath = type.makePath(path);
        if (!ResourceOverrides.isResourceOverrided(fullPath)) {
            InputStream stream2;
            this.handleLoad(true, false);
            if (this.archive != null) {
                try {
                    stream2 = this.archive.openFileStream(fullPath);
                    if (stream2 == null) {
                        stream2 = this.archive.openFileStream(fullPath.toLowerCase(Locale.ENGLISH));
                    }
                    if (stream2 != null) {
                        return stream2;
                    }
                }
                catch (IOException stream2) {
                    // empty catch block
                }
            }
            if (this.baseResourcePack != null && (stream2 = this.baseResourcePack.openFileStream(type, path)) != null) {
                return stream2;
            }
            if (this.currProvider != null) {
                try {
                    return this.currProvider.openResource(type, path);
                }
                catch (IOException stream3) {
                    // empty catch block
                }
            }
        }
        if ((bkc_stream = Common.class.getResourceAsStream(type.makeBKCPath(path))) != null) {
            return bkc_stream;
        }
        return null;
    }

    protected final <T> T openGsonObject(Class<T> objectType, ResourceType type, String path) {
        if (type == null) {
            throw new IllegalArgumentException("Input resource type is null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Input path is null");
        }
        return this.readGsonObject(objectType, this.openFileStream(type, path), path);
    }

    public final <T> T readGsonObject(Class<T> objectType, InputStream inputStream) {
        return this.readGsonObject(objectType, inputStream, null);
    }

    private <T> T readGsonObject(Class<T> objectType, InputStream inputStream, String optPath) {
        if (this.deserializer == null) {
            this.deserializer = MapResourcePackDeserializer.create();
        }
        return this.deserializer.readGsonObject(objectType, inputStream, optPath);
    }

    public static class Metadata {
        private int pack_format;
        private ResourcePackDescription description;
        private List<SupportedFormatRange> supported_formats = Collections.emptyList();
        private final transient DeferredSupplier<Boolean> hasItemOverrides = DeferredSupplier.of(() -> this.isPackRangeSupported(46, Integer.MAX_VALUE));

        public int getPackFormat() {
            return this.pack_format;
        }

        public String getDescription() {
            return this.hasDescription() ? this.description.plainContent : "No Description";
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.plainContent.isEmpty();
        }

        public boolean hasItemOverrides() {
            return this.hasItemOverrides.get();
        }

        public boolean isPackRangeSupported(int minPackFormat, int maxPackFormat) {
            if (this.pack_format >= minPackFormat && this.pack_format <= maxPackFormat) {
                return true;
            }
            if (this.supported_formats != null) {
                for (SupportedFormatRange range : this.supported_formats) {
                    if (!range.isPackRangeSupported(minPackFormat, maxPackFormat)) continue;
                    return true;
                }
            }
            return false;
        }

        public static Metadata fallback(String errorReason) {
            Metadata metadata = new Metadata();
            metadata.pack_format = VanillaResourcePackFormat.getLatestPackFormat();
            metadata.description = new ResourcePackDescription("Unknown Resource pack - " + errorReason);
            return metadata;
        }

        public static Metadata vanilla(String mcVersion) {
            Metadata metadata = new Metadata();
            metadata.pack_format = VanillaResourcePackFormat.getPackFormat(mcVersion);
            metadata.description = new ResourcePackDescription("Vanilla Minecraft " + mcVersion);
            return metadata;
        }

        public static class SupportedFormatRange {
            private final int min_inclusive;
            private final int max_inclusive;

            public static SupportedFormatRange of(int packFormatVersion) {
                return new SupportedFormatRange(packFormatVersion, packFormatVersion);
            }

            public static SupportedFormatRange of(int min_inclusive, int max_inclusive) {
                return new SupportedFormatRange(min_inclusive, max_inclusive);
            }

            private SupportedFormatRange(int min_inclusive, int max_inclusive) {
                this.min_inclusive = min_inclusive;
                this.max_inclusive = max_inclusive;
            }

            public boolean isPackRangeSupported(int minPackFormat, int maxPackFormat) {
                return minPackFormat <= this.max_inclusive && maxPackFormat >= this.min_inclusive;
            }

            public int min_inclusive() {
                return this.min_inclusive;
            }

            public int max_inclusive() {
                return this.max_inclusive;
            }
        }

        public static class PackWrapper {
            public Metadata pack;
        }
    }

    public static enum ResourceType {
        MODELS("/models/", ".json"),
        ITEMS("/items/", ".json"),
        BLOCKSTATES("/blockstates/", ".json"),
        TEXTURES("/textures/", ".png"),
        TEXTURES_META("/textures/", ".png.mcmeta"),
        YAML("/", ".yml");

        private final String root;
        private final String ext;

        private ResourceType(String root, String ext) {
            this.root = root;
            this.ext = ext;
        }

        public String getRoot(String namespace) {
            return "assets/" + namespace + this.root;
        }

        public String getExtension() {
            return this.ext;
        }

        public boolean isExtension(String filePath) {
            int extIdx = filePath.indexOf(46);
            return extIdx != -1 && filePath.substring(extIdx).equals(this.ext);
        }

        public String makePath(String path) {
            int namespaceIndex = path.indexOf(58);
            if (namespaceIndex != -1) {
                String namespace = path.substring(0, namespaceIndex);
                path = path.substring(namespaceIndex + 1);
                if (!namespace.isEmpty()) {
                    return "assets/" + namespace + this.root + path + this.ext;
                }
            }
            return "assets/minecraft" + this.root + path + this.ext;
        }

        public String makeBKCPath(String path) {
            return "/com/bergerkiller/bukkit/common/internal/resources/assets/minecraft" + this.root + ResourceType.stripNS(path) + this.ext;
        }

        private static String stripNS(String path) {
            int namespaceIndex = path.indexOf(58);
            return namespaceIndex == -1 ? path : path.substring(namespaceIndex + 1);
        }
    }

    public static class SearchOptions
    implements Cloneable {
        private ResourceType resourceType = null;
        private String namespace = "minecraft";
        private String folder = "/";
        private boolean includingParentPacks = false;
        private boolean deep = false;
        private boolean prependNamespace = false;

        public static SearchOptions create() {
            return new SearchOptions();
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }

        public SearchOptions setResourceType(ResourceType type) {
            this.resourceType = type;
            return this;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public SearchOptions setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public String getFolder() {
            return this.folder;
        }

        public SearchOptions setFolder(String folder) {
            if (!folder.endsWith("/")) {
                folder = folder + "/";
            }
            this.folder = folder;
            return this;
        }

        public boolean isIncludingParentPacks() {
            return this.includingParentPacks;
        }

        public SearchOptions setIncludingParentPacks(boolean includingParentPacks) {
            this.includingParentPacks = includingParentPacks;
            return this;
        }

        public boolean isDeep() {
            return this.deep;
        }

        public SearchOptions setDeep(boolean deep) {
            this.deep = deep;
            return this;
        }

        public boolean isPrependNamespace() {
            return this.prependNamespace;
        }

        public SearchOptions setPrependNamespace(boolean prepend) {
            this.prependNamespace = prepend;
            return this;
        }

        public boolean isRootPath() {
            return this.folder.equals("/");
        }

        public String getFullArchivePath() {
            if (this.isRootPath()) {
                return this.resourceType.getRoot(this.namespace);
            }
            return this.resourceType.getRoot(this.namespace) + this.folder;
        }

        public String populatePathPrefix(String path) {
            if (this.isRootPath()) {
                return this.isPrependNamespace() ? this.namespace + ":" + path : path;
            }
            return this.isPrependNamespace() ? this.namespace + ":" + this.folder + path : this.folder + path;
        }

        public SearchOptions clone() {
            return SearchOptions.create().setResourceType(this.getResourceType()).setNamespace(this.getNamespace()).setFolder(this.getFolder()).setIncludingParentPacks(this.isIncludingParentPacks()).setPrependNamespace(this.isPrependNamespace()).setDeep(this.isDeep());
        }
    }
}

