/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.map.archive;

import com.bergerkiller.bukkit.common.map.archive.MapResourcePackArchive;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MapResourcePackDirectoryArchive
implements MapResourcePackArchive {
    private final File directory;

    public MapResourcePackDirectoryArchive(File directory) {
        this.directory = directory;
    }

    @Override
    public String name() {
        return "Directory: " + this.directory.getName();
    }

    @Override
    public void load(boolean lazy) {
    }

    @Override
    public InputStream openFileStream(String path) throws IOException {
        File sub = new File(this.directory, path);
        if (sub.isFile()) {
            return new FileInputStream(sub);
        }
        return null;
    }

    @Override
    public List<String> listFiles(String folder, boolean deep) throws IOException {
        File sub = new File(this.directory, folder);
        if (!sub.exists() || !sub.isDirectory()) {
            return Collections.emptyList();
        }
        if (deep) {
            final Path rootPath = sub.toPath();
            final ArrayList<String> result = new ArrayList<String>();
            Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    result.add(rootPath.relativize(file).toString());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (!dir.equals(rootPath)) {
                        result.add(rootPath.relativize(dir) + "/");
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return result;
        }
        File[] files = sub.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(files.length);
        for (File file : files) {
            if (file.isDirectory()) {
                result.add(file.getName() + "/");
                continue;
            }
            result.add(file.getName());
        }
        return result;
    }
}

