/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.map.archive;

import com.bergerkiller.bukkit.common.Logging;
import com.bergerkiller.bukkit.common.map.archive.MapResourcePackArchive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class MapResourcePackZipArchive
implements MapResourcePackArchive {
    private ZipFile archive = null;
    private Map<String, List<String>> directories = null;
    private Map<String, List<String>> deepDirectories = null;
    private final File zipFile;

    public MapResourcePackZipArchive(File zipFile) {
        if (zipFile == null) {
            throw new IllegalArgumentException("Zip file cannot be null");
        }
        this.zipFile = zipFile;
    }

    @Override
    public String name() {
        return "ZIP: " + this.zipFile;
    }

    @Override
    public void load(boolean lazy) {
        boolean preferZip = this.zipFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip");
        IOException error = null;
        try {
            this.open(preferZip);
            return;
        }
        catch (IOException ex) {
            error = ex;
            this.archive = null;
            try {
                this.open(!preferZip);
                return;
            }
            catch (IOException iOException) {
                Logging.LOGGER.log(Level.SEVERE, "Failed to load resource pack " + this.zipFile.getAbsolutePath(), error);
                return;
            }
        }
    }

    private void open(boolean useZip) throws IOException {
        this.archive = useZip ? new ZipFile(this.zipFile) : new JarFile(this.zipFile);
    }

    @Override
    public InputStream openFileStream(String path) throws IOException {
        ZipEntry entry;
        if (this.archive != null && (entry = this.archive.getEntry(path)) != null) {
            return this.archive.getInputStream(entry);
        }
        return null;
    }

    @Override
    public List<String> listFiles(String folder, boolean deep) throws IOException {
        if (this.directories == null) {
            if (this.archive == null) {
                return Collections.emptyList();
            }
            this.directories = MapResourcePackZipArchive.readDirectories(this.archive.stream());
        }
        if (deep) {
            if (this.deepDirectories == null) {
                this.deepDirectories = MapResourcePackZipArchive.computeDeepDirectories(this.directories);
            }
            return this.deepDirectories.getOrDefault(folder, Collections.emptyList());
        }
        return this.directories.getOrDefault(folder, Collections.emptyList());
    }

    static Map<String, List<String>> readDirectories(Stream<? extends ZipEntry> entries) {
        try {
            HashMap<String, List<String>> dirs = new HashMap<String, List<String>>();
            entries.map(ZipEntry::getName).forEach(path -> {
                int startIdx = path.endsWith("/") ? path.length() - 2 : path.length() - 1;
                int parentEndIdx = path.lastIndexOf(47, startIdx);
                String parentPath = parentEndIdx == -1 ? "/" : path.substring(0, parentEndIdx + 1);
                String name = parentEndIdx == -1 ? path : path.substring(parentEndIdx + 1);
                dirs.computeIfAbsent(parentPath, un -> new ArrayList()).add(name);
            });
            dirs.values().forEach(Collections::sort);
            return dirs;
        }
        catch (Throwable t) {
            Logging.LOGGER.log(Level.SEVERE, "Failed to index resource pack archive", t);
            return Collections.emptyMap();
        }
    }

    static Map<String, List<String>> computeDeepDirectories(Map<String, List<String>> directories) {
        HashMap<String, List<String>> deep = new HashMap<String, List<String>>(directories.size());
        for (Map.Entry<String, List<String>> e : directories.entrySet()) {
            String key = e.getKey();
            List<String> files = e.getValue();
            deep.computeIfAbsent(key, k -> new ArrayList()).addAll(files);
            while (!key.equals("/")) {
                String prefix;
                int nextIndex = key.lastIndexOf(47, key.length() - 2);
                if (nextIndex != -1) {
                    prefix = key.substring(nextIndex + 1);
                    key = key.substring(0, nextIndex + 1);
                } else {
                    prefix = key;
                    key = "/";
                }
                files = new ArrayList<String>(files);
                for (int i = 0; i < files.size(); ++i) {
                    files.set(i, prefix + files.get(i));
                }
                deep.computeIfAbsent(key, k -> new ArrayList()).addAll(files);
            }
        }
        deep.values().forEach(Collections::sort);
        return deep;
    }
}

