/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.map.gson;

import com.bergerkiller.bukkit.common.dep.gson.JsonArray;
import com.bergerkiller.bukkit.common.dep.gson.JsonDeserializationContext;
import com.bergerkiller.bukkit.common.dep.gson.JsonDeserializer;
import com.bergerkiller.bukkit.common.dep.gson.JsonElement;
import com.bergerkiller.bukkit.common.dep.gson.JsonObject;
import com.bergerkiller.bukkit.common.dep.gson.JsonParseException;
import com.bergerkiller.bukkit.common.map.MapResourcePack;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class SupportedFormatRangeListDeserializer
implements JsonDeserializer<List<MapResourcePack.Metadata.SupportedFormatRange>> {
    SupportedFormatRangeListDeserializer() {
    }

    @Override
    public List<MapResourcePack.Metadata.SupportedFormatRange> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        List<JsonElement> elements;
        if (jsonElement.isJsonArray()) {
            JsonArray array = jsonElement.getAsJsonArray();
            elements = new ArrayList<JsonElement>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                elements.add(array.get(i));
            }
        } else {
            elements = Collections.singletonList(jsonElement);
        }
        ArrayList<MapResourcePack.Metadata.SupportedFormatRange> ranges = new ArrayList<MapResourcePack.Metadata.SupportedFormatRange>(elements.size());
        for (JsonElement element : elements) {
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                JsonElement min_inclusive_el = obj.get("min_inclusive");
                JsonElement max_inclusive_el = obj.get("max_inclusive");
                if (!SupportedFormatRangeListDeserializer.isNumberPrimitive(min_inclusive_el) || !SupportedFormatRangeListDeserializer.isNumberPrimitive(max_inclusive_el)) continue;
                ranges.add(MapResourcePack.Metadata.SupportedFormatRange.of(min_inclusive_el.getAsInt(), max_inclusive_el.getAsInt()));
                continue;
            }
            if (!SupportedFormatRangeListDeserializer.isNumberPrimitive(element)) continue;
            ranges.add(MapResourcePack.Metadata.SupportedFormatRange.of(element.getAsInt()));
        }
        return Collections.unmodifiableList(ranges);
    }

    private static boolean isNumberPrimitive(JsonElement element) {
        return element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber();
    }
}

