/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.map.util;

import com.bergerkiller.mountiplex.logic.TextValueSequence;

public final class VanillaResourcePackFormat {
    private final TextValueSequence minMCVersion;
    private final int pack_format;
    private static final VanillaResourcePackFormat[] VANILLA_PACK_FORMATS = new VanillaResourcePackFormat[]{VanillaResourcePackFormat.create("1.6.1", 1), VanillaResourcePackFormat.create("1.9", 2), VanillaResourcePackFormat.create("1.11", 3), VanillaResourcePackFormat.create("1.13", 4), VanillaResourcePackFormat.create("1.15", 5), VanillaResourcePackFormat.create("1.16.2", 6), VanillaResourcePackFormat.create("1.17", 7), VanillaResourcePackFormat.create("1.18", 8), VanillaResourcePackFormat.create("1.19", 9), VanillaResourcePackFormat.create("1.19.3", 12), VanillaResourcePackFormat.create("1.19.4", 13), VanillaResourcePackFormat.create("1.20", 15), VanillaResourcePackFormat.create("1.20.2", 18), VanillaResourcePackFormat.create("1.20.3", 22), VanillaResourcePackFormat.create("1.20.5", 32), VanillaResourcePackFormat.create("1.21", 34), VanillaResourcePackFormat.create("1.21.2", 42), VanillaResourcePackFormat.create("1.21.4", 46)};

    public static int getLatestPackFormat() {
        return VanillaResourcePackFormat.VANILLA_PACK_FORMATS[VanillaResourcePackFormat.VANILLA_PACK_FORMATS.length - 1].pack_format;
    }

    public static int getPackFormat(String mcVersion) {
        TextValueSequence mcVersionParsed = TextValueSequence.parse(mcVersion);
        for (int i = VANILLA_PACK_FORMATS.length - 1; i >= 0; --i) {
            VanillaResourcePackFormat format = VANILLA_PACK_FORMATS[i];
            if (!TextValueSequence.evaluate(mcVersionParsed, ">=", format.minMCVersion)) continue;
            return format.pack_format;
        }
        return 1;
    }

    private static VanillaResourcePackFormat create(String minMCVersion, int pack_format) {
        return new VanillaResourcePackFormat(minMCVersion, pack_format);
    }

    private VanillaResourcePackFormat(String minMCVersion, int pack_format) {
        this.minMCVersion = TextValueSequence.parse(minMCVersion);
        this.pack_format = pack_format;
    }
}

