/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.math;

import com.bergerkiller.bukkit.common.math.Quaternion;
import com.bergerkiller.bukkit.common.utils.FaceUtil;
import com.bergerkiller.bukkit.common.utils.MathUtil;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class OrientedBoundingBox {
    private final Vector position = new Vector();
    private final Vector radius = new Vector();
    private final Quaternion orientation = new Quaternion();
    private boolean is_orientation_set = false;

    public OrientedBoundingBox() {
    }

    public OrientedBoundingBox(Vector position, Vector size, Quaternion orientation) {
        this.setPosition(position);
        this.setSize(size);
        this.setOrientation(orientation);
    }

    public static OrientedBoundingBox naturalFromTo(Vector p1, Vector p2) {
        OrientedBoundingBox box = new OrientedBoundingBox();
        box.setPosition(p1.clone().add(p2).multiply(0.5));
        box.setSize(Math.abs(p2.getX() - p1.getX()), Math.abs(p2.getY() - p1.getY()), Math.abs(p2.getZ() - p1.getZ()));
        return box;
    }

    public Vector getPosition() {
        return this.position.clone();
    }

    public Vector getSize() {
        return this.radius.clone().multiply(2.0);
    }

    public Quaternion getOrientation() {
        return this.orientation;
    }

    public void setPosition(Vector pos) {
        MathUtil.setVector(this.position, pos);
    }

    public void setPosition(double x, double y, double z) {
        MathUtil.setVector(this.position, x, y, z);
    }

    public void setSize(Vector size) {
        this.setSize(size.getX(), size.getY(), size.getZ());
    }

    public void setSize(double sx, double sy, double sz) {
        MathUtil.setVector(this.radius, 0.5 * sx, 0.5 * sy, 0.5 * sz);
    }

    public void setOrientation(Quaternion orientation) {
        if (orientation == null) {
            this.is_orientation_set = false;
            this.orientation.setIdentity();
        } else {
            this.is_orientation_set = true;
            this.orientation.setTo(orientation);
        }
    }

    public double hitTest(double startX, double startY, double startZ, double dirX, double dirY, double dirZ) {
        return this.performHitTest(startX, startY, startZ, dirX, dirY, dirZ).distance();
    }

    public double hitTest(Vector startPosition, Vector startDirection) {
        return this.performHitTest(startPosition, startDirection).distance();
    }

    public double hitTest(Location eyeLocation) {
        return this.performHitTest(eyeLocation).distance();
    }

    public HitTestResult performHitTest(double startX, double startY, double startZ, double dirX, double dirY, double dirZ) {
        if (this.is_orientation_set) {
            return this.performHitTest(new Vector(startX, startY, startZ), new Vector(dirX, dirY, dirZ));
        }
        Vector midPos = this.position;
        double px = startX - midPos.getX();
        double py = startY - midPos.getY();
        double pz = startZ - midPos.getZ();
        Vector rad = this.radius;
        if (Math.abs(px) <= rad.getX() && Math.abs(py) <= rad.getY() && Math.abs(pz) <= rad.getZ()) {
            return HitTestResult.inside(new Vector(startX, startY, startZ));
        }
        HitTestResult result = this.hitTestBase(px, py, pz, dirX, dirY, dirZ);
        if (result.success()) {
            if (result.inside()) {
                result.position.setX(startX);
                result.position.setY(startY);
                result.position.setZ(startZ);
            } else {
                result.position.setX(startX + result.distance() * dirX);
                result.position.setY(startY + result.distance() * dirY);
                result.position.setZ(startZ + result.distance() * dirZ);
                if (this.is_orientation_set) {
                    this.orientation.transformPoint(result.normal);
                }
            }
        }
        return result;
    }

    public HitTestResult performHitTest(Vector startPosition, Vector startDirection) {
        HitTestResult result;
        Vector p = startPosition.clone().subtract(this.position);
        if (this.is_orientation_set) {
            this.orientation.invTransformPoint(p);
        }
        Vector rad = this.radius;
        if (Math.abs(p.getX()) <= rad.getX() && Math.abs(p.getY()) <= rad.getY() && Math.abs(p.getZ()) <= rad.getZ()) {
            return HitTestResult.inside(startPosition);
        }
        Vector d = startDirection;
        if (this.is_orientation_set) {
            d = d.clone();
            this.orientation.invTransformPoint(d);
        }
        if ((result = this.hitTestBase(p, d)).success()) {
            if (result.inside()) {
                result.position.copy(startPosition);
            } else {
                result.position.setX(startPosition.getX() + result.distance() * startDirection.getX());
                result.position.setY(startPosition.getY() + result.distance() * startDirection.getY());
                result.position.setZ(startPosition.getZ() + result.distance() * startDirection.getZ());
                if (this.is_orientation_set) {
                    this.orientation.transformPoint(result.normal);
                }
            }
        }
        return result;
    }

    public HitTestResult performHitTest(Location eyeLocation) {
        return this.performHitTest(eyeLocation.toVector(), eyeLocation.getDirection());
    }

    private HitTestResult hitTestBase(Vector localPos, Vector localDir) {
        return this.hitTestBase(localPos.getX(), localPos.getY(), localPos.getZ(), localDir.getX(), localDir.getY(), localDir.getZ());
    }

    private HitTestResult hitTestBase(double localPosX, double localPosY, double localPosZ, double localDirX, double localDirY, double localDirZ) {
        double ERR = 1.0E-6;
        double min_distance = Double.MAX_VALUE;
        BlockFace min_dir = null;
        Vector rad = this.radius;
        for (BlockFace dir : FaceUtil.BLOCK_SIDES) {
            double f;
            double c;
            double b;
            double a;
            if (dir.getModX() != 0) {
                a = rad.getX() * (double)dir.getModX();
                b = localPosX;
                c = localDirX;
            } else if (dir.getModY() != 0) {
                a = rad.getY() * (double)dir.getModY();
                b = localPosY;
                c = localDirY;
            } else {
                a = rad.getZ() * (double)dir.getModZ();
                b = localPosZ;
                c = localDirZ;
            }
            if (c == 0.0 || (f = (a - b) / c) < 0.0 || f > min_distance || Math.abs(localPosX + f * localDirX) - rad.getX() > 1.0E-6 || Math.abs(localPosY + f * localDirY) - rad.getY() > 1.0E-6 || Math.abs(localPosZ + f * localDirZ) - rad.getZ() > 1.0E-6) continue;
            min_distance = f;
            min_dir = dir;
        }
        if (min_distance == Double.MAX_VALUE) {
            return HitTestResult.MISSED;
        }
        if (min_distance <= 0.0) {
            return HitTestResult.inside(new Vector());
        }
        return new HitTestResult(new Vector(), FaceUtil.faceToVector(min_dir), min_distance);
    }

    public static class HitTestResult {
        public static final HitTestResult MISSED = new HitTestResult(null, null, Double.MAX_VALUE);
        private final Vector position;
        private final Vector normal;
        private final double distance;

        public HitTestResult(Vector position, Vector normal, double distance) {
            this.position = position;
            this.normal = normal;
            this.distance = distance;
        }

        public boolean success() {
            return this.distance != Double.MAX_VALUE;
        }

        public boolean inside() {
            return this.distance == 0.0;
        }

        public Vector position() {
            return this.position;
        }

        public Vector normal() {
            return this.normal;
        }

        public double distance() {
            return this.distance;
        }

        public static HitTestResult inside(Vector position) {
            return new HitTestResult(position, new Vector(), 0.0);
        }
    }
}

