/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.protocol;

import com.bergerkiller.bukkit.common.Common;
import com.bergerkiller.bukkit.common.Logging;
import com.bergerkiller.bukkit.common.collections.ClassMap;
import com.bergerkiller.bukkit.common.conversion.DuplexConversion;
import com.bergerkiller.bukkit.common.internal.CommonBootstrap;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.wrappers.DataWatcher;
import com.bergerkiller.generated.net.minecraft.network.protocol.PacketHandle;
import com.bergerkiller.generated.net.minecraft.network.syncher.DataWatcherHandle;
import com.bergerkiller.mountiplex.reflection.ClassTemplate;
import com.bergerkiller.mountiplex.reflection.FieldAccessor;
import com.bergerkiller.mountiplex.reflection.SafeField;
import com.bergerkiller.mountiplex.reflection.TranslatorFieldAccessor;
import com.bergerkiller.mountiplex.reflection.resolver.Resolver;
import com.bergerkiller.mountiplex.reflection.util.asm.MPLType;
import com.bergerkiller.reflection.net.minecraft.server.NMSPacketClasses;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class PacketType
extends ClassTemplate<Object> {
    private static Map<Class<?>, PacketTypeOptions> typesByPacketClassVisible;
    private static final ClassMap<PacketTypeOptions> typesByPacketClass;
    private static final PacketTypeOptions NO_TYPE_OPTIONS;
    public static final NMSPacketClasses.NMSPacket DEFAULT;
    public static final NMSPacketClasses.NMSPacketPlayOutAbilities OUT_ABILITIES;
    public static final NMSPacketClasses.NMSPacketPlayOutAdvancements OUT_ADVANCEMENTS;
    public static final NMSPacketClasses.NMSPacketPlayOutBed OUT_BED;
    public static final NMSPacketClasses.NMSPacketPlayOutBlockAction OUT_BLOCK_ACTION;
    public static final NMSPacketClasses.NMSPacketPlayOutCollect OUT_COLLECT;
    public static final NMSPacketClasses.NMSClientboundCustomPayloadPacket OUT_CUSTOM_PAYLOAD;
    public static final NMSPacketClasses.NMSPacketPlayOutExperience OUT_EXPERIENCE;
    public static final NMSPacketClasses.NMSPacketPlayOutExplosion OUT_EXPLOSION;
    public static final NMSPacketClasses.NMSPacketPlayOutGameStateChange OUT_GAME_STATE_CHANGE;
    public static final NMSPacketClasses.NMSPacketPlayOutHeldItemSlot OUT_HELD_ITEM_SLOT;
    public static final NMSPacketClasses.NMSClientboundKeepAlivePacket OUT_KEEP_ALIVE;
    public static final NMSPacketClasses.NMSClientboundDisconnectPacket OUT_KICK_DISCONNECT;
    public static final NMSPacketClasses.NMSPacketPlayOutLogin OUT_LOGIN;
    public static final NMSPacketClasses.NMSPacketPlayOutMap OUT_MAP;
    public static final NMSPacketClasses.NMSPacketPlayOutMapChunk OUT_MAP_CHUNK;
    public static final NMSPacketClasses.NMSPacketPlayOutPlayerListHeaderFooter OUT_PLAYER_LIST_HEADER_FOOTER;
    public static final NMSPacketClasses.NMSPacketPlayOutNamedSoundEffect OUT_NAMED_SOUND_EFFECT;
    public static final NMSPacketClasses.NMSPacketPlayOutOpenSignEditor OUT_OPEN_SIGN_EDITOR;
    public static final NMSPacketClasses.NMSClientboundPlayerInfoUpdatePacket OUT_PLAYER_INFO_UPDATE;
    public static final NMSPacketClasses.NMSClientboundPlayerInfoRemovePacket OUT_PLAYER_INFO_REMOVE;
    public static final NMSPacketClasses.NMSPacketPlayOutPosition OUT_POSITION;
    public static final NMSPacketClasses.NMSPacketPlayOutRespawn OUT_RESPAWN;
    public static final NMSPacketClasses.NMSPacketPlayOutSpawnPosition OUT_SPAWN_POSITION;
    public static final NMSPacketClasses.NMSPacketPlayOutStatistic OUT_STATISTIC;
    public static final NMSPacketClasses.NMSPacketPlayOutTabComplete OUT_TAB_COMPLETE;
    public static final NMSPacketClasses.NMSPacketPlayOutTileEntityData OUT_TILE_ENTITY_DATA;
    public static final NMSPacketClasses.NMSPacketPlayOutUpdateHealth OUT_UPDATE_HEALTH;
    public static final NMSPacketClasses.NMSPacketPlayOutUpdateTime OUT_UPDATE_TIME;
    public static final NMSPacketClasses.NMSPacketPlayOutWorldEvent OUT_WORLD_EVENT;
    public static final NMSPacketClasses.NMSPacketPlayOutWorldParticles OUT_WORLD_PARTICLES;
    public static final NMSPacketClasses.NMSPacketPlayOutBlockBreakAnimation OUT_BLOCK_BREAK_ANIMATION;
    public static final NMSPacketClasses.NMSPacketPlayOutBlockChange OUT_BLOCK_CHANGE;
    public static final NMSPacketClasses.NMSPacketPlayOutBoss OUT_BOSS;
    public static final NMSPacketClasses.NMSPacketPlayOutCamera OUT_CAMERA;
    public static final NMSPacketClasses.NMSPacketPlayOutCustomSoundEffect OUT_CUSTOM_SOUND_EFFECT;
    public static final NMSPacketClasses.NMSClientboundResourcePackPushPacket OUT_RESOURCE_PACK_PUSH;
    public static final NMSPacketClasses.NMSClientboundResourcePackPopPacket OUT_RESOURCE_PACK_POP;
    public static final NMSPacketClasses.NMSPacketPlayOutServerDifficulty OUT_SERVER_DIFFICULTY;
    public static final NMSPacketClasses.NMSPacketPlayOutSetCooldown OUT_SET_COOLDOWN;
    public static final NMSPacketClasses.NMSPacketPlayOutUnloadChunk OUT_UNLOAD_CHUNK;
    public static final NMSPacketClasses.NMSPacketPlayOutScoreboardDisplayObjective OUT_SCOREBOARD_DISPLAY_OBJECTIVE;
    public static final NMSPacketClasses.NMSPacketPlayOutScoreboardObjective OUT_SCOREBOARD_OBJECTIVE;
    public static final NMSPacketClasses.NMSPacketPlayOutScoreboardScore OUT_SCOREBOARD_SCORE;
    public static final NMSPacketClasses.NMSClientboundResetScorePacket OUT_SCOREBOARD_SCORE_RESET;
    public static final NMSPacketClasses.NMSPacketPlayOutScoreboardTeam OUT_SCOREBOARD_TEAM;
    public static final NMSPacketClasses.NMSPacketPlayOutCloseWindow OUT_WINDOW_CLOSE;
    public static final NMSPacketClasses.NMSPacketPlayOutWindowData OUT_WINDOW_DATA;
    public static final NMSPacketClasses.NMSPacketPlayOutOpenWindow OUT_WINDOW_OPEN;
    public static final NMSPacketClasses.NMSPacketPlayOutSetSlot OUT_WINDOW_SET_SLOT;
    public static final NMSPacketClasses.NMSPacketPlayOutWindowItems OUT_WINDOW_ITEMS;
    public static final NMSPacketClasses.NMSPacketPlayOutSpawnEntity OUT_ENTITY_SPAWN;
    public static final NMSPacketClasses.NMSPacketPlayOutNamedEntitySpawn OUT_ENTITY_SPAWN_NAMED;
    public static final NMSPacketClasses.NMSPacketPlayOutSpawnEntityExperienceOrb OUT_ENTITY_SPAWN_EXPORB;
    public static final NMSPacketClasses.NMSPacketPlayOutSpawnEntityLiving OUT_ENTITY_SPAWN_LIVING;
    public static final NMSPacketClasses.NMSPacketPlayOutSpawnEntityPainting OUT_ENTITY_SPAWN_PAINTING;
    public static final NMSPacketClasses.NMSPacketPlayOutSpawnEntityWeather OUT_ENTITY_SPAWN_WITHER;
    public static final NMSPacketClasses.NMSPacketPlayOutEntityDestroy OUT_ENTITY_DESTROY;
    public static final NMSPacketClasses.NMSPacketPlayOutAttachEntity OUT_ENTITY_ATTACH;
    public static final NMSPacketClasses.NMSPacketPlayOutEntityEffect OUT_ENTITY_EFFECT_ADD;
    public static final NMSPacketClasses.NMSPacketPlayOutRemoveEntityEffect OUT_ENTITY_EFFECT_REMOVE;
    public static final NMSPacketClasses.NMSPacketPlayOutEntityEquipment OUT_ENTITY_EQUIPMENT;
    public static final NMSPacketClasses.NMSPacketPlayOutEntityHeadRotation OUT_ENTITY_HEAD_ROTATION;
    public static final NMSPacketClasses.NMSPacketPlayOutEntityLook OUT_ENTITY_LOOK;
    public static final NMSPacketClasses.NMSPacketPlayOutAnimation OUT_ENTITY_ANIMATION;
    public static final NMSPacketClasses.NMSPacketPlayOutEntityMetadata OUT_ENTITY_METADATA;
    public static final NMSPacketClasses.NMSPacketPlayOutEntityStatus OUT_ENTITY_STATUS;
    public static final NMSPacketClasses.NMSPacketPlayOutEntityTeleport OUT_ENTITY_TELEPORT;
    public static final NMSPacketClasses.NMSPacketPlayOutEntityVelocity OUT_ENTITY_VELOCITY;
    public static final NMSPacketClasses.NMSPacketPlayOutRelEntityMove OUT_ENTITY_MOVE;
    public static final NMSPacketClasses.NMSPacketPlayOutRelEntityMoveLook OUT_ENTITY_MOVE_LOOK;
    public static final NMSPacketClasses.NMSPacketPlayOutUpdateAttributes OUT_ENTITY_UPDATE_ATTRIBUTES;
    public static final NMSPacketClasses.NMSPacketPlayOutMount OUT_MOUNT;
    public static final NMSPacketClasses.NMSPacketPlayOutVehicleMove OUT_VEHICLE_MOVE;
    public static final NMSPacketClasses.NMSPacketPlayOutUpdateSign OUT_UPDATE_SIGN;
    public static final NMSPacketClasses.NMSClientboundBundlePacket OUT_BUNDLE;
    public static final NMSPacketClasses.NMSPacketPlayInAbilities IN_ABILITIES;
    public static final NMSPacketClasses.NMSPacketPlayInArmAnimation IN_ENTITY_ANIMATION;
    public static final NMSPacketClasses.NMSPacketPlayInBlockDig IN_BLOCK_DIG;
    public static final NMSPacketClasses.NMSPacketPlayInBlockPlace IN_BLOCK_PLACE;
    public static final NMSPacketClasses.NMSPacketPlayInBoatMove IN_BOAT_MOVE;
    public static final NMSPacketClasses.NMSPacketPlayInChat IN_CHAT;
    public static final NMSPacketClasses.NMSPacketPlayInClientCommand IN_CLIENT_COMMAND;
    public static final NMSPacketClasses.NMSPacketPlayInCustomPayload IN_CUSTOM_PAYLOAD;
    public static final NMSPacketClasses.NMSPacketPlayInEntityAction IN_ENTITY_ACTION;
    public static final NMSPacketClasses.NMSPacketPlayInLook IN_LOOK;
    public static final NMSPacketClasses.NMSPacketPlayInPosition IN_POSITION;
    public static final NMSPacketClasses.NMSPacketPlayInPositionLook IN_POSITION_LOOK;
    public static final NMSPacketClasses.NMSPacketPlayInHeldItemSlot IN_HELD_ITEM_SLOT;
    public static final NMSPacketClasses.NMSServerboundKeepAlivePacket IN_KEEP_ALIVE;
    public static final NMSPacketClasses.NMSPacketPlayInSpectate IN_SPECTATE;
    public static final NMSPacketClasses.NMSPacketPlayInSetCreativeSlot IN_SET_CREATIVE_SLOT;
    public static final NMSPacketClasses.NMSServerboundClientInformationPacket IN_SETTINGS;
    public static final NMSPacketClasses.NMSPacketPlayInSteerVehicle IN_STEER_VEHICLE;
    public static final NMSPacketClasses.NMSPacketPlayInTabComplete IN_TAB_COMPLETE;
    public static final NMSPacketClasses.NMSPacketPlayInTeleportAccept IN_TELEPORT_ACCEPT;
    public static final NMSPacketClasses.NMSPacketPlayInUpdateSign IN_UPDATE_SIGN;
    public static final NMSPacketClasses.NMSPacketPlayInUseEntity IN_USE_ENTITY;
    public static final NMSPacketClasses.NMSPacketPlayInUseItem IN_USE_ITEM;
    public static final NMSPacketClasses.NMSPacketPlayInVehicleMove IN_VEHICLE_MOVE;
    public static final NMSPacketClasses.NMSServerboundClientTickEndPacket IN_CLIENT_TICK_END;
    public static final NMSPacketClasses.NMSPacketPlayInCloseWindow IN_WINDOW_CLOSE;
    public static final NMSPacketClasses.NMSPacketPlayInEnchantItem IN_WINDOW_ENCHANT_ITEM;
    public static final NMSPacketClasses.NMSServerboundResourcePackPacket IN_WINDOW_RESOURCEPACK_STATUS;
    public static final NMSPacketClasses.NMSPacketPlayInWindowClick IN_WINDOW_CLICK;
    private final String name;
    private final boolean outgoing;
    private final FieldAccessor<DataWatcher> dataWatcherField;

    public PacketType() {
        this((String)null);
    }

    public void init() {
    }

    protected PacketType(String packetClassName) {
        this(packetClassName, null);
    }

    protected PacketType(Class<?> packetClass) {
        this(packetClass.getSimpleName(), packetClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected PacketType(String packetClassName, Class<?> packetClass) {
        String string = this.name = packetClassName != null ? packetClassName : this.getClass().getSimpleName().substring(3);
        if (packetClass == null) {
            if (this.name.equals("Packet")) {
                packetClass = CommonUtil.getClass("net.minecraft.network.protocol." + this.name);
            } else {
                packetClass = CommonUtil.getClass("net.minecraft.network.protocol.game." + this.name);
                if (packetClass == null) {
                    packetClass = CommonUtil.getClass("net.minecraft.network.protocol.common." + this.name);
                }
            }
        }
        if (packetClass == null) {
            this.outgoing = false;
            this.dataWatcherField = null;
            return;
        }
        if (!packetClass.equals(PacketHandle.T.getType())) {
            Class<PacketType> clazz = PacketType.class;
            // MONITORENTER : com.bergerkiller.bukkit.common.protocol.PacketType.class
            typesByPacketClass.put(packetClass, typesByPacketClass.getOrDefault(packetClass, NO_TYPE_OPTIONS).add(this));
            typesByPacketClassVisible = new HashMap(typesByPacketClass.getData());
            // MONITOREXIT : clazz
        }
        this.setClass(packetClass);
        this.addImport("net.minecraft.network.protocol.game.*");
        this.outgoing = PacketType.isPacketOutgoing(this.getType());
        TranslatorFieldAccessor<DataWatcher> dataWatcherField = null;
        for (SafeField<Object> safeField : this.getFields()) {
            if (!DataWatcherHandle.T.isType(safeField.getType())) continue;
            dataWatcherField = safeField.translate(DuplexConversion.dataWatcher);
            break;
        }
        this.dataWatcherField = dataWatcherField;
    }

    public boolean isOutGoing() {
        return this.outgoing;
    }

    @Override
    public String toString() {
        return this.name;
    }

    protected boolean matchPacket(Object packetHandle) {
        return true;
    }

    public void preprocess(Object packetHandle) {
    }

    public FieldAccessor<DataWatcher> getMetaDataField() {
        if (this.dataWatcherField == null) {
            throw new IllegalArgumentException("MetaData field does not exist");
        }
        return this.dataWatcherField;
    }

    public static PacketType getType(Object packetHandle) {
        Class<?> packetHandleType;
        try {
            packetHandleType = packetHandle.getClass();
        }
        catch (NullPointerException ex) {
            if (packetHandle == null) {
                throw new IllegalArgumentException("Input packet is null");
            }
            throw ex;
        }
        return LogicUtil.synchronizeCopyOnWrite(PacketType.class, () -> typesByPacketClassVisible.getOrDefault(packetHandleType, NO_TYPE_OPTIONS).find(packetHandle), () -> {
            PacketTypeOptions options = typesByPacketClass.getOrDefault(packetHandleType, NO_TYPE_OPTIONS);
            PacketType type = options.find(packetHandle);
            if (type == null) {
                return new PacketType(packetHandleType);
            }
            HashMap newMap = new HashMap(typesByPacketClassVisible);
            newMap.put(packetHandleType, options);
            typesByPacketClassVisible = newMap;
            return type;
        });
    }

    private static boolean isPacketOutgoing(Class<?> packetClass) {
        if (packetClass == null) {
            return false;
        }
        try {
            if (CommonBootstrap.evaluateMCVersion(">=", "1.20.5")) {
                return PacketType.isPacketOutgoing_1_20_5(packetClass);
            }
            return PacketType.isPacketOutgoing_1_8_to_1_20_4(packetClass);
        }
        catch (Throwable t) {
            Logging.LOGGER_NETWORK.log(Level.SEVERE, "Failed to determine outgoing for packet " + packetClass, t);
            return false;
        }
    }

    private static boolean isPacketOutgoing_1_20_5(Class<?> packetClass) throws Throwable {
        String name = MPLType.getName(packetClass);
        if (name.contains("Clientbound") || name.contains("PacketPlayOut")) {
            return true;
        }
        if (name.contains("Serverbound") || name.contains("PacketPlayIn")) {
            return false;
        }
        if (packetClass.equals(PacketHandle.T.getType())) {
            return false;
        }
        throw new IllegalStateException("Unknown packet class name format: " + name);
    }

    private static boolean isPacketOutgoing_1_8_to_1_20_4(Class<?> packetClass) throws Throwable {
        ?[] protocols;
        Class<?> enumProtocolType = CommonUtil.getClass("net.minecraft.network.EnumProtocol");
        Class<?> enumProtocolDirectionType = CommonUtil.getClass("net.minecraft.network.protocol.EnumProtocolDirection");
        Class<?> bimapClass = CommonUtil.getClass("com.google.common.collect.BiMap");
        Field f = Resolver.resolveAndGetDeclaredField(enumProtocolDirectionType, "CLIENTBOUND");
        Object clientBoundDirection = f.get(null);
        Field flowsField = null;
        if (CommonBootstrap.evaluateMCVersion(">=", "1.17")) {
            flowsField = Resolver.resolveAndGetDeclaredField(enumProtocolType, "flows");
        } else {
            flowsField = LogicUtil.tryMake(() -> {
                Field f = enumProtocolType.getDeclaredField("packetMap");
                return Map.class.isAssignableFrom(f.getType()) ? f : null;
            }, null);
            if (flowsField == null) {
                flowsField = CommonBootstrap.evaluateMCVersion(">=", "1.10.2") ? Resolver.resolveAndGetDeclaredField(enumProtocolType, "h") : (CommonBootstrap.evaluateMCVersion(">=", "1.8.3") ? Resolver.resolveAndGetDeclaredField(enumProtocolType, "j") : Resolver.resolveAndGetDeclaredField(enumProtocolType, "h"));
            }
        }
        flowsField.setAccessible(true);
        for (Object protocol : protocols = enumProtocolType.getEnumConstants()) {
            Object directionFlows = ((Map)flowsField.get(protocol)).get(clientBoundDirection);
            if (directionFlows == null) continue;
            if (bimapClass.isAssignableFrom(directionFlows.getClass())) {
                Method containsValueMethod = bimapClass.getMethod("containsValue", Object.class);
                Boolean containsValue = (Boolean)containsValueMethod.invoke(directionFlows, packetClass);
                if (!containsValue.booleanValue()) continue;
                return true;
            }
            if (directionFlows instanceof Map) {
                if (!((Map)directionFlows).containsValue(packetClass)) continue;
                return true;
            }
            PacketSearchResult packetContained = PacketType.tryCheckPacketClassContained(directionFlows, packetClass);
            if (packetContained == PacketSearchResult.FAILED) {
                for (Field f2 : directionFlows.getClass().getDeclaredFields()) {
                    if (Modifier.isStatic(f2.getModifiers()) || f2.getType().getDeclaringClass() != enumProtocolType) continue;
                    f2.setAccessible(true);
                    Object directionFlowsSub = f2.get(directionFlows);
                    packetContained = PacketType.tryCheckPacketClassContained(directionFlowsSub, packetClass);
                    if (packetContained != PacketSearchResult.FAILED) break;
                }
            }
            if (packetContained == PacketSearchResult.FAILED) {
                throw new IllegalStateException("Unable to identify packet flow direction");
            }
            if (packetContained != PacketSearchResult.FOUND) continue;
            return true;
        }
        return false;
    }

    private static PacketSearchResult tryCheckPacketClassContained(Object flows, Class<?> packetClass) throws Throwable {
        Method getPacketIdMethod = null;
        if (flows != null) {
            block0: for (Class<?> flowType = flows.getClass(); flowType != null && flowType != Object.class; flowType = flowType.getSuperclass()) {
                for (Method m : flowType.getDeclaredMethods()) {
                    if (m.getParameterCount() != 1 || !m.getParameterTypes()[0].equals(Class.class) || m.getReturnType() != Integer.class && m.getReturnType() != Integer.TYPE) continue;
                    getPacketIdMethod = m;
                    continue block0;
                }
            }
        }
        if (getPacketIdMethod == null) {
            return PacketSearchResult.FAILED;
        }
        getPacketIdMethod.setAccessible(true);
        Integer packetId = (Integer)getPacketIdMethod.invoke(flows, packetClass);
        return packetId != null && packetId != -1 ? PacketSearchResult.FOUND : PacketSearchResult.NOT_FOUND;
    }

    static {
        CommonBootstrap.initServer();
        typesByPacketClassVisible = Collections.emptyMap();
        typesByPacketClass = new ClassMap();
        NO_TYPE_OPTIONS = new PacketTypeOptions(){

            @Override
            public PacketType firstRegistered() {
                return null;
            }

            @Override
            public PacketType find(Object packetHandle) {
                return null;
            }

            @Override
            public PacketTypeOptions add(PacketType newType) {
                return new PacketTypeOptionsSingleton(newType);
            }
        };
        DEFAULT = new NMSPacketClasses.NMSPacket();
        OUT_ABILITIES = new NMSPacketClasses.NMSPacketPlayOutAbilities();
        OUT_ADVANCEMENTS = new NMSPacketClasses.NMSPacketPlayOutAdvancements();
        OUT_BED = Common.evaluateMCVersion(">=", "1.14") ? null : new NMSPacketClasses.NMSPacketPlayOutBed();
        OUT_BLOCK_ACTION = new NMSPacketClasses.NMSPacketPlayOutBlockAction();
        OUT_COLLECT = new NMSPacketClasses.NMSPacketPlayOutCollect();
        OUT_CUSTOM_PAYLOAD = new NMSPacketClasses.NMSClientboundCustomPayloadPacket();
        OUT_EXPERIENCE = new NMSPacketClasses.NMSPacketPlayOutExperience();
        OUT_EXPLOSION = new NMSPacketClasses.NMSPacketPlayOutExplosion();
        OUT_GAME_STATE_CHANGE = new NMSPacketClasses.NMSPacketPlayOutGameStateChange();
        OUT_HELD_ITEM_SLOT = new NMSPacketClasses.NMSPacketPlayOutHeldItemSlot();
        OUT_KEEP_ALIVE = new NMSPacketClasses.NMSClientboundKeepAlivePacket();
        OUT_KICK_DISCONNECT = new NMSPacketClasses.NMSClientboundDisconnectPacket();
        OUT_LOGIN = new NMSPacketClasses.NMSPacketPlayOutLogin();
        OUT_MAP = new NMSPacketClasses.NMSPacketPlayOutMap();
        OUT_MAP_CHUNK = new NMSPacketClasses.NMSPacketPlayOutMapChunk();
        OUT_PLAYER_LIST_HEADER_FOOTER = new NMSPacketClasses.NMSPacketPlayOutPlayerListHeaderFooter();
        OUT_NAMED_SOUND_EFFECT = new NMSPacketClasses.NMSPacketPlayOutNamedSoundEffect();
        OUT_OPEN_SIGN_EDITOR = new NMSPacketClasses.NMSPacketPlayOutOpenSignEditor();
        OUT_PLAYER_INFO_UPDATE = new NMSPacketClasses.NMSClientboundPlayerInfoUpdatePacket();
        OUT_PLAYER_INFO_REMOVE = new NMSPacketClasses.NMSClientboundPlayerInfoRemovePacket();
        OUT_POSITION = new NMSPacketClasses.NMSPacketPlayOutPosition();
        OUT_RESPAWN = new NMSPacketClasses.NMSPacketPlayOutRespawn();
        OUT_SPAWN_POSITION = new NMSPacketClasses.NMSPacketPlayOutSpawnPosition();
        OUT_STATISTIC = new NMSPacketClasses.NMSPacketPlayOutStatistic();
        OUT_TAB_COMPLETE = new NMSPacketClasses.NMSPacketPlayOutTabComplete();
        OUT_TILE_ENTITY_DATA = new NMSPacketClasses.NMSPacketPlayOutTileEntityData();
        OUT_UPDATE_HEALTH = new NMSPacketClasses.NMSPacketPlayOutUpdateHealth();
        OUT_UPDATE_TIME = new NMSPacketClasses.NMSPacketPlayOutUpdateTime();
        OUT_WORLD_EVENT = new NMSPacketClasses.NMSPacketPlayOutWorldEvent();
        OUT_WORLD_PARTICLES = new NMSPacketClasses.NMSPacketPlayOutWorldParticles();
        OUT_BLOCK_BREAK_ANIMATION = new NMSPacketClasses.NMSPacketPlayOutBlockBreakAnimation();
        OUT_BLOCK_CHANGE = new NMSPacketClasses.NMSPacketPlayOutBlockChange();
        OUT_BOSS = new NMSPacketClasses.NMSPacketPlayOutBoss();
        OUT_CAMERA = new NMSPacketClasses.NMSPacketPlayOutCamera();
        OUT_CUSTOM_SOUND_EFFECT = new NMSPacketClasses.NMSPacketPlayOutCustomSoundEffect();
        OUT_RESOURCE_PACK_PUSH = new NMSPacketClasses.NMSClientboundResourcePackPushPacket();
        OUT_RESOURCE_PACK_POP = new NMSPacketClasses.NMSClientboundResourcePackPopPacket();
        OUT_SERVER_DIFFICULTY = new NMSPacketClasses.NMSPacketPlayOutServerDifficulty();
        OUT_SET_COOLDOWN = new NMSPacketClasses.NMSPacketPlayOutSetCooldown();
        OUT_UNLOAD_CHUNK = new NMSPacketClasses.NMSPacketPlayOutUnloadChunk();
        OUT_SCOREBOARD_DISPLAY_OBJECTIVE = new NMSPacketClasses.NMSPacketPlayOutScoreboardDisplayObjective();
        OUT_SCOREBOARD_OBJECTIVE = new NMSPacketClasses.NMSPacketPlayOutScoreboardObjective();
        OUT_SCOREBOARD_SCORE = new NMSPacketClasses.NMSPacketPlayOutScoreboardScore();
        OUT_SCOREBOARD_SCORE_RESET = new NMSPacketClasses.NMSClientboundResetScorePacket();
        OUT_SCOREBOARD_TEAM = new NMSPacketClasses.NMSPacketPlayOutScoreboardTeam();
        OUT_WINDOW_CLOSE = new NMSPacketClasses.NMSPacketPlayOutCloseWindow();
        OUT_WINDOW_DATA = new NMSPacketClasses.NMSPacketPlayOutWindowData();
        OUT_WINDOW_OPEN = new NMSPacketClasses.NMSPacketPlayOutOpenWindow();
        OUT_WINDOW_SET_SLOT = new NMSPacketClasses.NMSPacketPlayOutSetSlot();
        OUT_WINDOW_ITEMS = new NMSPacketClasses.NMSPacketPlayOutWindowItems();
        OUT_ENTITY_SPAWN = new NMSPacketClasses.NMSPacketPlayOutSpawnEntity();
        OUT_ENTITY_SPAWN_NAMED = new NMSPacketClasses.NMSPacketPlayOutNamedEntitySpawn();
        OUT_ENTITY_SPAWN_EXPORB = new NMSPacketClasses.NMSPacketPlayOutSpawnEntityExperienceOrb();
        OUT_ENTITY_SPAWN_LIVING = new NMSPacketClasses.NMSPacketPlayOutSpawnEntityLiving();
        OUT_ENTITY_SPAWN_PAINTING = new NMSPacketClasses.NMSPacketPlayOutSpawnEntityPainting();
        OUT_ENTITY_SPAWN_WITHER = new NMSPacketClasses.NMSPacketPlayOutSpawnEntityWeather();
        OUT_ENTITY_DESTROY = new NMSPacketClasses.NMSPacketPlayOutEntityDestroy();
        OUT_ENTITY_ATTACH = new NMSPacketClasses.NMSPacketPlayOutAttachEntity();
        OUT_ENTITY_EFFECT_ADD = new NMSPacketClasses.NMSPacketPlayOutEntityEffect();
        OUT_ENTITY_EFFECT_REMOVE = new NMSPacketClasses.NMSPacketPlayOutRemoveEntityEffect();
        OUT_ENTITY_EQUIPMENT = new NMSPacketClasses.NMSPacketPlayOutEntityEquipment();
        OUT_ENTITY_HEAD_ROTATION = new NMSPacketClasses.NMSPacketPlayOutEntityHeadRotation();
        OUT_ENTITY_LOOK = new NMSPacketClasses.NMSPacketPlayOutEntityLook();
        OUT_ENTITY_ANIMATION = new NMSPacketClasses.NMSPacketPlayOutAnimation();
        OUT_ENTITY_METADATA = new NMSPacketClasses.NMSPacketPlayOutEntityMetadata();
        OUT_ENTITY_STATUS = new NMSPacketClasses.NMSPacketPlayOutEntityStatus();
        OUT_ENTITY_TELEPORT = new NMSPacketClasses.NMSPacketPlayOutEntityTeleport();
        OUT_ENTITY_VELOCITY = new NMSPacketClasses.NMSPacketPlayOutEntityVelocity();
        OUT_ENTITY_MOVE = new NMSPacketClasses.NMSPacketPlayOutRelEntityMove();
        OUT_ENTITY_MOVE_LOOK = new NMSPacketClasses.NMSPacketPlayOutRelEntityMoveLook();
        OUT_ENTITY_UPDATE_ATTRIBUTES = new NMSPacketClasses.NMSPacketPlayOutUpdateAttributes();
        OUT_MOUNT = new NMSPacketClasses.NMSPacketPlayOutMount();
        OUT_VEHICLE_MOVE = new NMSPacketClasses.NMSPacketPlayOutVehicleMove();
        OUT_UPDATE_SIGN = new NMSPacketClasses.NMSPacketPlayOutUpdateSign();
        OUT_BUNDLE = new NMSPacketClasses.NMSClientboundBundlePacket();
        IN_ABILITIES = new NMSPacketClasses.NMSPacketPlayInAbilities();
        IN_ENTITY_ANIMATION = new NMSPacketClasses.NMSPacketPlayInArmAnimation();
        IN_BLOCK_DIG = new NMSPacketClasses.NMSPacketPlayInBlockDig();
        IN_BLOCK_PLACE = new NMSPacketClasses.NMSPacketPlayInBlockPlace();
        IN_BOAT_MOVE = new NMSPacketClasses.NMSPacketPlayInBoatMove();
        IN_CHAT = new NMSPacketClasses.NMSPacketPlayInChat();
        IN_CLIENT_COMMAND = new NMSPacketClasses.NMSPacketPlayInClientCommand();
        IN_CUSTOM_PAYLOAD = new NMSPacketClasses.NMSPacketPlayInCustomPayload();
        IN_ENTITY_ACTION = new NMSPacketClasses.NMSPacketPlayInEntityAction();
        IN_LOOK = new NMSPacketClasses.NMSPacketPlayInLook();
        IN_POSITION = new NMSPacketClasses.NMSPacketPlayInPosition();
        IN_POSITION_LOOK = new NMSPacketClasses.NMSPacketPlayInPositionLook();
        IN_HELD_ITEM_SLOT = new NMSPacketClasses.NMSPacketPlayInHeldItemSlot();
        IN_KEEP_ALIVE = new NMSPacketClasses.NMSServerboundKeepAlivePacket();
        IN_SPECTATE = new NMSPacketClasses.NMSPacketPlayInSpectate();
        IN_SET_CREATIVE_SLOT = new NMSPacketClasses.NMSPacketPlayInSetCreativeSlot();
        IN_SETTINGS = new NMSPacketClasses.NMSServerboundClientInformationPacket();
        IN_STEER_VEHICLE = new NMSPacketClasses.NMSPacketPlayInSteerVehicle();
        IN_TAB_COMPLETE = new NMSPacketClasses.NMSPacketPlayInTabComplete();
        IN_TELEPORT_ACCEPT = new NMSPacketClasses.NMSPacketPlayInTeleportAccept();
        IN_UPDATE_SIGN = new NMSPacketClasses.NMSPacketPlayInUpdateSign();
        IN_USE_ENTITY = new NMSPacketClasses.NMSPacketPlayInUseEntity();
        IN_USE_ITEM = new NMSPacketClasses.NMSPacketPlayInUseItem();
        IN_VEHICLE_MOVE = new NMSPacketClasses.NMSPacketPlayInVehicleMove();
        IN_CLIENT_TICK_END = new NMSPacketClasses.NMSServerboundClientTickEndPacket();
        IN_WINDOW_CLOSE = new NMSPacketClasses.NMSPacketPlayInCloseWindow();
        IN_WINDOW_ENCHANT_ITEM = new NMSPacketClasses.NMSPacketPlayInEnchantItem();
        IN_WINDOW_RESOURCEPACK_STATUS = new NMSPacketClasses.NMSServerboundResourcePackPacket();
        IN_WINDOW_CLICK = new NMSPacketClasses.NMSPacketPlayInWindowClick();
    }

    private static interface PacketTypeOptions {
        public PacketType firstRegistered();

        public PacketType find(Object var1);

        public PacketTypeOptions add(PacketType var1);
    }

    private static enum PacketSearchResult {
        FAILED,
        NOT_FOUND,
        FOUND;

    }

    private static final class PacketTypeOptionsMultiple
    implements PacketTypeOptions {
        private final PacketType[] types;

        public PacketTypeOptionsMultiple(List<PacketType> types) {
            this.types = types.toArray(new PacketType[types.size()]);
        }

        @Override
        public PacketType firstRegistered() {
            return this.types[this.types.length - 1];
        }

        @Override
        public PacketType find(Object packetHandle) {
            for (PacketType type : this.types) {
                if (!type.matchPacket(packetHandle)) continue;
                return type;
            }
            return null;
        }

        @Override
        public PacketTypeOptions add(PacketType newType) {
            ArrayList<PacketType> newTypes = new ArrayList<PacketType>(this.types.length + 1);
            newTypes.add(newType);
            newTypes.addAll(Arrays.asList(this.types));
            return new PacketTypeOptionsMultiple(newTypes);
        }
    }

    private static final class PacketTypeOptionsSingleton
    implements PacketTypeOptions {
        private final PacketType type;

        public PacketTypeOptionsSingleton(PacketType type) {
            this.type = type;
        }

        @Override
        public PacketType firstRegistered() {
            return this.type;
        }

        @Override
        public PacketType find(Object packetHandle) {
            return this.type;
        }

        @Override
        public PacketTypeOptions add(PacketType newType) {
            ArrayList<PacketType> types = new ArrayList<PacketType>(2);
            types.add(newType);
            types.add(this.type);
            return new PacketTypeOptionsMultiple(types);
        }
    }
}

