/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.server;

import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.server.CommonServer;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.StreamUtil;
import com.bergerkiller.mountiplex.logic.TextValueSequence;
import com.bergerkiller.mountiplex.reflection.util.asm.ASMUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.EntityType;

public abstract class CommonServerBase
implements CommonServer {
    public static final Class<? extends Bukkit> SERVER_CLASS = CommonServerBase.findServerClass();

    private static final Class<?> findServerClass() {
        if (Bukkit.getServer() != null) {
            return Bukkit.getServer().getClass();
        }
        Class<?> cbMailClass = CommonUtil.getClass("org.bukkit.craftbukkit.Main");
        if (cbMailClass != null) {
            for (Class<?> type : ASMUtil.findUsedTypes(cbMailClass)) {
                if (!Server.class.isAssignableFrom(type)) continue;
                return type;
            }
        }
        return null;
    }

    @Override
    public Collection<String> getLoadableWorlds() {
        String[] subDirs = Bukkit.getWorldContainer().list();
        ArrayList<String> rval = new ArrayList<String>(subDirs.length);
        for (String worldName : subDirs) {
            if (!this.isLoadableWorld(worldName)) continue;
            rval.add(worldName);
        }
        return rval;
    }

    @Override
    public File getWorldFolder(String worldName) {
        return StreamUtil.getFileIgnoreCase(Bukkit.getWorldContainer(), worldName);
    }

    @Override
    public File getWorldLevelFile(String worldName) {
        return new File(this.getWorldFolder(worldName), "level.dat");
    }

    @Override
    public boolean isLoadableWorld(String worldName) {
        if (Bukkit.getWorld((String)worldName) != null) {
            return true;
        }
        File worldFolder = this.getWorldFolder(worldName);
        if (!worldFolder.isDirectory()) {
            return false;
        }
        if (new File(worldFolder, "level.dat").exists()) {
            return true;
        }
        File regionFolder = this.getWorldRegionFolder(worldName);
        if (regionFolder != null) {
            for (String fileName : regionFolder.list()) {
                if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".mca")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public File getWorldRegionFolder(String worldName) {
        File mainFolder = this.getWorldFolder(worldName);
        File tmp = new File(mainFolder, "region");
        if (tmp.exists()) {
            return tmp;
        }
        tmp = new File(mainFolder, "DIM-1" + File.separator + "region");
        if (tmp.exists()) {
            return tmp;
        }
        tmp = new File(mainFolder, "DIM1" + File.separator + "region");
        if (tmp.exists()) {
            return tmp;
        }
        return null;
    }

    @Override
    public String getMinecraftVersionMajor() {
        return CommonServer.cleanVersion(this.getMinecraftVersion());
    }

    @Override
    public String getMinecraftVersionPre() {
        return CommonServer.preVersion(this.getMinecraftVersion());
    }

    @Override
    public boolean evaluateMCVersion(String operand, String version) {
        return TextValueSequence.evaluateText(this.getMinecraftVersion(), operand, version);
    }

    @Override
    public void addVariables(Map<String, String> variables) {
        variables.put("version", this.getMinecraftVersionMajor());
        String pre_version = this.getMinecraftVersionPre();
        if (pre_version != null) {
            variables.put("pre", pre_version);
        }
    }

    @Override
    public String getServerDetails() {
        StringBuilder serverDesc = new StringBuilder(300);
        serverDesc.append(this.getServerName()).append(" (");
        serverDesc.append(this.getServerDescription());
        if (this.isMojangMappings()) {
            serverDesc.append(" | mojmap");
        }
        serverDesc.append(") : ").append(this.getServerVersion());
        return serverDesc.toString();
    }

    @Override
    public boolean isCustomEntityType(EntityType entityType) {
        return false;
    }

    @Override
    public void enable(CommonPlugin plugin) {
    }

    @Override
    public void disable(CommonPlugin plugin) {
    }
}

