/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.server;

import com.bergerkiller.bukkit.common.Logging;
import com.bergerkiller.bukkit.common.internal.cdn.MojangSpigotRemapper;
import com.bergerkiller.bukkit.common.internal.cdn.SpigotMappings;
import com.bergerkiller.bukkit.common.server.CommonServer;
import com.bergerkiller.bukkit.common.server.CommonServerBase;
import com.bergerkiller.bukkit.common.server.MinecraftVersionDiscovery;
import com.bergerkiller.bukkit.common.server.VersionIdentificationFailureException;
import com.bergerkiller.mountiplex.logic.TextValueSequence;
import com.bergerkiller.mountiplex.reflection.resolver.ClassPathResolver;
import com.bergerkiller.mountiplex.reflection.resolver.FieldAliasResolver;
import com.bergerkiller.mountiplex.reflection.resolver.FieldNameResolver;
import com.bergerkiller.mountiplex.reflection.resolver.MethodAliasResolver;
import com.bergerkiller.mountiplex.reflection.resolver.MethodNameResolver;
import com.bergerkiller.mountiplex.reflection.resolver.Resolver;
import com.bergerkiller.mountiplex.reflection.util.asm.MPLType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.bukkit.Bukkit;

public class CraftBukkitServer
extends CommonServerBase
implements MethodNameResolver,
FieldNameResolver,
FieldAliasResolver,
MethodAliasResolver,
ClassPathResolver {
    private static final String PACKAGE_CB_ROOT = "org.bukkit.craftbukkit";
    private static final String PACKAGE_NMS_ROOT = "net.minecraft.server";
    private static final String CB_ROOT = "org.bukkit.craftbukkit.";
    private static final String NM_ROOT = "net.minecraft.";
    public String PACKAGE_VERSION;
    public String MC_VERSION;
    public String NMS_ROOT_VERSIONED;
    public String CB_ROOT_VERSIONED;
    public String CB_ROOT_LIBS;
    private boolean HAS_MOJANG_FIELD_MAPPINGS = false;
    private boolean HAS_MOJANG_METHOD_MAPPINGS = false;
    private boolean IS_MOJANGMAP_SERVER = false;
    private boolean REMAP_TO_NMS = false;
    private MojangSpigotRemapper mojangSpigotRemapper = null;
    private SpigotMappings.ClassMappings spigotToMojangClassRemapper = null;
    private boolean isInitializingMojangSpigotRemapper = false;
    private Map<String, String> remappings = Collections.emptyMap();

    @Override
    public boolean init() {
        if (SERVER_CLASS == null) {
            return false;
        }
        this.CB_ROOT_VERSIONED = SERVER_CLASS.getPackage().getName();
        this.CB_ROOT_LIBS = "org.bukkit.craftbukkit.libs";
        if (this.CB_ROOT_VERSIONED.startsWith(CB_ROOT)) {
            this.PACKAGE_VERSION = this.CB_ROOT_VERSIONED.substring(CB_ROOT.length());
            this.NMS_ROOT_VERSIONED = "net.minecraft.server." + this.PACKAGE_VERSION;
        } else {
            this.PACKAGE_VERSION = "";
            this.NMS_ROOT_VERSIONED = PACKAGE_NMS_ROOT;
        }
        this.MC_VERSION = this.PACKAGE_VERSION;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postInit(CommonServer.PostInitEvent event) {
        block21: {
            try {
                this.MC_VERSION = new MinecraftVersionDiscovery(this.PACKAGE_VERSION).detect();
            }
            catch (VersionIdentificationFailureException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new VersionIdentificationFailureException(t);
            }
            this.HAS_MOJANG_FIELD_MAPPINGS = TextValueSequence.evaluateText(this.MC_VERSION, ">=", "1.17");
            this.HAS_MOJANG_METHOD_MAPPINGS = TextValueSequence.evaluateText(this.MC_VERSION, ">=", "1.18");
            this.REMAP_TO_NMS = TextValueSequence.evaluateText(this.MC_VERSION, "<", "1.17");
            this.IS_MOJANGMAP_SERVER = false;
            if (!this.REMAP_TO_NMS) {
                try {
                    this.isInitializingMojangSpigotRemapper = true;
                    Class<?> mojangClass = null;
                    Class<?> spigotClass = null;
                    try {
                        mojangClass = this.resolveFindClassEarly("net.minecraft.server.level.ServerPlayer");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        spigotClass = this.resolveFindClassEarly("net.minecraft.server.level.EntityPlayer");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (mojangClass == null || spigotClass != null) break block21;
                    boolean hasMojangMethod = false;
                    try {
                        MPLType.getDeclaredMethod(mojangClass, "getCamera", new Class[0]);
                        hasMojangMethod = true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (hasMojangMethod) {
                        this.IS_MOJANGMAP_SERVER = true;
                    }
                }
                finally {
                    this.isInitializingMojangSpigotRemapper = false;
                }
            }
        }
        if (!event.getResolver().isSupported(this.MC_VERSION)) {
            event.signalIncompatible("Minecraft " + this.MC_VERSION + " is not supported!");
        }
        if (this.IS_MOJANGMAP_SERVER) {
            this.mojangSpigotRemapper = null;
            this.spigotToMojangClassRemapper = SpigotMappings.fromCacheOrDownload(this.MC_VERSION);
            this.spigotToMojangClassRemapper.remapSubClass("net.minecraft.network.NetworkManager", "WrappedConsumer");
            this.spigotToMojangClassRemapper.remapSubClass("net.minecraft.network.NetworkManager", "PacketSendAction");
            this.HAS_MOJANG_FIELD_MAPPINGS = false;
            this.HAS_MOJANG_METHOD_MAPPINGS = false;
        } else if (this.HAS_MOJANG_FIELD_MAPPINGS || this.HAS_MOJANG_METHOD_MAPPINGS) {
            try {
                this.isInitializingMojangSpigotRemapper = true;
                this.mojangSpigotRemapper = MojangSpigotRemapper.load(this.MC_VERSION, this::resolveClassPathEarly);
                this.removeMethodMapping("net.minecraft.server.level.EntityPlayer", "nextContainerCounter", new String[0]);
            }
            finally {
                this.isInitializingMojangSpigotRemapper = false;
            }
        }
    }

    private void removeMethodMapping(String declaringClassName, String methodName, String ... parameterTypeNames) {
        Class<?> declaringClass;
        try {
            declaringClass = this.resolveFindClassEarly(declaringClassName);
        }
        catch (ClassNotFoundException ex) {
            Logging.LOGGER.severe("Mapping filter fail: declaring class " + declaringClassName + " not found");
            return;
        }
        Class[] paramTypes = new Class[parameterTypeNames.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            try {
                paramTypes[i] = this.resolveFindClassEarly(parameterTypeNames[i]);
                continue;
            }
            catch (ClassNotFoundException ex) {
                Logging.LOGGER.severe("Mapping filter fail: parameter[" + i + "] class " + parameterTypeNames[i] + " not found");
                return;
            }
        }
        this.mojangSpigotRemapper.removeMethodMapping(declaringClass, methodName, paramTypes);
    }

    private Class<?> resolveFindClassEarly(String path) throws ClassNotFoundException {
        return Resolver.getClassByExactName(this.resolveClassPathEarly(path));
    }

    protected String resolveClassPathEarly(String path) {
        return this.resolveClassPath(path);
    }

    @Override
    public String resolveClassPath(String path) {
        if (this.isInitializingMojangSpigotRemapper) {
            if (this.spigotToMojangClassRemapper != null) {
                return this.spigotToMojangClassRemapper.toMojang(path);
            }
            return path;
        }
        if ((path = this.remappings.getOrDefault(path, path)).startsWith(CB_ROOT) && !path.startsWith(this.CB_ROOT_VERSIONED) && !path.startsWith(this.CB_ROOT_LIBS)) {
            path = this.CB_ROOT_VERSIONED + path.substring(PACKAGE_CB_ROOT.length());
        }
        if (this.REMAP_TO_NMS && path.startsWith(NM_ROOT) && !path.startsWith(this.NMS_ROOT_VERSIONED)) {
            int index = path.length();
            String remapped = path;
            boolean isLastPart = true;
            while ((index = path.lastIndexOf(46, index - 1)) != -1) {
                if (isLastPart) {
                    isLastPart = false;
                } else if (index < path.length() && !Character.isUpperCase(path.charAt(index + 1))) break;
                remapped = this.NMS_ROOT_VERSIONED + path.substring(index);
            }
            path = remapped;
        }
        if (this.spigotToMojangClassRemapper != null) {
            path = this.spigotToMojangClassRemapper.toMojang(path);
        }
        return path;
    }

    @Override
    public String resolveFieldName(Class<?> declaringClass, String fieldName) {
        if (this.HAS_MOJANG_FIELD_MAPPINGS) {
            fieldName = this.mojangSpigotRemapper.remapFieldName(declaringClass, fieldName, fieldName);
        }
        return fieldName;
    }

    @Override
    public String resolveFieldAlias(Field field, String name) {
        if (this.HAS_MOJANG_FIELD_MAPPINGS) {
            return this.mojangSpigotRemapper.remapFieldNameReverse(field.getDeclaringClass(), name, null);
        }
        return null;
    }

    @Override
    public String resolveMethodName(Class<?> declaringClass, String methodName, Class<?>[] parameterTypes) {
        if (this.HAS_MOJANG_METHOD_MAPPINGS) {
            return this.mojangSpigotRemapper.remapMethodName(declaringClass, methodName, parameterTypes, methodName);
        }
        return methodName;
    }

    @Override
    public String resolveMethodAlias(Method method, String name) {
        if (this.HAS_MOJANG_METHOD_MAPPINGS) {
            return this.mojangSpigotRemapper.remapMethodNameReverse(method.getDeclaringClass(), name, method.getParameterTypes(), null);
        }
        return null;
    }

    @Override
    public String getMinecraftVersion() {
        return this.MC_VERSION;
    }

    @Override
    public String getServerVersion() {
        return (this.PACKAGE_VERSION.isEmpty() ? "(Unknown)" : this.PACKAGE_VERSION) + " (Minecraft " + this.MC_VERSION + ")";
    }

    @Override
    public boolean isForgeServer() {
        return false;
    }

    @Override
    public boolean isMojangMappings() {
        return this.IS_MOJANGMAP_SERVER;
    }

    @Override
    public String getServerDescription() {
        String desc = Bukkit.getServer().getVersion();
        desc = desc.replace(" (MC: " + this.MC_VERSION + ")", "");
        return desc;
    }

    @Override
    public String getServerName() {
        return "CraftBukkit";
    }

    @Override
    public String getNMSRoot() {
        return this.NMS_ROOT_VERSIONED;
    }

    @Override
    public String getCBRoot() {
        return this.CB_ROOT_VERSIONED;
    }

    public void setEarlyRemappings(Map<String, String> remappings) {
        this.remappings = remappings;
    }
}

