/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.server.test;

import com.bergerkiller.bukkit.common.internal.CommonBootstrap;
import com.bergerkiller.bukkit.common.server.CommonServerBase;
import com.bergerkiller.bukkit.common.server.test.BackgroundWorkerDefuser;
import com.bergerkiller.bukkit.common.server.test.TestServerFactory;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.mountiplex.MountiplexUtil;
import com.bergerkiller.mountiplex.reflection.ClassTemplate;
import com.bergerkiller.mountiplex.reflection.resolver.Resolver;
import com.bergerkiller.mountiplex.reflection.util.NullInstantiator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.bukkit.Bukkit;

class TestServerFactory_1_19_3
extends TestServerFactory {
    TestServerFactory_1_19_3() {
    }

    @Override
    protected void init(TestServerFactory.ServerEnvironment env) throws Throwable {
        Class<?> sharedConstantsClass = Class.forName("net.minecraft.SharedConstants");
        Method initSharedConstantsMethod = Resolver.resolveAndGetDeclaredMethod(sharedConstantsClass, "tryDetectVersion", new Class[0]);
        initSharedConstantsMethod.invoke(null, new Object[0]);
        try (BackgroundWorkerDefuser defuser = BackgroundWorkerDefuser.start(Class.forName("net.minecraft.SystemUtils"));){
            Class.forName("net.minecraft.util.datafix.DataConverterRegistry");
        }
        Class<?> dispenserRegistryClass = Class.forName("net.minecraft.server.DispenserRegistry");
        Method dispenserRegistryBootstrapMethod = Resolver.resolveAndGetDeclaredMethod(dispenserRegistryClass, "bootStrap", new Class[0]);
        dispenserRegistryBootstrapMethod.invoke(null, new Object[0]);
        ClassTemplate<? extends Bukkit> server_t = ClassTemplate.create(CommonServerBase.SERVER_CLASS);
        Bukkit server = server_t.newInstanceNull();
        env.mc_server_type = Class.forName("net.minecraft.server.MinecraftServer");
        Class<?> dedicatedType = Class.forName("net.minecraft.server.dedicated.DedicatedServer");
        ClassTemplate<?> mc_server_t = ClassTemplate.create(dedicatedType);
        Object mc_server = mc_server_t.newInstanceNull();
        env.mc_server = mc_server;
        Class<?> iAsyncTaskHandlerClass = Class.forName("net.minecraft.util.thread.IAsyncTaskHandler");
        TestServerFactory_1_19_3.setField(mc_server, iAsyncTaskHandlerClass, "name", "Server");
        TestServerFactory_1_19_3.setField(mc_server, iAsyncTaskHandlerClass, "pendingRunnables", TestServerFactory_1_19_3.createFromCode(env.mc_server_type, "return com.google.common.collect.Queues.newConcurrentLinkedQueue();"));
        TestServerFactory_1_19_3.setField(server, "logger", MountiplexUtil.LOGGER);
        TestServerFactory_1_19_3.setField(server, "console", mc_server);
        TestServerFactory_1_19_3.setField(mc_server, "serverThread", Thread.currentThread());
        TestServerFactory_1_19_3.setField(mc_server, "levels", Collections.emptyMap());
        try {
            TestServerFactory_1_19_3.setField(server, "registries", new HashMap());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.initVanillaResourceManager(env);
        env.featureFlagSet = TestServerFactory_1_19_3.createFromCode(Class.forName("net.minecraft.world.level.WorldDataConfiguration"), "return WorldDataConfiguration.DEFAULT.enabledFeatures();");
        Object registries = this.initRegistries(env);
        TestServerFactory_1_19_3.setField(mc_server, "registries", registries);
        Field bkServerField = Bukkit.class.getDeclaredField("server");
        bkServerField.setAccessible(true);
        bkServerField.set(null, server);
        String propertyManager = ClassTemplate.create("net.minecraft.server.dedicated.DedicatedServerSettings").newInstanceNull();
        TestServerFactory_1_19_3.setField(mc_server, "settings", propertyManager);
        TestServerFactory_1_19_3.setField(propertyManager, "properties", TestServerFactory_1_19_3.createFromCode(Class.forName("net.minecraft.server.dedicated.DedicatedServerProperties"), "return new DedicatedServerProperties(new java.util.Properties(), new joptsimple.OptionParser().parse(new String[0]));\n"));
        Class<?> dataConverterRegistryClass = null;
        try {
            dataConverterRegistryClass = Class.forName("net.minecraft.util.datafix.DataConverterRegistry");
            Method dataConverterRegistryInitMethod = Resolver.resolveAndGetDeclaredMethod(dataConverterRegistryClass, "getDataFixer", new Class[0]);
            Object dataConverterManager = dataConverterRegistryInitMethod.invoke(null, new Object[0]);
            TestServerFactory_1_19_3.setField(mc_server, "fixerUpper", dataConverterManager);
        }
        catch (ClassNotFoundException dataConverterRegistryInitMethod) {
            // empty catch block
        }
        TestServerFactory_1_19_3.setField(mc_server, "executor", TestServerFactory_1_19_3.createFromCode(env.mc_server_type, "return net.minecraft.SystemUtils.backgroundExecutor();"));
        this.initDataPack(env, env.mc_server_type, mc_server, registries);
        Object worldDataConfiguration = TestServerFactory_1_19_3.createFromCode(Class.forName("net.minecraft.world.level.WorldDataConfiguration"), "return WorldDataConfiguration.DEFAULT;");
        Object worldSettings = NullInstantiator.of(Class.forName("net.minecraft.world.level.WorldSettings")).create();
        TestServerFactory_1_19_3.setField(worldSettings, "dataConfiguration", worldDataConfiguration);
        Object worldData = NullInstantiator.of(Class.forName("net.minecraft.world.level.storage.WorldDataServer")).create();
        TestServerFactory_1_19_3.setField(worldData, "settings", worldSettings);
        TestServerFactory_1_19_3.setField(mc_server, "worldData", worldData);
    }

    protected Object initCustomRegistryDimension(Class<?> minecraftServerType) {
        return TestServerFactory_1_19_3.createFromCode(minecraftServerType, "return net.minecraft.core.IRegistryCustom.fromRegistryOfRegistries(net.minecraft.core.registries.BuiltInRegistries.REGISTRY);");
    }

    protected Object createVanillaResourcePackRepository() throws Throwable {
        String repopath = "net.minecraft.server.packs.repository.";
        Class<?> resourcePackRepositoryType = Class.forName("net.minecraft.server.packs.repository.ResourcePackRepository");
        ?[] resourcePackSources = LogicUtil.createArray(Class.forName("net.minecraft.server.packs.repository.ResourcePackSource"), 1);
        resourcePackSources[0] = TestServerFactory_1_19_3.construct(Class.forName("net.minecraft.server.packs.repository.ResourcePackSourceVanilla"), new Object[0]);
        return TestServerFactory_1_19_3.construct(resourcePackRepositoryType, new Object[]{resourcePackSources});
    }

    protected void initVanillaResourceManager(TestServerFactory.ServerEnvironment env) throws Throwable {
        String repopath = "net.minecraft.server.packs.repository.";
        Class<?> resourcePackRepositoryType = Class.forName("net.minecraft.server.packs.repository.ResourcePackRepository");
        Class<?> enumSourcePackTypeClass = Class.forName("net.minecraft.server.packs.EnumResourcePackType");
        Object resourcepacktype = TestServerFactory_1_19_3.getStaticField(enumSourcePackTypeClass, "SERVER_DATA");
        Object resourcepackrepository = this.createVanillaResourcePackRepository();
        TestServerFactory_1_19_3.createFromCode(resourcepackrepository.getClass(), "arg0.reload();\narg0.setSelected(java.util.Collections.singleton(\"vanilla\"));\nreturn null;", resourcepackrepository);
        List packs = (List)Resolver.resolveAndGetDeclaredMethod(resourcePackRepositoryType, "openAllSelected", new Class[0]).invoke(resourcepackrepository, new Object[0]);
        Object resourcemanager = TestServerFactory_1_19_3.construct(Class.forName("net.minecraft.server.packs.resources.ResourceManager"), resourcepacktype, packs);
        env.resourcePackRepository = resourcepackrepository;
        env.resourceManager = resourcemanager;
    }

    protected Object initRegistries(TestServerFactory.ServerEnvironment env) throws Throwable {
        Object registryAccess = TestServerFactory_1_19_3.createFromCode(env.mc_server_type, "return net.minecraft.server.RegistryLayer.createRegistryAccess();");
        env.registries = TestServerFactory_1_19_3.createFromCode(env.mc_server_type, "return net.minecraft.server.WorldLoader.loadAndReplaceLayer(\n    arg0, arg1,\n    net.minecraft.server.RegistryLayer.WORLDGEN,\n    net.minecraft.resources.RegistryDataLoader.WORLDGEN_REGISTRIES\n);", env.resourceManager, registryAccess);
        TestServerFactory_1_19_3.createFromCode(env.mc_server_type, "return net.minecraft.resources.RegistryDataLoader.load(arg0,\n            arg1.getAccessForLoading(net.minecraft.server.RegistryLayer.DIMENSIONS),\n            net.minecraft.resources.RegistryDataLoader.DIMENSION_REGISTRIES);", env.resourceManager, env.registries);
        return env.registries;
    }

    protected void initDataPack(TestServerFactory.ServerEnvironment env, Class<?> minecraftServerType, Object mc_server, Object registries) throws Throwable {
        Object datapackresources;
        Object customRegistryDimension = TestServerFactory_1_19_3.createFromCode(Class.forName("net.minecraft.core.LayeredRegistryAccess"), "return arg0.getAccessForLoading(net.minecraft.server.RegistryLayer.RELOADABLE);", registries);
        Class<?> serverTypeType = Class.forName("net.minecraft.commands.CommandDispatcher$ServerType");
        Object serverType = TestServerFactory_1_19_3.getStaticField(serverTypeType, "DEDICATED");
        int functionPermissionLevel = 2;
        Executor executor1 = CommonBootstrap.evaluateMCVersion(">=", "1.19.4") ? TestServerFactory_1_19_3.newThreadExecutor() : (Executor)Resolver.resolveAndGetDeclaredMethod(Class.forName("net.minecraft.SystemUtils"), "bootstrapExecutor", new Class[0]).invoke(null, new Object[0]);
        Executor executor2 = TestServerFactory_1_19_3.newThreadExecutor();
        Class<?> dataPackResourcesType = Class.forName("net.minecraft.server.DataPackResources");
        if (CommonBootstrap.evaluateMCVersion(">=", "1.21.2")) {
            Method startLoadingMethod = Resolver.resolveAndGetDeclaredMethod(dataPackResourcesType, "loadResources", Class.forName("net.minecraft.server.packs.resources.IResourceManager"), Class.forName("net.minecraft.core.LayeredRegistryAccess"), List.class, Class.forName("net.minecraft.world.flag.FeatureFlagSet"), serverTypeType, Integer.TYPE, Executor.class, Executor.class);
            CompletableFuture futureDPLoaded = (CompletableFuture)startLoadingMethod.invoke(null, env.resourceManager, registries, env.tagDataPackRegistries, env.featureFlagSet, serverType, functionPermissionLevel, executor1, executor2);
            datapackresources = futureDPLoaded.get();
            Class<?> datapackresourceType = Class.forName("net.minecraft.server.DataPackResources");
            Resolver.resolveAndGetDeclaredMethod(datapackresourceType, "updateStaticRegistryTags", new Class[0]).invoke(datapackresources, new Object[0]);
        } else if (CommonBootstrap.evaluateMCVersion(">=", "1.20.5")) {
            Method startLoadingMethod = Resolver.resolveAndGetDeclaredMethod(dataPackResourcesType, "loadResources", Class.forName("net.minecraft.server.packs.resources.IResourceManager"), Class.forName("net.minecraft.core.LayeredRegistryAccess"), Class.forName("net.minecraft.world.flag.FeatureFlagSet"), serverTypeType, Integer.TYPE, Executor.class, Executor.class);
            CompletableFuture futureDPLoaded = (CompletableFuture)startLoadingMethod.invoke(null, env.resourceManager, registries, env.featureFlagSet, serverType, functionPermissionLevel, executor1, executor2);
            datapackresources = futureDPLoaded.get();
            Class<?> datapackresourceType = Class.forName("net.minecraft.server.DataPackResources");
            Resolver.resolveAndGetDeclaredMethod(datapackresourceType, "updateRegistryTags", new Class[0]).invoke(datapackresources, new Object[0]);
        } else {
            Method startLoadingMethod = Resolver.resolveAndGetDeclaredMethod(dataPackResourcesType, "loadResources", Class.forName("net.minecraft.server.packs.resources.IResourceManager"), Class.forName("net.minecraft.core.IRegistryCustom$Dimension"), Class.forName("net.minecraft.world.flag.FeatureFlagSet"), serverTypeType, Integer.TYPE, Executor.class, Executor.class);
            CompletableFuture futureDPLoaded = (CompletableFuture)startLoadingMethod.invoke(null, env.resourceManager, customRegistryDimension, env.featureFlagSet, serverType, functionPermissionLevel, executor1, executor2);
            datapackresources = futureDPLoaded.get();
            Class<?> datapackresourceType = Class.forName("net.minecraft.server.DataPackResources");
            Resolver.resolveAndGetDeclaredMethod(datapackresourceType, "updateRegistryTags", Class.forName("net.minecraft.core.IRegistryCustom")).invoke(datapackresources, customRegistryDimension);
        }
        TestServerFactory_1_19_3.setField(mc_server, "packRepository", env.resourcePackRepository);
        String resourcesFieldName = Resolver.resolveFieldName(minecraftServerType, "resources");
        Field field = minecraftServerType.getDeclaredField(resourcesFieldName);
        field.setAccessible(true);
        Constructor<?> constr = field.getType().getConstructor(Class.forName("net.minecraft.server.packs.resources.IReloadableResourceManager"), Class.forName("net.minecraft.server.DataPackResources"));
        constr.setAccessible(true);
        Object managerWithResources = constr.newInstance(env.resourceManager, datapackresources);
        field.set(mc_server, managerWithResources);
    }
}

