/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.conversion.Conversion;
import com.bergerkiller.bukkit.common.internal.logic.PlayerFileDataHandler;
import com.bergerkiller.bukkit.common.nbt.CommonTag;
import com.bergerkiller.bukkit.common.nbt.CommonTagCompound;
import com.bergerkiller.bukkit.common.nbt.CommonTagList;
import com.bergerkiller.generated.net.minecraft.world.effect.MobEffectHandle;
import com.bergerkiller.generated.net.minecraft.world.entity.EntityHandle;
import com.bergerkiller.generated.net.minecraft.world.entity.EntityLivingHandle;
import com.bergerkiller.generated.net.minecraft.world.entity.player.PlayerInventoryHandle;
import com.bergerkiller.generated.net.minecraft.world.food.FoodMetaDataHandle;
import com.bergerkiller.generated.net.minecraft.world.inventory.InventoryEnderChestHandle;
import com.bergerkiller.generated.net.minecraft.world.level.block.entity.TileEntityHandle;
import com.bergerkiller.generated.org.bukkit.block.BlockStateHandle;
import java.util.Iterator;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;

public class NBTUtil {
    public static MobEffectHandle loadMobEffect(CommonTagCompound compound) {
        return MobEffectHandle.fromNBT(compound);
    }

    public static CommonTagCompound saveEntity(Entity entity, CommonTagCompound compound) {
        if (compound == null) {
            compound = new CommonTagCompound();
        }
        EntityHandle.fromBukkit(entity).saveToNBT(compound);
        return compound;
    }

    public static void loadEntity(Entity entity, CommonTagCompound compound) {
        EntityHandle.fromBukkit(entity).loadFromNBT(compound);
    }

    public static CommonTagCompound migratePlayerProfileData(CommonTagCompound playerProfileData) {
        return PlayerFileDataHandler.INSTANCE.migratePlayerData(playerProfileData);
    }

    public static CommonTagCompound saveFoodMetaData(Object foodMetaData, CommonTagCompound compound) {
        if (compound == null) {
            compound = new CommonTagCompound();
        }
        FoodMetaDataHandle.createHandle(foodMetaData).saveToNBT(compound);
        return compound;
    }

    public static void loadFoodMetaData(Object foodMetaData, CommonTagCompound compound) {
        FoodMetaDataHandle.createHandle(foodMetaData).loadFromNBT(compound);
    }

    public static CommonTagList saveInventory(Inventory inventory, CommonTagList list) {
        Object inventoryHandle = Conversion.toInventoryHandle.convert(inventory);
        if (inventoryHandle == null) {
            throw new IllegalArgumentException("This kind of inventory lacks a handle to load");
        }
        if (PlayerInventoryHandle.T.isAssignableFrom(inventoryHandle)) {
            if (list == null) {
                list = new CommonTagList();
            }
        } else {
            if (InventoryEnderChestHandle.T.isAssignableFrom(inventoryHandle)) {
                CommonTagList listSaved = InventoryEnderChestHandle.createHandle(inventoryHandle).saveToNBT();
                if (listSaved != null) {
                    Iterator iterator = listSaved.getData().iterator();
                    while (iterator.hasNext()) {
                        CommonTag savedItem = (CommonTag)iterator.next();
                        list.add(savedItem);
                    }
                }
                return list;
            }
            throw new IllegalArgumentException("This kind of inventory has an unknown type of handle: " + inventoryHandle.getClass().getName());
        }
        PlayerInventoryHandle.createHandle(inventoryHandle).saveToNBT(list);
        return list;
    }

    public static void loadInventory(Inventory inventory, CommonTagList list) {
        Object inventoryHandle = Conversion.toInventoryHandle.convert(inventory);
        if (inventoryHandle == null) {
            throw new IllegalArgumentException("This kind of inventory lacks a handle to save");
        }
        if (PlayerInventoryHandle.T.isAssignableFrom(inventoryHandle)) {
            PlayerInventoryHandle.createHandle(inventoryHandle).loadFromNBT(list);
        } else if (InventoryEnderChestHandle.T.isAssignableFrom(inventoryHandle)) {
            InventoryEnderChestHandle.createHandle(inventoryHandle).loadFromNBT(list);
        } else {
            throw new IllegalArgumentException("This kind of inventory has an unknown type of handle: " + inventoryHandle.getClass().getName());
        }
    }

    public static CommonTagCompound saveEquipment(EntityEquipment equipment) {
        if (equipment == null) {
            return CommonTagCompound.EMPTY;
        }
        Entity holder = equipment.getHolder();
        if (!(holder instanceof LivingEntity)) {
            throw new UnsupportedOperationException("Cannot save equipment of a non-living entity: " + holder);
        }
        EntityLivingHandle handle = EntityLivingHandle.fromBukkit((LivingEntity)holder);
        CommonTagCompound nbt = handle.saveEquipment();
        if (nbt == null) {
            nbt = CommonTagCompound.EMPTY;
        }
        return nbt;
    }

    public static void loadEquipment(EntityEquipment equipment, CommonTagCompound data) {
        if (equipment == null) {
            return;
        }
        Entity holder = equipment.getHolder();
        if (!(holder instanceof LivingEntity)) {
            throw new UnsupportedOperationException("Cannot load equipment for a non-living entity: " + holder);
        }
        if (data == null) {
            data = CommonTagCompound.EMPTY;
        }
        EntityLivingHandle handle = EntityLivingHandle.fromBukkit((LivingEntity)holder);
        handle.loadEquipment(data);
    }

    public static void resetAttributes(LivingEntity livingEntity) {
        EntityLivingHandle.fromBukkit(livingEntity).resetAttributes();
    }

    public static void loadAttributes(LivingEntity livingEntity, CommonTagList data) {
        if (data == null) {
            throw new IllegalArgumentException("Data can not be null");
        }
        EntityLivingHandle.fromBukkit(livingEntity).getAttributeMap().loadFromNBT(data);
    }

    public static CommonTagList saveAttributes(LivingEntity livingEntity) {
        return EntityLivingHandle.fromBukkit(livingEntity).getAttributeMap().saveToNBT();
    }

    public static void loadBlockState(BlockState blockState, CommonTagCompound data) {
        TileEntityHandle.fromBukkit(blockState).load(BlockStateHandle.T.getBlockData.invoke(blockState), data);
    }

    public static CommonTagCompound saveBlockState(BlockState blockState) {
        return TileEntityHandle.fromBukkit(blockState).save();
    }

    @Deprecated
    public static CommonTagCompound saveBlockState(BlockState blockState, CommonTagCompound data) {
        CommonTagCompound savedData = TileEntityHandle.fromBukkit(blockState).save();
        if (data != null) {
            data.putAll(savedData);
            return data;
        }
        return savedData;
    }
}

