/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.wrappers;

import com.bergerkiller.generated.net.minecraft.world.EnumHandHandle;
import com.bergerkiller.generated.org.bukkit.entity.HumanEntityHandle;
import com.bergerkiller.generated.org.bukkit.inventory.MainHandHandle;
import com.bergerkiller.generated.org.bukkit.inventory.PlayerInventoryHandle;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;

public enum HumanHand {
    LEFT,
    RIGHT;


    public final HumanHand opposite() {
        return this == LEFT ? RIGHT : LEFT;
    }

    public Object toMainHand() {
        return HumanHand.toMainHand(this);
    }

    public Object toNMSEnumHand(HumanEntity humanEntity) {
        return HumanHand.toNMSEnumHand(humanEntity, this);
    }

    public static HumanHand fromMainHand(Object mainHand) {
        if (!MainHandHandle.T.isAvailable()) {
            return RIGHT;
        }
        if (MainHandHandle.T.isAssignableFrom(mainHand)) {
            if (MainHandHandle.LEFT.getRaw() == mainHand) {
                return LEFT;
            }
            return RIGHT;
        }
        return null;
    }

    public static HumanHand getMainHand(HumanEntity humanEntity) {
        return HumanEntityHandle.T.getMainHumanHand.invoke(humanEntity);
    }

    public static HumanHand getOffHand(HumanEntity humanEntity) {
        return HumanHand.getMainHand(humanEntity).opposite();
    }

    public static Object toMainHand(HumanHand hand) {
        if (hand == null) {
            return null;
        }
        if (MainHandHandle.T.isAvailable()) {
            return hand == LEFT ? MainHandHandle.LEFT.getRaw() : MainHandHandle.RIGHT.getRaw();
        }
        return null;
    }

    public static HumanHand fromNMSEnumHand(HumanEntity humanEntity, Object nmsEnumHand) {
        if (nmsEnumHand != null && EnumHandHandle.T.isAvailable()) {
            HumanHand hand;
            HumanHand humanHand = hand = nmsEnumHand == EnumHandHandle.OFF_HAND.getRaw() ? LEFT : RIGHT;
            if (HumanHand.getMainHand(humanEntity) == LEFT) {
                hand = hand == RIGHT ? LEFT : RIGHT;
            }
            return hand;
        }
        return null;
    }

    public static Object toNMSEnumHand(HumanEntity humanEntity, HumanHand humanHand) {
        if (EnumHandHandle.T.isAvailable()) {
            if (HumanHand.getMainHand(humanEntity) == humanHand) {
                return EnumHandHandle.MAIN_HAND.getRaw();
            }
            return EnumHandHandle.OFF_HAND.getRaw();
        }
        return null;
    }

    public static ItemStack getHeldItem(HumanEntity humanEntity, HumanHand humanHand) {
        if (humanEntity == null) {
            throw new IllegalArgumentException("humanEntity can not be null");
        }
        if (humanHand == HumanHand.getMainHand(humanEntity)) {
            return HumanHand.getItemInMainHand(humanEntity);
        }
        return HumanHand.getItemInOffHand(humanEntity);
    }

    public static void setHeldItem(HumanEntity humanEntity, HumanHand humanHand, ItemStack item) {
        if (humanEntity == null) {
            throw new IllegalArgumentException("humanEntity can not be null");
        }
        if (humanHand == HumanHand.getMainHand(humanEntity)) {
            HumanHand.setItemInMainHand(humanEntity, item);
        } else {
            HumanHand.setItemInOffHand(humanEntity, item);
        }
    }

    public static ItemStack getItemInMainHand(HumanEntity humanEntity) {
        return PlayerInventoryHandle.T.getItemInMainHand.invoke(humanEntity.getInventory());
    }

    public static ItemStack getItemInOffHand(HumanEntity humanEntity) {
        return PlayerInventoryHandle.T.getItemInOffHand.invoke(humanEntity.getInventory());
    }

    public static void setItemInMainHand(HumanEntity humanEntity, ItemStack item) {
        if (humanEntity == null) {
            throw new IllegalArgumentException("humanEntity can not be null");
        }
        if (PlayerInventoryHandle.T.setItemInMainHand.isAvailable()) {
            PlayerInventoryHandle.T.setItemInMainHand.invoke(humanEntity.getInventory(), item);
        } else if (PlayerInventoryHandle.T.setItemInHand.isAvailable()) {
            PlayerInventoryHandle.T.setItemInHand.invoke(humanEntity.getInventory(), item);
        }
    }

    public static void setItemInOffHand(HumanEntity humanEntity, ItemStack item) {
        if (humanEntity == null) {
            throw new IllegalArgumentException("humanEntity can not be null");
        }
        if (PlayerInventoryHandle.T.setItemInOffHand.isAvailable()) {
            PlayerInventoryHandle.T.setItemInOffHand.invoke(humanEntity.getInventory(), item);
        }
    }
}

