/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.generated.net.minecraft.nbt;

import com.bergerkiller.bukkit.common.Common;
import com.bergerkiller.bukkit.common.Logging;
import com.bergerkiller.bukkit.common.collections.ClassMap;
import com.bergerkiller.bukkit.common.conversion.Conversion;
import com.bergerkiller.bukkit.common.internal.CommonCapabilities;
import com.bergerkiller.bukkit.common.nbt.CommonTag;
import com.bergerkiller.generated.net.minecraft.nbt.NBTTagCompoundHandle;
import com.bergerkiller.generated.net.minecraft.nbt.NBTTagListHandle;
import com.bergerkiller.mountiplex.reflection.declarations.Template;
import com.bergerkiller.mountiplex.reflection.util.BoxedType;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

@Template.InstanceType(value="net.minecraft.nbt.NBTBase")
public abstract class NBTBaseHandle
extends Template.Handle {
    public static final NBTBaseClass T = Template.Class.create(NBTBaseClass.class, Common.TEMPLATE_RESOLVER);
    private static TypeInfoLookup lookup = null;

    public static NBTBaseHandle createHandle(Object handleInstance) {
        return (NBTBaseHandle)T.createHandle(handleInstance);
    }

    public abstract byte getTypeId();

    public abstract Object raw_clone();

    public CommonTag toCommonTag() {
        return new CommonTag(this);
    }

    public abstract NBTBaseHandle clone();

    public abstract Object getData();

    public final String toPrettyString() {
        StringBuilder str = new StringBuilder(100);
        this.toPrettyString(str, 0);
        return str.toString();
    }

    public void toPrettyString(StringBuilder str, int indent) {
        while (indent-- > 0) {
            str.append("  ");
        }
        Object data = this.getData();
        if (data == null) {
            str.append("UNKNOWN[").append(this.getTypeId()).append("]");
        } else {
            Class<?> unboxedType = BoxedType.getUnboxedType(data.getClass());
            if (unboxedType != null) {
                str.append(unboxedType.getSimpleName());
            } else {
                str.append(data.getClass().getSimpleName());
            }
            str.append(": ");
            if (data instanceof byte[]) {
                byte[] values = (byte[])data;
                str.append("[");
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        str.append(", ");
                    }
                    str.append(values[i]);
                }
                str.append("]");
            } else if (data instanceof int[]) {
                int[] values = (int[])data;
                str.append("[");
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        str.append(", ");
                    }
                    str.append(values[i]);
                }
                str.append("]");
            } else if (data instanceof long[]) {
                long[] values = (long[])data;
                str.append("[");
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        str.append(", ");
                    }
                    str.append(values[i]);
                }
                str.append("]");
            } else {
                str.append(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeInfoLookup lookup() {
        TypeInfoLookup lookup = NBTBaseHandle.lookup;
        if (lookup != null) {
            return lookup;
        }
        Class<NBTBaseHandle> clazz = NBTBaseHandle.class;
        synchronized (NBTBaseHandle.class) {
            lookup = NBTBaseHandle.lookup;
            if (lookup != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return lookup;
            }
            NBTBaseHandle.lookup = lookup = new TypeInfoLookup();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return lookup;
        }
    }

    private static TypeInfo findTypeInfo(Object data) {
        if (data == null) {
            throw new IllegalArgumentException("Can not find tag type information for null data");
        }
        TypeInfoLookup lookup = NBTBaseHandle.lookup();
        TypeInfo info = lookup.byType.get(data.getClass());
        if (info != null) {
            return info;
        }
        if (data instanceof CommonTag) {
            TypeInfo handle_info = NBTBaseHandle.findTypeInfo(((CommonTag)data).getRawHandle());
            return new TypeInfo(handle_info.dataType, handle_info.handleClass, tag -> ((CommonTag)data).getRawHandle(), tag -> handle_info.get_data.apply(((CommonTag)data).getRawHandle()));
        }
        return lookup.toStringFallback;
    }

    public static boolean isDataSupportedNatively(Object data) {
        TypeInfoLookup lookup = NBTBaseHandle.lookup();
        return lookup.byType.get(data) != null || data instanceof CommonTag;
    }

    public static Object getDataForHandle(Object handle) {
        return NBTBaseHandle.findTypeInfo((Object)handle).get_data.apply(handle);
    }

    public static Object createRawHandleForData(Object data) {
        return NBTBaseHandle.findTypeInfo((Object)data).constructor.apply(data);
    }

    public static NBTBaseHandle createHandleForData(Object data) {
        TypeInfo info = NBTBaseHandle.findTypeInfo(data);
        return info.handleClass.createHandle(info.constructor.apply(data));
    }

    public static Consumer<String> createPartialErrorLogger(Object nbtBase) {
        return s -> {
            String nbtToStr = nbtBase == null ? "[null]" : nbtBase.toString();
            Logging.LOGGER.severe("Failed to read (" + nbtToStr + "): " + s);
        };
    }

    public static final class NBTBaseClass
    extends Template.Class<NBTBaseHandle> {
        public final Template.StaticMethod<NBTBaseHandle> createHandle = new Template.StaticMethod();
        public final Template.Method<Byte> getTypeId = new Template.Method();
        public final Template.Method<Object> raw_clone = new Template.Method();
    }

    private static class TypeInfoLookup {
        public final ClassMap<TypeInfo> byType = new ClassMap();
        public final TypeInfo toStringFallback = new TypeInfo(String.class, NBTTagStringHandle.T, data -> ((Template.StaticMethod)NBTTagStringHandle.T.create.raw).invoke(Conversion.toString.convert(data, "")), Function.identity());

        public TypeInfoLookup() {
            this.registerTypeInfo(String.class, NBTTagStringHandle.T, ((Template.StaticMethod)NBTTagStringHandle.T.create.raw)::invoke, NBTTagStringHandle.T.getData::invoke);
            this.registerTypeInfo(Byte.TYPE, NBTTagByteHandle.T, ((Template.StaticMethod)NBTTagByteHandle.T.create.raw)::invoke, NBTTagByteHandle.T.getByteData::invoke);
            this.registerTypeInfo(Short.TYPE, NBTTagShortHandle.T, ((Template.StaticMethod)NBTTagShortHandle.T.create.raw)::invoke, NBTTagShortHandle.T.getShortData::invoke);
            this.registerTypeInfo(Integer.TYPE, NBTTagIntHandle.T, ((Template.StaticMethod)NBTTagIntHandle.T.create.raw)::invoke, NBTTagIntHandle.T.getIntegerData::invoke);
            this.registerTypeInfo(Long.TYPE, NBTTagLongHandle.T, ((Template.StaticMethod)NBTTagLongHandle.T.create.raw)::invoke, NBTTagLongHandle.T.getLongData::invoke);
            this.registerTypeInfo(Float.TYPE, NBTTagFloatHandle.T, ((Template.StaticMethod)NBTTagFloatHandle.T.create.raw)::invoke, NBTTagFloatHandle.T.getFloatData::invoke);
            this.registerTypeInfo(Double.TYPE, NBTTagDoubleHandle.T, ((Template.StaticMethod)NBTTagDoubleHandle.T.create.raw)::invoke, NBTTagDoubleHandle.T.getDoubleData::invoke);
            this.registerTypeInfo(byte[].class, NBTTagByteArrayHandle.T, ((Template.StaticMethod)NBTTagByteArrayHandle.T.create.raw)::invoke, NBTTagByteArrayHandle.T.getData::invoke);
            this.registerTypeInfo(int[].class, NBTTagIntArrayHandle.T, ((Template.StaticMethod)NBTTagIntArrayHandle.T.create.raw)::invoke, NBTTagIntArrayHandle.T.getData::invoke);
            if (NBTTagLongArrayHandle.T.isAvailable()) {
                this.registerTypeInfo(long[].class, NBTTagLongArrayHandle.T, ((Template.StaticMethod)NBTTagLongArrayHandle.T.create.raw)::invoke, NBTTagLongArrayHandle.T.getData::invoke);
            }
            this.registerTypeInfo(Collection.class, NBTTagListHandle.T, ((Template.StaticMethod)NBTTagListHandle.T.create.raw)::invoke, ((Template.Field)NBTTagListHandle.T.data.raw)::get);
            this.registerTypeInfo(Map.class, NBTTagCompoundHandle.T, ((Template.StaticMethod)NBTTagCompoundHandle.T.create.raw)::invoke, ((Template.Field)NBTTagCompoundHandle.T.data.raw)::get);
        }

        private void registerTypeInfo(Class<?> dataType, Template.Class<? extends NBTBaseHandle> handleClass, Function<Object, Object> constructor, Function<Object, Object> get_data) {
            TypeInfo data_typeInfo = new TypeInfo(dataType, handleClass, constructor, Function.identity());
            this.byType.put(dataType, data_typeInfo);
            Class<?> boxedDataType = BoxedType.getBoxedType(dataType);
            if (boxedDataType != null) {
                this.byType.put(boxedDataType, data_typeInfo);
            }
            this.byType.put(handleClass.getType(), new TypeInfo(dataType, handleClass, Function.identity(), get_data));
            this.byType.put(handleClass.getHandleType(), new TypeInfo(dataType, handleClass, handle -> ((Template.Handle)handle).getRaw(), handle -> get_data.apply(((Template.Handle)handle).getRaw())));
            handleClass.createHandle(null, true);
        }
    }

    private static final class TypeInfo {
        public final Class<?> dataType;
        public final Template.Class<? extends NBTBaseHandle> handleClass;
        public final Function<Object, Object> constructor;
        public final Function<Object, Object> get_data;

        public TypeInfo(Class<?> dataType, Template.Class<? extends NBTBaseHandle> handleClass, Function<Object, Object> constructor, Function<Object, Object> get_data) {
            this.dataType = dataType;
            this.handleClass = handleClass;
            this.constructor = constructor;
            this.get_data = get_data;
        }
    }

    @Template.Optional
    @Template.InstanceType(value="net.minecraft.nbt.NBTTagLongArray")
    public static abstract class NBTTagLongArrayHandle
    extends NBTBaseHandle {
        public static final NBTTagLongArrayClass T = Template.Class.create(NBTTagLongArrayClass.class, Common.TEMPLATE_RESOLVER);

        public static NBTTagLongArrayHandle createHandle(Object handleInstance) {
            return (NBTTagLongArrayHandle)T.createHandle(handleInstance);
        }

        public static NBTTagLongArrayHandle create(long[] data) {
            return NBTTagLongArrayHandle.T.create.invoke(data);
        }

        public abstract long[] getData();

        public static final class NBTTagLongArrayClass
        extends Template.Class<NBTTagLongArrayHandle> {
            public final Template.StaticMethod.Converted<NBTTagLongArrayHandle> create = new Template.StaticMethod.Converted();
            public final Template.Method<long[]> getData = new Template.Method();
        }
    }

    @Template.InstanceType(value="net.minecraft.nbt.NBTTagIntArray")
    public static abstract class NBTTagIntArrayHandle
    extends NBTBaseHandle {
        public static final NBTTagIntArrayClass T = Template.Class.create(NBTTagIntArrayClass.class, Common.TEMPLATE_RESOLVER);

        public static NBTTagIntArrayHandle createHandle(Object handleInstance) {
            return (NBTTagIntArrayHandle)T.createHandle(handleInstance);
        }

        public static NBTTagIntArrayHandle create(int[] data) {
            return NBTTagIntArrayHandle.T.create.invoke(data);
        }

        public abstract int[] getData();

        public static final class NBTTagIntArrayClass
        extends Template.Class<NBTTagIntArrayHandle> {
            public final Template.StaticMethod.Converted<NBTTagIntArrayHandle> create = new Template.StaticMethod.Converted();
            public final Template.Method<int[]> getData = new Template.Method();
        }
    }

    @Template.InstanceType(value="net.minecraft.nbt.NBTTagByteArray")
    public static abstract class NBTTagByteArrayHandle
    extends NBTBaseHandle {
        public static final NBTTagByteArrayClass T = Template.Class.create(NBTTagByteArrayClass.class, Common.TEMPLATE_RESOLVER);

        public static NBTTagByteArrayHandle createHandle(Object handleInstance) {
            return (NBTTagByteArrayHandle)T.createHandle(handleInstance);
        }

        public static NBTTagByteArrayHandle create(byte[] data) {
            return NBTTagByteArrayHandle.T.create.invoke(data);
        }

        public abstract byte[] getData();

        public static final class NBTTagByteArrayClass
        extends Template.Class<NBTTagByteArrayHandle> {
            public final Template.StaticMethod.Converted<NBTTagByteArrayHandle> create = new Template.StaticMethod.Converted();
            public final Template.Method<byte[]> getData = new Template.Method();
        }
    }

    @Template.InstanceType(value="net.minecraft.nbt.NBTTagDouble")
    public static abstract class NBTTagDoubleHandle
    extends NBTBaseHandle {
        public static final NBTTagDoubleClass T = Template.Class.create(NBTTagDoubleClass.class, Common.TEMPLATE_RESOLVER);

        public static NBTTagDoubleHandle createHandle(Object handleInstance) {
            return (NBTTagDoubleHandle)T.createHandle(handleInstance);
        }

        public static NBTTagDoubleHandle create(double data) {
            return NBTTagDoubleHandle.T.create.invoke(data);
        }

        public abstract double getDoubleData();

        @Override
        public NBTTagDoubleHandle clone() {
            return CommonCapabilities.IMMUTABLE_NBT_PRIMITIVES ? this : NBTTagDoubleHandle.createHandle(this.raw_clone());
        }

        @Override
        public Double getData() {
            return this.getDoubleData();
        }

        public static final class NBTTagDoubleClass
        extends Template.Class<NBTTagDoubleHandle> {
            public final Template.StaticMethod.Converted<NBTTagDoubleHandle> create = new Template.StaticMethod.Converted();
            public final Template.Method<Double> getDoubleData = new Template.Method();
        }
    }

    @Template.InstanceType(value="net.minecraft.nbt.NBTTagFloat")
    public static abstract class NBTTagFloatHandle
    extends NBTBaseHandle {
        public static final NBTTagFloatClass T = Template.Class.create(NBTTagFloatClass.class, Common.TEMPLATE_RESOLVER);

        public static NBTTagFloatHandle createHandle(Object handleInstance) {
            return (NBTTagFloatHandle)T.createHandle(handleInstance);
        }

        public static NBTTagFloatHandle create(float data) {
            return NBTTagFloatHandle.T.create.invoke(Float.valueOf(data));
        }

        public abstract float getFloatData();

        @Override
        public NBTTagFloatHandle clone() {
            return CommonCapabilities.IMMUTABLE_NBT_PRIMITIVES ? this : NBTTagFloatHandle.createHandle(this.raw_clone());
        }

        @Override
        public Float getData() {
            return Float.valueOf(this.getFloatData());
        }

        public static final class NBTTagFloatClass
        extends Template.Class<NBTTagFloatHandle> {
            public final Template.StaticMethod.Converted<NBTTagFloatHandle> create = new Template.StaticMethod.Converted();
            public final Template.Method<Float> getFloatData = new Template.Method();
        }
    }

    @Template.InstanceType(value="net.minecraft.nbt.NBTTagLong")
    public static abstract class NBTTagLongHandle
    extends NBTBaseHandle {
        public static final NBTTagLongClass T = Template.Class.create(NBTTagLongClass.class, Common.TEMPLATE_RESOLVER);

        public static NBTTagLongHandle createHandle(Object handleInstance) {
            return (NBTTagLongHandle)T.createHandle(handleInstance);
        }

        public static NBTTagLongHandle create(long data) {
            return NBTTagLongHandle.T.create.invoke(data);
        }

        public abstract long getLongData();

        @Override
        public NBTTagLongHandle clone() {
            return CommonCapabilities.IMMUTABLE_NBT_PRIMITIVES ? this : NBTTagLongHandle.createHandle(this.raw_clone());
        }

        @Override
        public Long getData() {
            return this.getLongData();
        }

        public static final class NBTTagLongClass
        extends Template.Class<NBTTagLongHandle> {
            public final Template.StaticMethod.Converted<NBTTagLongHandle> create = new Template.StaticMethod.Converted();
            public final Template.Method<Long> getLongData = new Template.Method();
        }
    }

    @Template.InstanceType(value="net.minecraft.nbt.NBTTagInt")
    public static abstract class NBTTagIntHandle
    extends NBTBaseHandle {
        public static final NBTTagIntClass T = Template.Class.create(NBTTagIntClass.class, Common.TEMPLATE_RESOLVER);

        public static NBTTagIntHandle createHandle(Object handleInstance) {
            return (NBTTagIntHandle)T.createHandle(handleInstance);
        }

        public static NBTTagIntHandle create(int data) {
            return NBTTagIntHandle.T.create.invoke(data);
        }

        public abstract int getIntegerData();

        @Override
        public NBTTagIntHandle clone() {
            return CommonCapabilities.IMMUTABLE_NBT_PRIMITIVES ? this : NBTTagIntHandle.createHandle(this.raw_clone());
        }

        @Override
        public Integer getData() {
            return this.getIntegerData();
        }

        public static final class NBTTagIntClass
        extends Template.Class<NBTTagIntHandle> {
            public final Template.StaticMethod.Converted<NBTTagIntHandle> create = new Template.StaticMethod.Converted();
            public final Template.Method<Integer> getIntegerData = new Template.Method();
        }
    }

    @Template.InstanceType(value="net.minecraft.nbt.NBTTagShort")
    public static abstract class NBTTagShortHandle
    extends NBTBaseHandle {
        public static final NBTTagShortClass T = Template.Class.create(NBTTagShortClass.class, Common.TEMPLATE_RESOLVER);

        public static NBTTagShortHandle createHandle(Object handleInstance) {
            return (NBTTagShortHandle)T.createHandle(handleInstance);
        }

        public static NBTTagShortHandle create(short data) {
            return NBTTagShortHandle.T.create.invoke(data);
        }

        public abstract short getShortData();

        public static Object createRaw(Object data) {
            return ((Template.StaticMethod)NBTTagShortHandle.T.create.raw).invoke(data);
        }

        @Override
        public NBTTagShortHandle clone() {
            return CommonCapabilities.IMMUTABLE_NBT_PRIMITIVES ? this : NBTTagShortHandle.createHandle(this.raw_clone());
        }

        @Override
        public Short getData() {
            return this.getShortData();
        }

        public static final class NBTTagShortClass
        extends Template.Class<NBTTagShortHandle> {
            public final Template.StaticMethod.Converted<NBTTagShortHandle> create = new Template.StaticMethod.Converted();
            public final Template.Method<Short> getShortData = new Template.Method();
        }
    }

    @Template.InstanceType(value="net.minecraft.nbt.NBTTagByte")
    public static abstract class NBTTagByteHandle
    extends NBTBaseHandle {
        public static final NBTTagByteClass T = Template.Class.create(NBTTagByteClass.class, Common.TEMPLATE_RESOLVER);

        public static NBTTagByteHandle createHandle(Object handleInstance) {
            return (NBTTagByteHandle)T.createHandle(handleInstance);
        }

        public static NBTTagByteHandle create(byte data) {
            return NBTTagByteHandle.T.create.invoke(data);
        }

        public abstract byte getByteData();

        @Override
        public NBTTagByteHandle clone() {
            return CommonCapabilities.IMMUTABLE_NBT_PRIMITIVES ? this : NBTTagByteHandle.createHandle(this.raw_clone());
        }

        @Override
        public Byte getData() {
            return this.getByteData();
        }

        public static final class NBTTagByteClass
        extends Template.Class<NBTTagByteHandle> {
            public final Template.StaticMethod.Converted<NBTTagByteHandle> create = new Template.StaticMethod.Converted();
            public final Template.Method<Byte> getByteData = new Template.Method();
        }
    }

    @Template.InstanceType(value="net.minecraft.nbt.NBTTagString")
    public static abstract class NBTTagStringHandle
    extends NBTBaseHandle {
        public static final NBTTagStringClass T = Template.Class.create(NBTTagStringClass.class, Common.TEMPLATE_RESOLVER);

        public static NBTTagStringHandle createHandle(Object handleInstance) {
            return (NBTTagStringHandle)T.createHandle(handleInstance);
        }

        public static NBTTagStringHandle create(String data) {
            return NBTTagStringHandle.T.create.invoke(data);
        }

        @Override
        public abstract String getData();

        @Override
        public NBTTagStringHandle clone() {
            return CommonCapabilities.IMMUTABLE_NBT_PRIMITIVES ? this : NBTTagStringHandle.createHandle(this.raw_clone());
        }

        public static final class NBTTagStringClass
        extends Template.Class<NBTTagStringHandle> {
            public final Template.StaticMethod.Converted<NBTTagStringHandle> create = new Template.StaticMethod.Converted();
            public final Template.Method<String> getData = new Template.Method();
        }
    }
}

