/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.generated.net.minecraft.server.network;

import com.bergerkiller.bukkit.common.Common;
import com.bergerkiller.bukkit.common.Logging;
import com.bergerkiller.bukkit.common.conversion.type.HandleConversion;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.generated.net.minecraft.network.NetworkManagerHandle;
import com.bergerkiller.generated.net.minecraft.server.level.EntityPlayerHandle;
import com.bergerkiller.mountiplex.reflection.declarations.Template;
import com.bergerkiller.mountiplex.reflection.util.FastField;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@Template.InstanceType(value="net.minecraft.server.network.PlayerConnection")
public abstract class PlayerConnectionHandle
extends Template.Handle {
    public static final PlayerConnectionClass T = Template.Class.create(PlayerConnectionClass.class, Common.TEMPLATE_RESOLVER);
    private static final QueuePacketMethod defaultQueuePacketMethod = NetworkManagerHandle::queuePacketUnsafe;
    private static final Map<Class<?>, QueuePacketMethod> queuePacketMethods = new ConcurrentHashMap(5, 0.75f, 2);

    public static PlayerConnectionHandle createHandle(Object handleInstance) {
        return (PlayerConnectionHandle)T.createHandle(handleInstance);
    }

    public abstract Object getNetworkManager();

    public abstract void sendPacket(Object var1);

    public abstract void sendPos(double var1, double var3, double var5);

    public abstract void resetAwaitTeleport();

    private static QueuePacketMethod findPacketMethod(Class<?> networkManagerType) throws Throwable {
        String typeName = networkManagerType.getName();
        if (typeName.startsWith("com.denizenscript.denizen.nms.") && typeName.endsWith("DenizenNetworkManagerImpl")) {
            FastField oldManagerField = new FastField();
            oldManagerField.init(networkManagerType.getDeclaredField("oldManager"));
            oldManagerField.forceInitialization();
            return (networkManager, packet) -> {
                Object oldManager = oldManagerField.get(networkManager);
                return PlayerConnectionHandle.queuePacket(oldManager, packet);
            };
        }
        if (typeName.startsWith("com.denizenscript.denizen.nms.") && typeName.endsWith("FakeNetworkManagerImpl")) {
            return defaultQueuePacketMethod;
        }
        return null;
    }

    private static boolean queuePacket(Object networkManager, Object packet) {
        if (networkManager != null) {
            QueuePacketMethod method = queuePacketMethods.get(networkManager.getClass());
            if (method == null) {
                try {
                    method = PlayerConnectionHandle.findPacketMethod(networkManager.getClass());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (method != null) {
                    queuePacketMethods.put(networkManager.getClass(), method);
                } else {
                    queuePacketMethods.put(networkManager.getClass(), (n, p) -> false);
                    Logging.LOGGER_NETWORK.warning("Unsupported NetworkManager detected: " + networkManager.getClass().getName());
                    return false;
                }
            }
            if (method.queuePacket(networkManager, packet)) {
                return true;
            }
        }
        return false;
    }

    public void queuePacket(Object packet) {
        if (!PlayerConnectionHandle.queuePacket(this.getNetworkManager(), packet)) {
            CommonUtil.nextTick(() -> this.sendPacket(packet));
        }
    }

    public boolean isConnected() {
        return NetworkManagerHandle.T.isConnected.invoke(this.getNetworkManager());
    }

    public static PlayerConnectionHandle forPlayer(Player player) {
        Object handle = HandleConversion.toEntityHandle((Entity)player);
        PlayerConnectionHandle connection = EntityPlayerHandle.T.playerConnection.get(handle);
        if (connection == null || !connection.isConnected()) {
            return null;
        }
        return connection;
    }

    static {
        queuePacketMethods.put(NetworkManagerHandle.T.getType(), defaultQueuePacketMethod);
    }

    public static final class PlayerConnectionClass
    extends Template.Class<PlayerConnectionHandle> {
        public final Template.Method<Object> getNetworkManager = new Template.Method();
        public final Template.Method.Converted<Void> sendPacket = new Template.Method.Converted();
        public final Template.Method<Void> sendPos = new Template.Method();
        public final Template.Method<Void> resetAwaitTeleport = new Template.Method();
    }

    private static interface QueuePacketMethod {
        public boolean queuePacket(Object var1, Object var2);
    }
}

