/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.itemrestrictions.data;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.data.serializer.ArcSerializer;
import com.daqem.arc.registry.ArcRegistry;
import com.daqem.itemrestrictions.ItemRestrictions;
import com.daqem.itemrestrictions.data.RestrictionResult;
import com.daqem.itemrestrictions.data.RestrictionType;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class ItemRestriction {
    private final ResourceLocation location;
    private final ItemStack icon;
    private final List<RestrictionType> restrictionTypes;
    private final List<ICondition> conditions;

    public ItemRestriction(ResourceLocation location, ItemStack icon, List<RestrictionType> restrictionTypes, List<ICondition> conditions) {
        this.location = location;
        this.icon = icon;
        this.restrictionTypes = restrictionTypes;
        this.conditions = conditions;
    }

    public RestrictionResult isRestricted(ActionData actionData) {
        ItemStack itemStack = (ItemStack)actionData.getData(ActionDataType.ITEM_STACK);
        if (itemStack == null) {
            return new RestrictionResult();
        }
        boolean allConditionsMet = this.conditions.stream().allMatch(condition -> condition.isMet(actionData) && !condition.isInverted() || !condition.isMet(actionData) && condition.isInverted());
        if (allConditionsMet) {
            return new RestrictionResult(this.restrictionTypes);
        }
        return new RestrictionResult();
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public List<ICondition> getConditions() {
        return this.conditions;
    }

    public List<RestrictionType> getRestrictionTypes() {
        return this.restrictionTypes;
    }

    public static class Serializer
    implements JsonDeserializer<ItemRestriction>,
    ArcSerializer {
        public ItemRestriction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            ResourceLocation location = this.getResourceLocation(jsonObject, "location");
            JsonArray restrictionTypesArray = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"types");
            JsonArray conditionsArray = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"conditions");
            ArrayList<RestrictionType> restrictionTypes = new ArrayList<RestrictionType>();
            ArrayList<ICondition> conditions = new ArrayList<ICondition>();
            ItemStack iconStack = ItemStack.EMPTY;
            if (jsonObject.has("icon")) {
                iconStack = this.getItemStack((JsonElement)jsonObject.getAsJsonObject("icon"));
            }
            restrictionTypesArray.forEach(jsonElement -> {
                String restrictionTypeString = jsonElement.getAsString();
                try {
                    RestrictionType restrictionType = RestrictionType.valueOf(restrictionTypeString.toUpperCase());
                    restrictionTypes.add(restrictionType);
                }
                catch (IllegalArgumentException e) {
                    ItemRestrictions.LOGGER.error("Could not deserialize restriction type {} because: {}", (Object)restrictionTypeString, (Object)e.getMessage());
                }
            });
            conditionsArray.forEach(jsonElement -> {
                ResourceLocation conditionTypeLocation = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)jsonElement.getAsJsonObject(), (String)"type"));
                ArcRegistry.CONDITION.getOptional(conditionTypeLocation).ifPresent(conditionType -> conditions.add(conditionType.getSerializer().fromJson(ResourceLocation.parse((String)""), jsonElement.getAsJsonObject())));
            });
            return new ItemRestriction(location, iconStack, restrictionTypes, conditions);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, ItemRestriction itemRestriction) {
            buf.writeResourceLocation(itemRestriction.location);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)itemRestriction.icon);
            buf.writeCollection(itemRestriction.restrictionTypes, (byteBuf, restrictionType) -> byteBuf.writeUtf(restrictionType.name()));
            buf.writeCollection(itemRestriction.conditions, (byteBuf, condition) -> IConditionSerializer.toNetwork((ICondition)condition, (RegistryFriendlyByteBuf)((RegistryFriendlyByteBuf)byteBuf), (ResourceLocation)itemRestriction.getLocation()));
        }

        public static ItemRestriction fromNetwork(RegistryFriendlyByteBuf buf) {
            ResourceLocation location = buf.readResourceLocation();
            ItemStack icon = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            List restrictionTypeStrings = buf.readList(FriendlyByteBuf::readUtf);
            ArrayList<RestrictionType> restrictionTypes = new ArrayList<RestrictionType>();
            restrictionTypeStrings.forEach(restrictionTypeString -> {
                try {
                    RestrictionType restrictionType = RestrictionType.valueOf(restrictionTypeString.toUpperCase());
                    restrictionTypes.add(restrictionType);
                }
                catch (IllegalArgumentException e) {
                    ItemRestrictions.LOGGER.error("Could not deserialize restriction type {} because: {}", restrictionTypeString, (Object)e.getMessage());
                }
            });
            List conditions = buf.readList(object -> IConditionSerializer.fromNetwork((RegistryFriendlyByteBuf)((RegistryFriendlyByteBuf)object)));
            return new ItemRestriction(location, icon, restrictionTypes, conditions);
        }
    }
}

